/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plan.storage.database;

import com.djrapitops.plan.exceptions.database.DBInitException;
import com.djrapitops.plan.identification.ServerInfo;
import com.djrapitops.plan.settings.config.PlanConfig;
import com.djrapitops.plan.settings.config.paths.DatabaseSettings;
import com.djrapitops.plan.settings.locale.Locale;
import com.djrapitops.plan.storage.database.DBType;
import com.djrapitops.plan.storage.database.SQLDB;
import com.djrapitops.plan.storage.file.PlanFiles;
import com.djrapitops.plan.storage.upkeep.DBKeepAliveTask;
import com.djrapitops.plan.utilities.MiscUtils;
import com.djrapitops.plan.utilities.java.ThrowableUtils;
import com.djrapitops.plan.utilities.logging.ErrorLogger;
import com.djrapitops.plugin.logging.console.PluginLogger;
import com.djrapitops.plugin.task.PluginTask;
import com.djrapitops.plugin.task.RunnableFactory;
import java.io.File;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Objects;
import plan.dagger.Lazy;
import plan.javax.inject.Inject;
import plan.javax.inject.Singleton;
import plan.org.h2.jdbcx.JdbcDataSource;

public class H2DB
extends SQLDB {
    private final File databaseFile;
    private final String dbName;
    private Connection connection;
    private PluginTask connectionPingTask;

    private H2DB(File databaseFile, Locale locale, PlanConfig config, Lazy<ServerInfo> serverInfo, RunnableFactory runnableFactory, PluginLogger logger, ErrorLogger errorLogger) {
        super(() -> ((ServerInfo)serverInfo.get()).getServerUUID(), locale, config, runnableFactory, logger, errorLogger);
        this.dbName = databaseFile.getName();
        this.databaseFile = databaseFile;
    }

    @Override
    public void setupDataSource() {
        try {
            this.connection = this.getNewConnection(this.databaseFile);
        }
        catch (SQLException e) {
            throw new DBInitException(e.getMessage(), e);
        }
        this.startConnectionPingTask();
    }

    public Connection getNewConnection(File dbFile) throws SQLException {
        String dbFilePath = dbFile.getAbsolutePath();
        Connection newConnection = this.getConnectionFor(dbFilePath);
        this.logger.debug("H2 " + this.dbName + ": Opened a new Connection");
        newConnection.setAutoCommit(false);
        return newConnection;
    }

    private Connection getConnectionFor(String dbFilePath) throws SQLException {
        String username = this.config.get(DatabaseSettings.H2_USER);
        String password = this.config.get(DatabaseSettings.H2_PASS);
        JdbcDataSource jdbcDataSource = new JdbcDataSource();
        jdbcDataSource.setURL("jdbc:h2:file:" + dbFilePath + ";mode=MySQL;DATABASE_TO_UPPER=false");
        jdbcDataSource.setUser(username);
        jdbcDataSource.setPassword(password);
        return jdbcDataSource.getConnection();
    }

    private void startConnectionPingTask() {
        this.stopConnectionPingTask();
        this.logger.warn("H2 database is going to be deprecated in version 5.2. It is recommended to move to MySQL or SQLite when possible.");
        this.logger.warn("See https://github.com/plan-player-analytics/Plan/issues/1472 for details");
        try {
            this.connectionPingTask = this.runnableFactory.create("DBConnectionPingTask " + this.getType().getName(), new DBKeepAliveTask(this.connection, () -> this.getNewConnection(this.databaseFile), this.logger, this.errorLogger)).runTaskTimerAsynchronously(1200L, 1200L);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void stopConnectionPingTask() {
        if (this.connectionPingTask != null) {
            try {
                this.connectionPingTask.cancel();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public DBType getType() {
        return DBType.H2;
    }

    @Override
    public Connection getConnection() throws SQLException {
        if (this.connection == null) {
            this.connection = this.getNewConnection(this.databaseFile);
        }
        return this.connection;
    }

    @Override
    public void close() {
        super.close();
        this.stopConnectionPingTask();
        if (this.connection != null) {
            this.logger.debug("H2 Connection close prompted by: " + ThrowableUtils.findCallerAfterClass(Thread.currentThread().getStackTrace(), H2DB.class));
            this.logger.debug("H2 " + this.dbName + ": Closed Connection");
            MiscUtils.close(this.connection);
        } else {
            this.logger.debug("H2 " + this.dbName + ": Connection was null when closing");
        }
    }

    @Override
    public void returnToPool(Connection connection) {
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        H2DB h2DB = (H2DB)o;
        return Objects.equals(this.dbName, h2DB.dbName);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.dbName);
    }

    @Singleton
    public static class Factory {
        private final Locale locale;
        private final PlanConfig config;
        private final Lazy<ServerInfo> serverInfo;
        private final RunnableFactory runnableFactory;
        private final PluginLogger logger;
        private final ErrorLogger errorLogger1;
        private final PlanFiles files;

        @Inject
        public Factory(Locale locale, PlanConfig config, PlanFiles files, Lazy<ServerInfo> serverInfo, RunnableFactory runnableFactory, PluginLogger logger, ErrorLogger errorLogger1) {
            this.locale = locale;
            this.config = config;
            this.files = files;
            this.serverInfo = serverInfo;
            this.runnableFactory = runnableFactory;
            this.logger = logger;
            this.errorLogger1 = errorLogger1;
        }

        public H2DB usingDefaultFile() {
            return this.usingFileCalled("h2database");
        }

        public H2DB usingFileCalled(String fileName) {
            return this.usingFile(this.files.getFileFromPluginFolder(fileName));
        }

        public H2DB usingFile(File databaseFile) {
            return new H2DB(databaseFile, this.locale, this.config, this.serverInfo, this.runnableFactory, this.logger, this.errorLogger1);
        }
    }
}

