/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plan.storage.database;

import com.djrapitops.plan.exceptions.database.DBInitException;
import com.djrapitops.plan.exceptions.database.DBOpException;
import com.djrapitops.plan.identification.ServerInfo;
import com.djrapitops.plan.settings.config.PlanConfig;
import com.djrapitops.plan.settings.config.paths.DatabaseSettings;
import com.djrapitops.plan.settings.locale.Locale;
import com.djrapitops.plan.settings.locale.lang.PluginLang;
import com.djrapitops.plan.storage.database.DBType;
import com.djrapitops.plan.storage.database.SQLDB;
import com.djrapitops.plan.utilities.logging.ErrorContext;
import com.djrapitops.plan.utilities.logging.ErrorLogger;
import com.djrapitops.plugin.logging.L;
import com.djrapitops.plugin.logging.console.PluginLogger;
import com.djrapitops.plugin.task.RunnableFactory;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import javax.sql.DataSource;
import plan.com.zaxxer.hikari.HikariConfig;
import plan.com.zaxxer.hikari.HikariDataSource;
import plan.com.zaxxer.hikari.pool.HikariPool;
import plan.dagger.Lazy;
import plan.javax.inject.Inject;
import plan.javax.inject.Singleton;

@Singleton
public class MySQLDB
extends SQLDB {
    private static int increment = 1;
    protected DataSource dataSource;

    @Inject
    public MySQLDB(Locale locale, PlanConfig config, Lazy<ServerInfo> serverInfo, RunnableFactory runnableFactory, PluginLogger pluginLogger, ErrorLogger errorLogger) {
        super(() -> ((ServerInfo)serverInfo.get()).getServerUUID(), locale, config, runnableFactory, pluginLogger, errorLogger);
    }

    private static synchronized void increment() {
        ++increment;
    }

    @Override
    public DBType getType() {
        return DBType.MYSQL;
    }

    private void loadMySQLDriver() {
        try {
            Class.forName("plan.com.mysql.cj.jdbc.Driver");
        }
        catch (ClassNotFoundException e) {
            this.errorLogger.log(L.CRITICAL, e, ErrorContext.builder().whatToDo("Install MySQL Driver to the server").build());
        }
    }

    @Override
    public void setupDataSource() {
        try {
            this.loadMySQLDriver();
            HikariConfig hikariConfig = new HikariConfig();
            String host = this.config.get(DatabaseSettings.MYSQL_HOST);
            String port = this.config.get(DatabaseSettings.MYSQL_PORT);
            String database = this.config.get(DatabaseSettings.MYSQL_DATABASE);
            String launchOptions = this.config.get(DatabaseSettings.MYSQL_LAUNCH_OPTIONS);
            if (launchOptions.isEmpty() || !launchOptions.matches("\\?((\\w*=\\w*)&)*(\\w*=\\w*)")) {
                launchOptions = "?rewriteBatchedStatements=true&useSSL=false";
                this.logger.error(this.locale.getString(PluginLang.DB_MYSQL_LAUNCH_OPTIONS_FAIL, new Serializable[]{launchOptions}));
            }
            hikariConfig.setDriverClassName("plan.com.mysql.cj.jdbc.Driver");
            hikariConfig.setJdbcUrl("jdbc:mysql://" + host + ":" + port + "/" + database + launchOptions);
            String username = this.config.get(DatabaseSettings.MYSQL_USER);
            String password = this.config.get(DatabaseSettings.MYSQL_PASS);
            hikariConfig.setUsername(username);
            hikariConfig.setPassword(password);
            hikariConfig.addDataSourceProperty("connectionInitSql", "set time_zone = '+00:00'");
            hikariConfig.setPoolName("Plan Connection Pool-" + increment);
            MySQLDB.increment();
            hikariConfig.setAutoCommit(true);
            hikariConfig.setMaximumPoolSize(8);
            hikariConfig.setMaxLifetime(TimeUnit.MINUTES.toMillis(25L));
            hikariConfig.setLeakDetectionThreshold(TimeUnit.MINUTES.toMillis(10L));
            this.dataSource = new HikariDataSource(hikariConfig);
        }
        catch (HikariPool.PoolInitializationException e) {
            throw new DBInitException("Failed to set-up HikariCP Datasource: " + e.getMessage(), e);
        }
    }

    @Override
    public synchronized Connection getConnection() throws SQLException {
        Connection connection = this.dataSource.getConnection();
        if (!connection.isValid(5)) {
            connection.close();
            if (this.dataSource instanceof HikariDataSource) {
                ((HikariDataSource)this.dataSource).close();
            }
            try {
                this.setupDataSource();
                connection = this.dataSource.getConnection();
            }
            catch (DBInitException e) {
                throw new DBOpException("Failed to restart DataSource after a connection was invalid: " + e.getMessage(), e);
            }
        }
        if (connection.getAutoCommit()) {
            connection.setAutoCommit(false);
        }
        return connection;
    }

    @Override
    public void close() {
        super.close();
        if (this.dataSource instanceof HikariDataSource) {
            ((HikariDataSource)this.dataSource).close();
        }
    }

    @Override
    public void returnToPool(Connection connection) {
        try {
            if (connection != null) {
                connection.close();
            }
        }
        catch (SQLException e) {
            this.errorLogger.log(L.CRITICAL, e, ErrorContext.builder().related((Object)"Closing connection").build());
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        MySQLDB mySQLDB = (MySQLDB)o;
        return Objects.equals(this.dataSource, mySQLDB.dataSource);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.dataSource);
    }
}

