/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plan.storage.database;

import com.djrapitops.plan.exceptions.EnableException;
import com.djrapitops.plan.settings.config.PlanConfig;
import com.djrapitops.plan.settings.config.paths.DatabaseSettings;
import com.djrapitops.plan.settings.locale.Locale;
import com.djrapitops.plan.storage.database.DBSystem;
import com.djrapitops.plan.storage.database.H2DB;
import com.djrapitops.plan.storage.database.MySQLDB;
import com.djrapitops.plan.storage.database.SQLiteDB;
import com.djrapitops.plugin.logging.console.PluginLogger;
import plan.javax.inject.Inject;
import plan.javax.inject.Singleton;

@Singleton
public class NukkitDBSystem
extends DBSystem {
    private final PlanConfig config;

    @Inject
    public NukkitDBSystem(Locale locale, MySQLDB mySQLDB, SQLiteDB.Factory sqLiteDB, H2DB.Factory h2DB, PlanConfig config, PluginLogger logger) {
        super(locale, sqLiteDB, h2DB, logger);
        this.config = config;
        this.databases.add(mySQLDB);
        this.databases.add(h2DB.usingDefaultFile());
        this.databases.add(sqLiteDB.usingDefaultFile());
    }

    @Override
    public void enable() throws EnableException {
        String dbType = this.config.get(DatabaseSettings.TYPE).toLowerCase().trim();
        this.db = this.getActiveDatabaseByName(dbType);
        super.enable();
    }
}

