/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plan.storage.database;

import com.djrapitops.plan.exceptions.database.DBInitException;
import com.djrapitops.plan.exceptions.database.DBOpException;
import com.djrapitops.plan.exceptions.database.FatalDBException;
import com.djrapitops.plan.settings.config.PlanConfig;
import com.djrapitops.plan.settings.config.paths.PluginSettings;
import com.djrapitops.plan.settings.config.paths.TimeSettings;
import com.djrapitops.plan.settings.locale.Locale;
import com.djrapitops.plan.storage.database.AbstractDatabase;
import com.djrapitops.plan.storage.database.Database;
import com.djrapitops.plan.storage.database.queries.Query;
import com.djrapitops.plan.storage.database.transactions.Transaction;
import com.djrapitops.plan.storage.database.transactions.init.CreateIndexTransaction;
import com.djrapitops.plan.storage.database.transactions.init.CreateTablesTransaction;
import com.djrapitops.plan.storage.database.transactions.init.OperationCriticalTransaction;
import com.djrapitops.plan.storage.database.transactions.patches.BadAFKThresholdValuePatch;
import com.djrapitops.plan.storage.database.transactions.patches.BadNukkitRegisterValuePatch;
import com.djrapitops.plan.storage.database.transactions.patches.CommandUsageTableRemovalPatch;
import com.djrapitops.plan.storage.database.transactions.patches.DeleteIPsPatch;
import com.djrapitops.plan.storage.database.transactions.patches.DiskUsagePatch;
import com.djrapitops.plan.storage.database.transactions.patches.ExtensionShowInPlayersTablePatch;
import com.djrapitops.plan.storage.database.transactions.patches.ExtensionTableRowValueLengthPatch;
import com.djrapitops.plan.storage.database.transactions.patches.GeoInfoLastUsedPatch;
import com.djrapitops.plan.storage.database.transactions.patches.GeoInfoOptimizationPatch;
import com.djrapitops.plan.storage.database.transactions.patches.KillsOptimizationPatch;
import com.djrapitops.plan.storage.database.transactions.patches.KillsServerIDPatch;
import com.djrapitops.plan.storage.database.transactions.patches.LinkUsersToPlayersSecurityTablePatch;
import com.djrapitops.plan.storage.database.transactions.patches.LinkedToSecurityTablePatch;
import com.djrapitops.plan.storage.database.transactions.patches.LitebansTableHeaderPatch;
import com.djrapitops.plan.storage.database.transactions.patches.NicknameLastSeenPatch;
import com.djrapitops.plan.storage.database.transactions.patches.NicknamesOptimizationPatch;
import com.djrapitops.plan.storage.database.transactions.patches.Patch;
import com.djrapitops.plan.storage.database.transactions.patches.PingOptimizationPatch;
import com.djrapitops.plan.storage.database.transactions.patches.RegisterDateMinimizationPatch;
import com.djrapitops.plan.storage.database.transactions.patches.SessionAFKTimePatch;
import com.djrapitops.plan.storage.database.transactions.patches.SessionsOptimizationPatch;
import com.djrapitops.plan.storage.database.transactions.patches.TransferTableRemovalPatch;
import com.djrapitops.plan.storage.database.transactions.patches.UserInfoOptimizationPatch;
import com.djrapitops.plan.storage.database.transactions.patches.Version10Patch;
import com.djrapitops.plan.storage.database.transactions.patches.VersionTableRemovalPatch;
import com.djrapitops.plan.storage.database.transactions.patches.WorldTimesOptimizationPatch;
import com.djrapitops.plan.storage.database.transactions.patches.WorldTimesSeverIDPatch;
import com.djrapitops.plan.storage.database.transactions.patches.WorldsOptimizationPatch;
import com.djrapitops.plan.storage.database.transactions.patches.WorldsServerIDPatch;
import com.djrapitops.plan.utilities.java.ThrowableUtils;
import com.djrapitops.plan.utilities.logging.ErrorContext;
import com.djrapitops.plan.utilities.logging.ErrorLogger;
import com.djrapitops.plugin.api.TimeAmount;
import com.djrapitops.plugin.logging.L;
import com.djrapitops.plugin.logging.console.PluginLogger;
import com.djrapitops.plugin.task.AbsRunnable;
import com.djrapitops.plugin.task.RunnableFactory;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import plan.org.apache.commons.lang3.concurrent.BasicThreadFactory;

public abstract class SQLDB
extends AbstractDatabase {
    private final Supplier<UUID> serverUUIDSupplier;
    protected final Locale locale;
    protected final PlanConfig config;
    protected final RunnableFactory runnableFactory;
    protected final PluginLogger logger;
    protected final ErrorLogger errorLogger;
    private Supplier<ExecutorService> transactionExecutorServiceProvider;
    private ExecutorService transactionExecutor;
    private final boolean devMode;

    public SQLDB(Supplier<UUID> serverUUIDSupplier, Locale locale, PlanConfig config, RunnableFactory runnableFactory, PluginLogger logger, ErrorLogger errorLogger) {
        this.serverUUIDSupplier = serverUUIDSupplier;
        this.locale = locale;
        this.config = config;
        this.runnableFactory = runnableFactory;
        this.logger = logger;
        this.errorLogger = errorLogger;
        this.devMode = config.isTrue(PluginSettings.DEV_MODE);
        this.transactionExecutorServiceProvider = () -> {
            String nameFormat = "Plan " + this.getClass().getSimpleName() + "-transaction-thread-%d";
            return Executors.newSingleThreadExecutor(new BasicThreadFactory.Builder().namingPattern(nameFormat).uncaughtExceptionHandler((thread, throwable) -> {
                if (this.devMode) {
                    errorLogger.log(L.WARN, throwable, ErrorContext.builder().whatToDo("THIS ERROR IS ONLY LOGGED IN DEV MODE").build());
                }
            }).build());
        };
    }

    @Override
    public void init() {
        List<Runnable> unfinishedTransactions = this.closeTransactionExecutor(this.transactionExecutor);
        this.transactionExecutor = this.transactionExecutorServiceProvider.get();
        this.setState(Database.State.PATCHING);
        this.setupDataSource();
        this.setupDatabase();
        for (Runnable unfinishedTransaction : unfinishedTransactions) {
            this.transactionExecutor.submit(unfinishedTransaction);
        }
        if (this.getState() == Database.State.CLOSED) {
            throw new DBInitException("Failed to set-up Database");
        }
    }

    private List<Runnable> closeTransactionExecutor(ExecutorService transactionExecutor) {
        if (transactionExecutor == null || transactionExecutor.isShutdown() || transactionExecutor.isTerminated()) {
            return Collections.emptyList();
        }
        transactionExecutor.shutdown();
        try {
            Long waitMs = this.config.getOrDefault(TimeSettings.DB_TRANSACTION_FINISH_WAIT_DELAY, TimeUnit.SECONDS.toMillis(20L));
            if (waitMs > TimeUnit.MINUTES.toMillis(5L)) {
                this.logger.warn(TimeSettings.DB_TRANSACTION_FINISH_WAIT_DELAY.getPath() + " was set to over 5 minutes, using 5 min instead.");
                waitMs = TimeUnit.MINUTES.toMillis(5L);
            }
            if (!transactionExecutor.awaitTermination(waitMs, TimeUnit.MILLISECONDS)) {
                List<Runnable> unfinished = transactionExecutor.shutdownNow();
                int unfinishedCount = unfinished.size();
                if (unfinishedCount > 0) {
                    this.logger.warn(unfinishedCount + " unfinished database transactions were not executed.");
                }
                return unfinished;
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        return Collections.emptyList();
    }

    Patch[] patches() {
        return new Patch[]{new Version10Patch(), new GeoInfoLastUsedPatch(), new SessionAFKTimePatch(), new KillsServerIDPatch(), new WorldTimesSeverIDPatch(), new WorldsServerIDPatch(), new NicknameLastSeenPatch(), new VersionTableRemovalPatch(), new DiskUsagePatch(), new WorldsOptimizationPatch(), new WorldTimesOptimizationPatch(), new KillsOptimizationPatch(), new SessionsOptimizationPatch(), new PingOptimizationPatch(), new NicknamesOptimizationPatch(), new UserInfoOptimizationPatch(), new GeoInfoOptimizationPatch(), new TransferTableRemovalPatch(), new BadAFKThresholdValuePatch(), new DeleteIPsPatch(), new ExtensionShowInPlayersTablePatch(), new ExtensionTableRowValueLengthPatch(), new CommandUsageTableRemovalPatch(), new RegisterDateMinimizationPatch(), new BadNukkitRegisterValuePatch(), new LinkedToSecurityTablePatch(), new LinkUsersToPlayersSecurityTablePatch(), new LitebansTableHeaderPatch()};
    }

    private void setupDatabase() {
        this.executeTransaction(new CreateTablesTransaction());
        for (Patch patch : this.patches()) {
            this.executeTransaction(patch);
        }
        this.executeTransaction(new OperationCriticalTransaction(){

            @Override
            protected void performOperations() {
                if (SQLDB.this.getState() == Database.State.PATCHING) {
                    SQLDB.this.setState(Database.State.OPEN);
                }
            }
        });
        this.registerIndexCreationTask();
    }

    private void registerIndexCreationTask() {
        try {
            this.runnableFactory.create("Database Index Creation", new AbsRunnable(){

                @Override
                public void run() {
                    SQLDB.this.executeTransaction(new CreateIndexTransaction());
                }
            }).runTaskLaterAsynchronously(TimeAmount.toTicks(1L, TimeUnit.MINUTES));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public abstract void setupDataSource();

    @Override
    public void close() {
        if (this.getState() == Database.State.OPEN) {
            this.setState(Database.State.CLOSING);
        }
        this.closeTransactionExecutor(this.transactionExecutor);
        this.setState(Database.State.CLOSED);
    }

    public abstract Connection getConnection() throws SQLException;

    public abstract void returnToPool(Connection var1);

    @Override
    public <T> T query(Query<T> query) {
        this.accessLock.checkAccess();
        return query.executeQuery(this);
    }

    @Override
    public Future<?> executeTransaction(Transaction transaction) {
        if (this.getState() == Database.State.CLOSED) {
            throw new DBOpException("Transaction tried to execute although database is closed.");
        }
        Exception origin = new Exception();
        return CompletableFuture.supplyAsync(() -> {
            this.accessLock.checkAccess(transaction);
            if (this.devMode) {
                this.logger.getDebugLogger().logOn("SQL", "Executing: " + transaction.getClass().getSimpleName());
            }
            transaction.executeTransaction(this);
            return CompletableFuture.completedFuture(null);
        }, this.getTransactionExecutor()).handle(this.errorHandler(transaction, origin));
    }

    private BiFunction<CompletableFuture<Object>, Throwable, CompletableFuture<Object>> errorHandler(Transaction transaction, Exception origin) {
        return (obj, throwable) -> {
            if (throwable == null) {
                return CompletableFuture.completedFuture(null);
            }
            if (throwable instanceof FatalDBException) {
                this.setState(Database.State.CLOSED);
            }
            ThrowableUtils.appendEntryPointToCause(throwable, origin);
            this.errorLogger.log(L.ERROR, (Throwable)throwable, ErrorContext.builder().related((Object)("Transaction: " + transaction.getClass())).build());
            return CompletableFuture.completedFuture(null);
        };
    }

    private ExecutorService getTransactionExecutor() {
        if (this.transactionExecutor == null) {
            this.transactionExecutor = this.transactionExecutorServiceProvider.get();
        }
        return this.transactionExecutor;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SQLDB sqldb = (SQLDB)o;
        return this.getType() == sqldb.getType();
    }

    public int hashCode() {
        return Objects.hash(this.getType().getName());
    }

    public Supplier<UUID> getServerUUIDSupplier() {
        return this.serverUUIDSupplier;
    }

    public void setTransactionExecutorServiceProvider(Supplier<ExecutorService> transactionExecutorServiceProvider) {
        this.transactionExecutorServiceProvider = transactionExecutorServiceProvider;
    }
}

