/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plan.storage.database;

import com.djrapitops.plan.exceptions.database.DBInitException;
import com.djrapitops.plan.identification.ServerInfo;
import com.djrapitops.plan.settings.config.PlanConfig;
import com.djrapitops.plan.settings.locale.Locale;
import com.djrapitops.plan.settings.locale.lang.PluginLang;
import com.djrapitops.plan.storage.database.DBType;
import com.djrapitops.plan.storage.database.SQLDB;
import com.djrapitops.plan.storage.file.PlanFiles;
import com.djrapitops.plan.storage.upkeep.DBKeepAliveTask;
import com.djrapitops.plan.utilities.MiscUtils;
import com.djrapitops.plan.utilities.java.ThrowableUtils;
import com.djrapitops.plan.utilities.logging.ErrorContext;
import com.djrapitops.plan.utilities.logging.ErrorLogger;
import com.djrapitops.plugin.logging.L;
import com.djrapitops.plugin.logging.console.PluginLogger;
import com.djrapitops.plugin.task.PluginTask;
import com.djrapitops.plugin.task.RunnableFactory;
import java.io.File;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Objects;
import plan.dagger.Lazy;
import plan.javax.inject.Inject;
import plan.javax.inject.Singleton;

public class SQLiteDB
extends SQLDB {
    private final File databaseFile;
    private final String dbName;
    private Connection connection;
    private PluginTask connectionPingTask;

    private SQLiteDB(File databaseFile, Locale locale, PlanConfig config, Lazy<ServerInfo> serverInfo, RunnableFactory runnableFactory, PluginLogger logger, ErrorLogger errorLogger) {
        super(() -> ((ServerInfo)serverInfo.get()).getServerUUID(), locale, config, runnableFactory, logger, errorLogger);
        this.dbName = databaseFile.getName();
        this.databaseFile = databaseFile;
    }

    @Override
    public void setupDataSource() {
        try {
            if (this.connection != null) {
                this.connection.close();
            }
            this.connection = this.getNewConnection(this.databaseFile);
        }
        catch (SQLException e) {
            throw new DBInitException(e.getMessage(), e);
        }
        this.startConnectionPingTask();
    }

    public Connection getNewConnection(File dbFile) throws SQLException {
        try {
            Class.forName("org.sqlite.JDBC");
        }
        catch (ClassNotFoundException e) {
            this.errorLogger.log(L.CRITICAL, e, ErrorContext.builder().whatToDo("Install SQLite Driver to the server").build());
            return null;
        }
        String dbFilePath = dbFile.getAbsolutePath();
        Connection newConnection = this.getConnectionFor(dbFilePath);
        this.logger.debug("SQLite " + this.dbName + ": Opened a new Connection");
        newConnection.setAutoCommit(false);
        return newConnection;
    }

    private Connection getConnectionFor(String dbFilePath) throws SQLException {
        try {
            return DriverManager.getConnection("jdbc:sqlite:" + dbFilePath + "?journal_mode=WAL");
        }
        catch (SQLException ignored) {
            this.logger.info(this.locale.getString(PluginLang.DB_NOTIFY_SQLITE_WAL));
            return DriverManager.getConnection("jdbc:sqlite:" + dbFilePath);
        }
    }

    private void startConnectionPingTask() {
        this.stopConnectionPingTask();
        try {
            this.connectionPingTask = this.runnableFactory.create("DBConnectionPingTask " + this.getType().getName(), new DBKeepAliveTask(this.connection, () -> this.getNewConnection(this.databaseFile), this.logger, this.errorLogger)).runTaskTimerAsynchronously(1200L, 1200L);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void stopConnectionPingTask() {
        if (this.connectionPingTask != null) {
            try {
                this.connectionPingTask.cancel();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public DBType getType() {
        return DBType.SQLITE;
    }

    @Override
    public Connection getConnection() throws SQLException {
        if (this.connection == null) {
            this.connection = this.getNewConnection(this.databaseFile);
        }
        return this.connection;
    }

    @Override
    public void close() {
        this.logger.debug("SQLite Connection close prompted by: " + ThrowableUtils.findCallerAfterClass(Thread.currentThread().getStackTrace(), SQLiteDB.class));
        super.close();
        this.stopConnectionPingTask();
        if (this.connection != null) {
            this.logger.debug("SQLite " + this.dbName + ": Closed Connection");
            MiscUtils.close(this.connection);
        }
    }

    @Override
    public void returnToPool(Connection connection) {
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SQLiteDB sqLiteDB = (SQLiteDB)o;
        return Objects.equals(this.dbName, sqLiteDB.dbName);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.dbName);
    }

    @Singleton
    public static class Factory {
        private final Locale locale;
        private final PlanConfig config;
        private final Lazy<ServerInfo> serverInfo;
        private final RunnableFactory runnableFactory;
        private final PluginLogger logger;
        private final ErrorLogger errorLogger1;
        private final PlanFiles files;

        @Inject
        public Factory(Locale locale, PlanConfig config, PlanFiles files, Lazy<ServerInfo> serverInfo, RunnableFactory runnableFactory, PluginLogger logger, ErrorLogger errorLogger1) {
            this.locale = locale;
            this.config = config;
            this.files = files;
            this.serverInfo = serverInfo;
            this.runnableFactory = runnableFactory;
            this.logger = logger;
            this.errorLogger1 = errorLogger1;
        }

        public SQLiteDB usingDefaultFile() {
            return this.usingFileCalled("database");
        }

        public SQLiteDB usingFileCalled(String fileName) {
            return this.usingFile(this.files.getFileFromPluginFolder(fileName + ".db"));
        }

        public SQLiteDB usingFile(File databaseFile) {
            return new SQLiteDB(databaseFile, this.locale, this.config, this.serverInfo, this.runnableFactory, this.logger, this.errorLogger1);
        }
    }
}

