/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plan.storage.database.queries;

import com.djrapitops.plan.delivery.domain.Nickname;
import com.djrapitops.plan.delivery.domain.keys.SessionKeys;
import com.djrapitops.plan.gathering.domain.GMTimes;
import com.djrapitops.plan.gathering.domain.GeoInfo;
import com.djrapitops.plan.gathering.domain.Ping;
import com.djrapitops.plan.gathering.domain.Session;
import com.djrapitops.plan.gathering.domain.TPS;
import com.djrapitops.plan.storage.database.sql.tables.KillsTable;
import com.djrapitops.plan.storage.database.sql.tables.UsersTable;
import com.djrapitops.plan.storage.database.sql.tables.WorldTimesTable;
import com.djrapitops.plan.storage.database.transactions.ExecBatchStatement;
import com.djrapitops.plan.storage.database.transactions.ExecStatement;
import com.djrapitops.plan.storage.database.transactions.Executable;
import com.djrapitops.plugin.utilities.Verify;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.UUID;
import plan.org.apache.commons.lang3.StringUtils;

public class DataStoreQueries {
    private DataStoreQueries() {
    }

    public static Executable storeSession(Session session) {
        Verify.isTrue(session.supports(SessionKeys.END), () -> new IllegalArgumentException("Attempted to save a session that has not ended."));
        return connection -> {
            DataStoreQueries.storeSessionInformation(session).execute(connection);
            DataStoreQueries.storeSessionKills(session).execute(connection);
            return DataStoreQueries.storeSessionWorldTimes(session).execute(connection);
        };
    }

    private static Executable storeSessionInformation(final Session session) {
        return new ExecStatement("INSERT INTO plan_sessions (uuid,session_start,session_end,deaths,mob_kills,afk_time,server_uuid) VALUES (?, ?, ?, ?, ?, ?, ?)"){

            @Override
            public void prepare(PreparedStatement statement) throws SQLException {
                statement.setString(1, session.getUnsafe(SessionKeys.UUID).toString());
                statement.setLong(2, session.getUnsafe(SessionKeys.START));
                statement.setLong(3, session.getUnsafe(SessionKeys.END));
                statement.setInt(4, session.getValue(SessionKeys.DEATH_COUNT).orElse(0));
                statement.setInt(5, session.getValue(SessionKeys.MOB_KILL_COUNT).orElse(0));
                statement.setLong(6, session.getValue(SessionKeys.AFK_TIME).orElse(0L));
                statement.setString(7, session.getUnsafe(SessionKeys.SERVER_UUID).toString());
            }
        };
    }

    private static Executable storeSessionKills(final Session session) {
        return new ExecBatchStatement("INSERT INTO plan_kills (session_id,killer_uuid,victim_uuid,server_uuid,date,weapon) VALUES ((SELECT plan_sessions.id FROM plan_sessions WHERE plan_sessions.uuid=? AND plan_sessions.server_uuid=? AND session_start=? AND session_end=? LIMIT 1), ?, ?, ?, ?, ?)"){

            @Override
            public void prepare(PreparedStatement statement) throws SQLException {
                KillsTable.addSessionKillsToBatch(statement, session);
            }
        };
    }

    public static Executable insertWorldName(final UUID serverUUID, final String worldName) {
        return new ExecStatement("INSERT INTO plan_worlds (world_name,server_uuid) VALUES (?, ?)"){

            @Override
            public void prepare(PreparedStatement statement) throws SQLException {
                statement.setString(1, StringUtils.truncate(worldName, 100));
                statement.setString(2, serverUUID.toString());
            }
        };
    }

    private static Executable storeSessionWorldTimes(final Session session) {
        if (session.getValue(SessionKeys.WORLD_TIMES).map(times -> times.getWorldTimes().isEmpty()).orElse(true).booleanValue()) {
            return Executable.empty();
        }
        return new ExecBatchStatement("INSERT INTO plan_world_times (session_id,world_id,uuid,server_uuid,survival_time,creative_time,adventure_time,spectator_time) VALUES ( (SELECT plan_sessions.id FROM plan_sessions WHERE plan_sessions.uuid=? AND plan_sessions.server_uuid=? AND session_start=? AND session_end=? LIMIT 1),(SELECT plan_worlds.id FROM plan_worlds WHERE (world_name=?) AND (plan_worlds.server_uuid=?) LIMIT 1),?, ?, ?, ?, ?, ?)"){

            @Override
            public void prepare(PreparedStatement statement) throws SQLException {
                WorldTimesTable.addSessionWorldTimesToBatch(statement, session, GMTimes.getGMKeyArray());
            }
        };
    }

    public static Executable storeGeoInfo(UUID playerUUID, GeoInfo geoInfo) {
        return connection -> {
            if (!DataStoreQueries.updateGeoInfo(playerUUID, geoInfo).execute(connection)) {
                return DataStoreQueries.insertGeoInfo(playerUUID, geoInfo).execute(connection);
            }
            return false;
        };
    }

    private static Executable updateGeoInfo(final UUID playerUUID, final GeoInfo geoInfo) {
        return new ExecStatement("UPDATE plan_geolocations SET last_used=? WHERE uuid=? AND geolocation=?"){

            @Override
            public void prepare(PreparedStatement statement) throws SQLException {
                statement.setLong(1, geoInfo.getDate());
                statement.setString(2, playerUUID.toString());
                statement.setString(3, geoInfo.getGeolocation());
            }
        };
    }

    private static Executable insertGeoInfo(final UUID playerUUID, final GeoInfo geoInfo) {
        return new ExecStatement("INSERT INTO plan_geolocations (uuid,geolocation,last_used) VALUES (?, ?, ?)"){

            @Override
            public void prepare(PreparedStatement statement) throws SQLException {
                statement.setString(1, playerUUID.toString());
                statement.setString(2, geoInfo.getGeolocation());
                statement.setLong(3, geoInfo.getDate());
            }
        };
    }

    public static Executable registerBaseUser(final UUID playerUUID, final long registered, final String playerName) {
        return new ExecStatement(UsersTable.INSERT_STATEMENT){

            @Override
            public void prepare(PreparedStatement statement) throws SQLException {
                statement.setString(1, playerUUID.toString());
                statement.setString(2, playerName);
                statement.setLong(3, registered);
                statement.setInt(4, 0);
            }
        };
    }

    public static Executable updatePlayerName(final UUID playerUUID, final String playerName) {
        String sql = "UPDATE plan_users SET name=? WHERE uuid=?";
        return new ExecStatement(sql){

            @Override
            public void prepare(PreparedStatement statement) throws SQLException {
                statement.setString(1, playerName);
                statement.setString(2, playerUUID.toString());
            }
        };
    }

    public static Executable registerUserInfo(final UUID playerUUID, final long registered, final UUID serverUUID) {
        return new ExecStatement("INSERT INTO plan_user_info (uuid,registered,server_uuid,banned,opped) VALUES (?, ?, ?, ?, ?)"){

            @Override
            public void prepare(PreparedStatement statement) throws SQLException {
                statement.setString(1, playerUUID.toString());
                statement.setLong(2, registered);
                statement.setString(3, serverUUID.toString());
                statement.setBoolean(4, false);
                statement.setBoolean(5, false);
            }
        };
    }

    public static Executable updateMainRegisterDate(final UUID playerUUID, final long registered) {
        String sql = "UPDATE plan_users SET registered=? WHERE uuid=?";
        return new ExecStatement(sql){

            @Override
            public void prepare(PreparedStatement statement) throws SQLException {
                statement.setLong(1, registered);
                statement.setString(2, playerUUID.toString());
            }
        };
    }

    public static Executable storePing(final UUID playerUUID, final UUID serverUUID, final Ping ping) {
        return new ExecStatement("INSERT INTO plan_ping (uuid,server_uuid,date,min_ping,max_ping,avg_ping) VALUES (?, ?, ?, ?, ?, ?)"){

            @Override
            public void prepare(PreparedStatement statement) throws SQLException {
                statement.setString(1, playerUUID.toString());
                statement.setString(2, serverUUID.toString());
                statement.setLong(3, ping.getDate());
                statement.setInt(4, ping.getMin());
                statement.setInt(5, ping.getMax());
                statement.setDouble(6, ping.getAverage());
            }
        };
    }

    public static Executable storeTPS(final UUID serverUUID, final TPS tps) {
        return new ExecStatement("INSERT INTO plan_tps (server_id,date,tps,players_online,cpu_usage,ram_usage,entities,chunks_loaded,free_disk_space) VALUES ((SELECT plan_servers.id FROM plan_servers WHERE plan_servers.uuid=? LIMIT 1),?, ?, ?, ?, ?, ?, ?, ?)"){

            @Override
            public void prepare(PreparedStatement statement) throws SQLException {
                statement.setString(1, serverUUID.toString());
                statement.setLong(2, tps.getDate());
                statement.setDouble(3, tps.getTicksPerSecond());
                statement.setInt(4, tps.getPlayers());
                statement.setDouble(5, tps.getCPUUsage());
                statement.setLong(6, tps.getUsedMemory());
                statement.setDouble(7, tps.getEntityCount());
                statement.setDouble(8, tps.getChunksLoaded());
                statement.setLong(9, tps.getFreeDiskSpace());
            }
        };
    }

    public static Executable storePlayerNickname(UUID playerUUID, Nickname nickname) {
        return connection -> {
            if (!DataStoreQueries.updatePlayerNickname(playerUUID, nickname).execute(connection)) {
                DataStoreQueries.insertPlayerNickname(playerUUID, nickname).execute(connection);
            }
            return false;
        };
    }

    private static Executable updatePlayerNickname(final UUID playerUUID, final Nickname nickname) {
        return new ExecStatement("UPDATE plan_nicknames SET last_used=? WHERE nickname=? AND uuid=? AND server_uuid=?"){

            @Override
            public void prepare(PreparedStatement statement) throws SQLException {
                statement.setLong(1, nickname.getDate());
                statement.setString(2, nickname.getName());
                statement.setString(3, playerUUID.toString());
                statement.setString(4, nickname.getServerUUID().toString());
            }
        };
    }

    private static Executable insertPlayerNickname(final UUID playerUUID, final Nickname nickname) {
        return new ExecStatement("INSERT INTO plan_nicknames (uuid,server_uuid,nickname,last_used) VALUES (?, ?, ?, ?)"){

            @Override
            public void prepare(PreparedStatement statement) throws SQLException {
                statement.setString(1, playerUUID.toString());
                statement.setString(2, nickname.getServerUUID().toString());
                statement.setString(3, nickname.getName());
                statement.setLong(4, nickname.getDate());
            }
        };
    }
}

