/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plan.storage.database.queries;

import com.djrapitops.plan.gathering.domain.TPS;
import com.djrapitops.plan.gathering.domain.builders.TPSBuilder;
import com.djrapitops.plan.storage.database.queries.Query;
import com.djrapitops.plan.storage.database.queries.QueryAllStatement;
import com.djrapitops.plan.utilities.java.Lists;
import com.djrapitops.plan.utilities.java.Maps;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;

public class LargeFetchQueries {
    private LargeFetchQueries() {
    }

    public static Query<Map<UUID, List<TPS>>> fetchAllTPSData() {
        String serverIDColumn = "plan_servers.id";
        String serverUUIDColumn = "plan_servers.uuid as s_uuid";
        String sql = "SELECT date,tps,players_online,cpu_usage,ram_usage,entities,chunks_loaded,free_disk_space," + serverUUIDColumn + " FROM " + "plan_tps" + " JOIN " + "plan_servers" + " on " + serverIDColumn + "=" + "server_id";
        return new QueryAllStatement<Map<UUID, List<TPS>>>(sql, 50000){

            @Override
            public Map<UUID, List<TPS>> processResults(ResultSet set) throws SQLException {
                HashMap<UUID, List<TPS>> serverMap = new HashMap<UUID, List<TPS>>();
                while (set.next()) {
                    UUID serverUUID = UUID.fromString(set.getString("s_uuid"));
                    List tpsList = serverMap.computeIfAbsent(serverUUID, Lists::create);
                    TPS tps = TPSBuilder.get().date(set.getLong("date")).tps(set.getDouble("tps")).playersOnline(set.getInt("players_online")).usedCPU(set.getDouble("cpu_usage")).usedMemory(set.getLong("ram_usage")).entities(set.getInt("entities")).chunksLoaded(set.getInt("chunks_loaded")).freeDiskSpace(set.getLong("free_disk_space")).toTPS();
                    tpsList.add(tps);
                }
                return serverMap;
            }
        };
    }

    public static Query<Map<UUID, Collection<String>>> fetchAllWorldNames() {
        String sql = "SELECT * FROM plan_worlds";
        return new QueryAllStatement<Map<UUID, Collection<String>>>(sql, 1000){

            @Override
            public Map<UUID, Collection<String>> processResults(ResultSet set) throws SQLException {
                HashMap<UUID, Collection<String>> worldMap = new HashMap<UUID, Collection<String>>();
                while (set.next()) {
                    UUID serverUUID = UUID.fromString(set.getString("server_uuid"));
                    Collection worlds = worldMap.computeIfAbsent(serverUUID, Maps::createSet);
                    worlds.add(set.getString("world_name"));
                }
                return worldMap;
            }
        };
    }
}

