/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plan.storage.database.queries;

import com.djrapitops.plan.delivery.domain.Nickname;
import com.djrapitops.plan.delivery.domain.auth.User;
import com.djrapitops.plan.delivery.domain.keys.SessionKeys;
import com.djrapitops.plan.gathering.domain.BaseUser;
import com.djrapitops.plan.gathering.domain.GMTimes;
import com.djrapitops.plan.gathering.domain.GeoInfo;
import com.djrapitops.plan.gathering.domain.Ping;
import com.djrapitops.plan.gathering.domain.Session;
import com.djrapitops.plan.gathering.domain.TPS;
import com.djrapitops.plan.gathering.domain.UserInfo;
import com.djrapitops.plan.identification.Server;
import com.djrapitops.plan.storage.database.sql.tables.KillsTable;
import com.djrapitops.plan.storage.database.sql.tables.ServerTable;
import com.djrapitops.plan.storage.database.sql.tables.UsersTable;
import com.djrapitops.plan.storage.database.sql.tables.WorldTimesTable;
import com.djrapitops.plan.storage.database.transactions.ExecBatchStatement;
import com.djrapitops.plan.storage.database.transactions.Executable;
import com.djrapitops.plugin.utilities.Verify;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import plan.org.apache.commons.lang3.StringUtils;

public class LargeStoreQueries {
    private LargeStoreQueries() {
    }

    public static Executable storeAllGeoInformation(final Map<UUID, List<GeoInfo>> ofUsers) {
        if (Verify.isEmpty(ofUsers)) {
            return Executable.empty();
        }
        return new ExecBatchStatement("INSERT INTO plan_geolocations (uuid,geolocation,last_used) VALUES (?, ?, ?)"){

            @Override
            public void prepare(PreparedStatement statement) throws SQLException {
                for (Map.Entry playerEntry : ofUsers.entrySet()) {
                    UUID playerUUID = (UUID)playerEntry.getKey();
                    for (GeoInfo info : (List)playerEntry.getValue()) {
                        String geoLocation = info.getGeolocation();
                        long lastUsed = info.getDate();
                        statement.setString(1, playerUUID.toString());
                        statement.setString(2, geoLocation);
                        statement.setLong(3, lastUsed);
                        statement.addBatch();
                    }
                }
            }
        };
    }

    public static Executable storeAllNicknameData(final Map<UUID, Map<UUID, List<Nickname>>> ofServersAndUsers) {
        if (Verify.isEmpty(ofServersAndUsers)) {
            return Executable.empty();
        }
        return new ExecBatchStatement("INSERT INTO plan_nicknames (uuid,server_uuid,nickname,last_used) VALUES (?, ?, ?, ?)"){

            @Override
            public void prepare(PreparedStatement statement) throws SQLException {
                for (Map.Entry serverEntry : ofServersAndUsers.entrySet()) {
                    UUID serverUUID = (UUID)serverEntry.getKey();
                    for (Map.Entry entry : ((Map)serverEntry.getValue()).entrySet()) {
                        UUID uuid = (UUID)entry.getKey();
                        List nicknames = (List)entry.getValue();
                        for (Nickname nickname : nicknames) {
                            statement.setString(1, uuid.toString());
                            statement.setString(2, serverUUID.toString());
                            statement.setString(3, nickname.getName());
                            statement.setLong(4, nickname.getDate());
                            statement.addBatch();
                        }
                    }
                }
            }
        };
    }

    public static Executable storeAllPlanWebUsers(final Collection<User> users) {
        if (Verify.isEmpty(users)) {
            return Executable.empty();
        }
        return new ExecBatchStatement("INSERT INTO plan_security (username,linked_to_uuid,salted_pass_hash,permission_level) VALUES (?,?,?,?)"){

            @Override
            public void prepare(PreparedStatement statement) throws SQLException {
                for (User user : users) {
                    statement.setString(1, user.getUsername());
                    if (user.getLinkedToUUID() == null) {
                        statement.setNull(2, 12);
                    } else {
                        statement.setString(2, user.getLinkedToUUID().toString());
                    }
                    statement.setString(3, user.getPasswordHash());
                    statement.setInt(4, user.getPermissionLevel());
                    statement.addBatch();
                }
            }
        };
    }

    public static Executable storeAllPlanServerInformation(final Collection<Server> servers) {
        if (Verify.isEmpty(servers)) {
            return Executable.empty();
        }
        return new ExecBatchStatement(ServerTable.INSERT_STATEMENT){

            @Override
            public void prepare(PreparedStatement statement) throws SQLException {
                for (Server info : servers) {
                    UUID uuid = info.getUuid();
                    String name = info.getName();
                    String webAddress = info.getWebAddress();
                    if (uuid == null) continue;
                    statement.setString(1, uuid.toString());
                    statement.setString(2, name);
                    statement.setString(3, webAddress);
                    statement.setBoolean(4, true);
                    statement.setInt(5, info.getMaxPlayers());
                    statement.addBatch();
                }
            }
        };
    }

    public static Executable storeAllTPSData(final Map<UUID, List<TPS>> ofServers) {
        if (Verify.isEmpty(ofServers)) {
            return Executable.empty();
        }
        return new ExecBatchStatement("INSERT INTO plan_tps (server_id,date,tps,players_online,cpu_usage,ram_usage,entities,chunks_loaded,free_disk_space) VALUES ((SELECT plan_servers.id FROM plan_servers WHERE plan_servers.uuid=? LIMIT 1),?, ?, ?, ?, ?, ?, ?, ?)"){

            @Override
            public void prepare(PreparedStatement statement) throws SQLException {
                for (Map.Entry entry : ofServers.entrySet()) {
                    UUID serverUUID = (UUID)entry.getKey();
                    List tpsList = (List)entry.getValue();
                    for (TPS tps : tpsList) {
                        statement.setString(1, serverUUID.toString());
                        statement.setLong(2, tps.getDate());
                        statement.setDouble(3, tps.getTicksPerSecond());
                        statement.setInt(4, tps.getPlayers());
                        statement.setDouble(5, tps.getCPUUsage());
                        statement.setLong(6, tps.getUsedMemory());
                        statement.setDouble(7, tps.getEntityCount());
                        statement.setDouble(8, tps.getChunksLoaded());
                        statement.setLong(9, tps.getFreeDiskSpace());
                        statement.addBatch();
                    }
                }
            }
        };
    }

    public static Executable storePerServerUserInformation(final Map<UUID, List<UserInfo>> ofServers) {
        if (Verify.isEmpty(ofServers)) {
            return Executable.empty();
        }
        return new ExecBatchStatement("INSERT INTO plan_user_info (uuid,registered,server_uuid,banned,opped) VALUES (?, ?, ?, ?, ?)"){

            @Override
            public void prepare(PreparedStatement statement) throws SQLException {
                for (Map.Entry entry : ofServers.entrySet()) {
                    UUID serverUUID = (UUID)entry.getKey();
                    for (UserInfo user : (List)entry.getValue()) {
                        statement.setString(1, user.getPlayerUuid().toString());
                        statement.setLong(2, user.getRegistered());
                        statement.setString(3, serverUUID.toString());
                        statement.setBoolean(4, user.isBanned());
                        statement.setBoolean(5, user.isOperator());
                        statement.addBatch();
                    }
                }
            }
        };
    }

    public static Executable storeAllWorldNames(final Map<UUID, Collection<String>> ofServers) {
        if (Verify.isEmpty(ofServers)) {
            return Executable.empty();
        }
        return new ExecBatchStatement("INSERT INTO plan_worlds (world_name,server_uuid) VALUES (?, ?)"){

            @Override
            public void prepare(PreparedStatement statement) throws SQLException {
                for (Map.Entry entry : ofServers.entrySet()) {
                    UUID serverUUID = (UUID)entry.getKey();
                    for (String world : (Collection)entry.getValue()) {
                        statement.setString(1, StringUtils.truncate(world, 100));
                        statement.setString(2, serverUUID.toString());
                        statement.addBatch();
                    }
                }
            }
        };
    }

    public static Executable storeAllCommonUserInformation(final Collection<BaseUser> ofUsers) {
        if (Verify.isEmpty(ofUsers)) {
            return Executable.empty();
        }
        return new ExecBatchStatement(UsersTable.INSERT_STATEMENT){

            @Override
            public void prepare(PreparedStatement statement) throws SQLException {
                for (BaseUser user : ofUsers) {
                    statement.setString(1, user.getUuid().toString());
                    statement.setString(2, user.getName());
                    statement.setLong(3, user.getRegistered());
                    statement.setInt(4, user.getTimesKicked());
                    statement.addBatch();
                }
            }
        };
    }

    public static Executable storeAllSessionsWithoutKillOrWorldData(final Collection<Session> sessions) {
        if (Verify.isEmpty(sessions)) {
            return Executable.empty();
        }
        return new ExecBatchStatement("INSERT INTO plan_sessions (uuid,session_start,session_end,deaths,mob_kills,afk_time,server_uuid) VALUES (?, ?, ?, ?, ?, ?, ?)"){

            @Override
            public void prepare(PreparedStatement statement) throws SQLException {
                for (Session session : sessions) {
                    statement.setString(1, session.getUnsafe(SessionKeys.UUID).toString());
                    statement.setLong(2, session.getUnsafe(SessionKeys.START));
                    statement.setLong(3, session.getUnsafe(SessionKeys.END));
                    statement.setInt(4, session.getValue(SessionKeys.DEATH_COUNT).orElse(0));
                    statement.setInt(5, session.getValue(SessionKeys.MOB_KILL_COUNT).orElse(0));
                    statement.setLong(6, session.getValue(SessionKeys.AFK_TIME).orElse(0L));
                    statement.setString(7, session.getUnsafe(SessionKeys.SERVER_UUID).toString());
                    statement.addBatch();
                }
            }
        };
    }

    public static Executable storeAllSessionsWithKillAndWorldData(Collection<Session> sessions) {
        return connection -> {
            LargeStoreQueries.storeAllSessionsWithoutKillOrWorldData(sessions).execute(connection);
            LargeStoreQueries.storeSessionKillData(sessions).execute(connection);
            return LargeStoreQueries.storeSessionWorldTimeData(sessions).execute(connection);
        };
    }

    private static Executable storeSessionKillData(final Collection<Session> sessions) {
        if (Verify.isEmpty(sessions)) {
            return Executable.empty();
        }
        return new ExecBatchStatement("INSERT INTO plan_kills (session_id,killer_uuid,victim_uuid,server_uuid,date,weapon) VALUES ((SELECT plan_sessions.id FROM plan_sessions WHERE plan_sessions.uuid=? AND plan_sessions.server_uuid=? AND session_start=? AND session_end=? LIMIT 1), ?, ?, ?, ?, ?)"){

            @Override
            public void prepare(PreparedStatement statement) throws SQLException {
                for (Session session : sessions) {
                    KillsTable.addSessionKillsToBatch(statement, session);
                }
            }
        };
    }

    private static Executable storeSessionWorldTimeData(final Collection<Session> sessions) {
        if (Verify.isEmpty(sessions)) {
            return Executable.empty();
        }
        return new ExecBatchStatement("INSERT INTO plan_world_times (session_id,world_id,uuid,server_uuid,survival_time,creative_time,adventure_time,spectator_time) VALUES ( (SELECT plan_sessions.id FROM plan_sessions WHERE plan_sessions.uuid=? AND plan_sessions.server_uuid=? AND session_start=? AND session_end=? LIMIT 1),(SELECT plan_worlds.id FROM plan_worlds WHERE (world_name=?) AND (plan_worlds.server_uuid=?) LIMIT 1),?, ?, ?, ?, ?, ?)"){

            @Override
            public void prepare(PreparedStatement statement) throws SQLException {
                String[] gms = GMTimes.getGMKeyArray();
                for (Session session : sessions) {
                    WorldTimesTable.addSessionWorldTimesToBatch(statement, session, gms);
                }
            }
        };
    }

    public static Executable storeAllPingData(final Map<UUID, List<Ping>> ofUsers) {
        if (Verify.isEmpty(ofUsers)) {
            return Executable.empty();
        }
        return new ExecBatchStatement("INSERT INTO plan_ping (uuid,server_uuid,date,min_ping,max_ping,avg_ping) VALUES (?, ?, ?, ?, ?, ?)"){

            @Override
            public void prepare(PreparedStatement statement) throws SQLException {
                for (Map.Entry entry : ofUsers.entrySet()) {
                    UUID uuid = (UUID)entry.getKey();
                    List pings = (List)entry.getValue();
                    for (Ping ping : pings) {
                        UUID serverUUID = ping.getServerUUID();
                        long date = ping.getDate();
                        int minPing = ping.getMin();
                        int maxPing = ping.getMax();
                        double avgPing = ping.getAverage();
                        statement.setString(1, uuid.toString());
                        statement.setString(2, serverUUID.toString());
                        statement.setLong(3, date);
                        statement.setInt(4, minPing);
                        statement.setInt(5, maxPing);
                        statement.setDouble(6, avgPing);
                        statement.addBatch();
                    }
                }
            }
        };
    }
}

