/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plan.storage.database.queries;

import com.djrapitops.plan.storage.database.queries.Query;
import com.djrapitops.plan.storage.database.queries.QueryStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;

public class PerServerAggregateQueries {
    private PerServerAggregateQueries() {
    }

    public static Query<Map<UUID, Long>> lastSeenOnServers(final UUID playerUUID) {
        String sql = "SELECT MAX(session_end) as last_seen, server_uuid FROM plan_sessions WHERE uuid=? GROUP BY server_uuid";
        return new QueryStatement<Map<UUID, Long>>(sql){

            @Override
            public void prepare(PreparedStatement statement) throws SQLException {
                statement.setString(1, playerUUID.toString());
            }

            @Override
            public Map<UUID, Long> processResults(ResultSet set) throws SQLException {
                HashMap<UUID, Long> lastSeenMap = new HashMap<UUID, Long>();
                while (set.next()) {
                    UUID serverUUID = UUID.fromString(set.getString("server_uuid"));
                    long lastSeen = set.getLong("last_seen");
                    lastSeenMap.put(serverUUID, lastSeen);
                }
                return lastSeenMap;
            }
        };
    }

    public static Query<Map<UUID, Integer>> playerKillCountOnServers(UUID playerUUID) {
        String sql = "SELECT COUNT(1) as kill_count, server_uuid FROM plan_kills WHERE killer_uuid=? GROUP BY server_uuid";
        return PerServerAggregateQueries.getQueryForCountOf(playerUUID, sql, "kill_count");
    }

    public static Query<Map<UUID, Integer>> mobKillCountOnServers(UUID playerUUID) {
        String sql = "SELECT SUM(mob_kills) as kill_count, server_uuid FROM plan_sessions WHERE uuid=? GROUP BY server_uuid";
        return PerServerAggregateQueries.getQueryForCountOf(playerUUID, sql, "kill_count");
    }

    public static Query<Map<UUID, Integer>> totalDeathCountOnServers(UUID playerUUID) {
        String sql = "SELECT SUM(deaths) as death_count, server_uuid FROM plan_sessions WHERE uuid=? GROUP BY server_uuid";
        return PerServerAggregateQueries.getQueryForCountOf(playerUUID, sql, "death_count");
    }

    private static QueryStatement<Map<UUID, Integer>> getQueryForCountOf(final UUID playerUUID, String sql, final String column) {
        return new QueryStatement<Map<UUID, Integer>>(sql){

            @Override
            public void prepare(PreparedStatement statement) throws SQLException {
                statement.setString(1, playerUUID.toString());
            }

            @Override
            public Map<UUID, Integer> processResults(ResultSet set) throws SQLException {
                HashMap<UUID, Integer> killCountMap = new HashMap<UUID, Integer>();
                while (set.next()) {
                    UUID serverUUID = UUID.fromString(set.getString("server_uuid"));
                    int count = set.getInt(column);
                    killCountMap.put(serverUUID, count);
                }
                return killCountMap;
            }
        };
    }
}

