/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plan.storage.database.queries;

import com.djrapitops.plan.storage.database.queries.HasMoreThanZeroQueryStatement;
import com.djrapitops.plan.storage.database.queries.Query;
import com.djrapitops.plan.storage.database.queries.QueryStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Optional;
import java.util.UUID;

public class PlayerFetchQueries {
    private PlayerFetchQueries() {
    }

    public static Query<Optional<String>> playerUserName(final UUID playerUUID) {
        String sql = "SELECT name FROM plan_users WHERE uuid=?";
        return new QueryStatement<Optional<String>>(sql){

            @Override
            public void prepare(PreparedStatement statement) throws SQLException {
                statement.setString(1, playerUUID.toString());
            }

            @Override
            public Optional<String> processResults(ResultSet set) throws SQLException {
                if (set.next()) {
                    return Optional.of(set.getString("name"));
                }
                return Optional.empty();
            }
        };
    }

    public static Query<Boolean> isPlayerRegistered(final UUID playerUUID) {
        String sql = "SELECT COUNT(1) as c FROM plan_users WHERE uuid=?";
        return new HasMoreThanZeroQueryStatement(sql){

            @Override
            public void prepare(PreparedStatement statement) throws SQLException {
                statement.setString(1, playerUUID.toString());
            }
        };
    }

    public static Query<Boolean> isPlayerRegisteredOnServer(final UUID playerUUID, final UUID serverUUID) {
        String sql = "SELECT COUNT(1) as c FROM plan_user_info WHERE uuid=? AND server_uuid=?";
        return new HasMoreThanZeroQueryStatement(sql){

            @Override
            public void prepare(PreparedStatement statement) throws SQLException {
                statement.setString(1, playerUUID.toString());
                statement.setString(2, serverUUID.toString());
            }
        };
    }

    public static Query<Optional<Long>> fetchRegisterDate(final UUID playerUUID) {
        String sql = "SELECT registered FROM plan_users WHERE uuid=? LIMIT 1";
        return new QueryStatement<Optional<Long>>(sql){

            @Override
            public void prepare(PreparedStatement statement) throws SQLException {
                statement.setString(1, playerUUID.toString());
            }

            @Override
            public Optional<Long> processResults(ResultSet set) throws SQLException {
                if (set.next()) {
                    return Optional.of(set.getLong("registered"));
                }
                return Optional.empty();
            }
        };
    }
}

