/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plan.storage.database.queries;

import com.djrapitops.plan.exceptions.database.DBOpException;
import com.djrapitops.plan.query.QueryService;
import com.djrapitops.plan.storage.database.transactions.Executable;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;

public class QueryAPIExecutable
implements Executable {
    private final String sql;
    private final QueryService.ThrowingConsumer<PreparedStatement> statement;

    public QueryAPIExecutable(String sql, QueryService.ThrowingConsumer<PreparedStatement> statement) {
        this.sql = sql;
        this.statement = statement;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean execute(Connection connection) {
        try (PreparedStatement preparedStatement = connection.prepareStatement(this.sql);){
            this.statement.accept(preparedStatement);
            boolean bl = true;
            return bl;
        }
        catch (SQLException e) {
            throw DBOpException.forCause(this.sql, e);
        }
    }
}

