/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plan.storage.database.queries;

import com.djrapitops.plan.storage.database.queries.Query;
import com.djrapitops.plan.storage.database.queries.QueryAllStatement;
import com.djrapitops.plan.storage.database.queries.QueryStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;

public class ServerAggregateQueries {
    private ServerAggregateQueries() {
    }

    public static Query<Integer> baseUserCount() {
        String sql = "SELECT COUNT(1) as c FROM plan_users";
        return new QueryAllStatement<Integer>(sql){

            @Override
            public Integer processResults(ResultSet set) throws SQLException {
                return set.next() ? set.getInt("c") : 0;
            }
        };
    }

    public static Query<Integer> serverUserCount(final UUID serverUUID) {
        String sql = "SELECT COUNT(1) as c FROM plan_user_info WHERE server_uuid=?";
        return new QueryStatement<Integer>(sql){

            @Override
            public void prepare(PreparedStatement statement) throws SQLException {
                statement.setString(1, serverUUID.toString());
            }

            @Override
            public Integer processResults(ResultSet set) throws SQLException {
                return set.next() ? set.getInt("c") : 0;
            }
        };
    }

    public static Query<Map<UUID, Integer>> serverUserCounts() {
        String sql = "SELECT COUNT(1) as c, server_uuid FROM plan_user_info GROUP BY server_uuid";
        return new QueryAllStatement<Map<UUID, Integer>>(sql, 100){

            @Override
            public Map<UUID, Integer> processResults(ResultSet set) throws SQLException {
                HashMap<UUID, Integer> ofServer = new HashMap<UUID, Integer>();
                while (set.next()) {
                    UUID serverUUID = UUID.fromString(set.getString("server_uuid"));
                    int count = set.getInt("c");
                    ofServer.put(serverUUID, count);
                }
                return ofServer;
            }
        };
    }
}

