/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plan.storage.database.queries.analysis;

import com.djrapitops.plan.delivery.domain.mutators.ActivityIndex;
import com.djrapitops.plan.storage.database.queries.Query;
import com.djrapitops.plan.storage.database.queries.QueryStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.TimeUnit;

public class ActivityIndexQueries {
    private ActivityIndexQueries() {
    }

    public static Query<Integer> fetchRegularPlayerCount(long date, UUID serverUUID, long playtimeThreshold) {
        return ActivityIndexQueries.fetchActivityGroupCount(date, serverUUID, playtimeThreshold, 2.0, 5.1);
    }

    public static String selectActivityIndexSQL() {
        String selectActivePlaytimeSQL = "SELECT ux.uuid,COALESCE(active_playtime,0) AS active_playtime FROM plan_user_info ux LEFT JOIN (SELECT uuid,SUM(session_end-session_start-afk_time) as active_playtime FROM plan_sessions WHERE server_uuid=? AND session_end>=? AND session_start<=? GROUP BY uuid) sx on sx.uuid=ux.uuid";
        String selectThreeWeeks = selectActivePlaytimeSQL + " UNION ALL " + selectActivePlaytimeSQL + " UNION ALL " + selectActivePlaytimeSQL;
        return "SELECT 5.0 - 5.0 * AVG(1.0 / (?/2.0 * (q1.active_playtime*1.0/?) +1.0)) as activity_index,q1.uuid FROM (" + selectThreeWeeks + ") q1" + " GROUP BY " + "q1." + "uuid";
    }

    public static void setSelectActivityIndexSQLParameters(PreparedStatement statement, int index, long playtimeThreshold, UUID serverUUID, long date) throws SQLException {
        statement.setDouble(index, Math.PI);
        statement.setLong(index + 1, playtimeThreshold);
        statement.setString(index + 2, serverUUID.toString());
        statement.setLong(index + 3, date - TimeUnit.DAYS.toMillis(7L));
        statement.setLong(index + 4, date);
        statement.setString(index + 5, serverUUID.toString());
        statement.setLong(index + 6, date - TimeUnit.DAYS.toMillis(14L));
        statement.setLong(index + 7, date - TimeUnit.DAYS.toMillis(7L));
        statement.setString(index + 8, serverUUID.toString());
        statement.setLong(index + 9, date - TimeUnit.DAYS.toMillis(21L));
        statement.setLong(index + 10, date - TimeUnit.DAYS.toMillis(14L));
    }

    public static Query<Integer> fetchActivityGroupCount(final long date, final UUID serverUUID, final long playtimeThreshold, final double above, final double below) {
        String selectActivityIndex = ActivityIndexQueries.selectActivityIndexSQL();
        String selectIndexes = "SELECT COALESCE(activity_index, 0) as activity_index FROM plan_user_info u LEFT JOIN (" + selectActivityIndex + ") q2 on q2." + "uuid" + "=u." + "uuid" + " WHERE " + "u." + "server_uuid" + "=?" + " AND " + "u." + "registered" + "<=?";
        String selectCount = "SELECT COUNT(1) as count FROM (" + selectIndexes + ") i" + " WHERE " + "i.activity_index>=?" + " AND " + "i.activity_index<?";
        return new QueryStatement<Integer>(selectCount){

            @Override
            public void prepare(PreparedStatement statement) throws SQLException {
                ActivityIndexQueries.setSelectActivityIndexSQLParameters(statement, 1, playtimeThreshold, serverUUID, date);
                statement.setString(12, serverUUID.toString());
                statement.setLong(13, date);
                statement.setDouble(14, above);
                statement.setDouble(15, below);
            }

            @Override
            public Integer processResults(ResultSet set) throws SQLException {
                return set.next() ? set.getInt("count") : 0;
            }
        };
    }

    public static Query<Map<String, Integer>> fetchActivityIndexGroupingsOn(final long date, final UUID serverUUID, final long threshold) {
        String selectActivityIndex = ActivityIndexQueries.selectActivityIndexSQL();
        String selectIndexes = "SELECT activity_index FROM plan_user_info u LEFT JOIN (" + selectActivityIndex + ") s on s." + "uuid" + "=u." + "uuid" + " WHERE " + "u." + "server_uuid" + "=?" + " AND " + "u." + "registered" + "<=?";
        return new QueryStatement<Map<String, Integer>>(selectIndexes){

            @Override
            public void prepare(PreparedStatement statement) throws SQLException {
                ActivityIndexQueries.setSelectActivityIndexSQLParameters(statement, 1, threshold, serverUUID, date);
                statement.setString(12, serverUUID.toString());
                statement.setLong(13, date);
            }

            @Override
            public Map<String, Integer> processResults(ResultSet set) throws SQLException {
                HashMap<String, Integer> groups = new HashMap<String, Integer>();
                while (set.next()) {
                    double activityIndex = set.getDouble("activity_index");
                    String group = ActivityIndex.getGroup(activityIndex);
                    groups.put(group, groups.getOrDefault(group, 0) + 1);
                }
                return groups;
            }
        };
    }

    public static Query<Integer> countNewPlayersTurnedRegular(final long after, final long before, final UUID serverUUID, final Long threshold) {
        String selectActivityIndex = ActivityIndexQueries.selectActivityIndexSQL();
        String selectActivePlayerCount = "SELECT COUNT(1) as count FROM (" + selectActivityIndex + ") q2" + " JOIN " + "plan_user_info" + " u on u." + "uuid" + "=q2." + "uuid" + " WHERE " + "u." + "server_uuid" + "=?" + " AND " + "u." + "registered" + ">=?" + " AND " + "u." + "registered" + "<=?" + " AND " + "q2.activity_index>=?" + " AND " + "q2.activity_index<?";
        return new QueryStatement<Integer>(selectActivePlayerCount){

            @Override
            public void prepare(PreparedStatement statement) throws SQLException {
                ActivityIndexQueries.setSelectActivityIndexSQLParameters(statement, 1, threshold, serverUUID, before);
                statement.setString(12, serverUUID.toString());
                statement.setLong(13, after);
                statement.setLong(14, before);
                statement.setDouble(15, 2.0);
                statement.setDouble(16, 5.1);
            }

            @Override
            public Integer processResults(ResultSet set) throws SQLException {
                return set.next() ? set.getInt("count") : 0;
            }
        };
    }

    public static Query<Integer> countRegularPlayersTurnedInactive(final long start, final long end, final UUID serverUUID, final Long threshold) {
        String selectActivityIndex = ActivityIndexQueries.selectActivityIndexSQL();
        String selectActivePlayerCount = "SELECT COUNT(1) as count FROM (" + selectActivityIndex + ") q2" + " JOIN " + '(' + selectActivityIndex.replace("q1", "q3") + ") q4 on q2." + "uuid" + "=q4." + "uuid" + " WHERE " + "q2.activity_index>=?" + " AND " + "q2.activity_index<?" + " AND " + "q4.activity_index>=?" + " AND " + "q4.activity_index<?";
        return new QueryStatement<Integer>(selectActivePlayerCount){

            @Override
            public void prepare(PreparedStatement statement) throws SQLException {
                ActivityIndexQueries.setSelectActivityIndexSQLParameters(statement, 1, threshold, serverUUID, end);
                ActivityIndexQueries.setSelectActivityIndexSQLParameters(statement, 12, threshold, serverUUID, start);
                statement.setDouble(23, 2.0);
                statement.setDouble(24, 5.1);
                statement.setDouble(25, -0.1);
                statement.setDouble(26, 1.0);
            }

            @Override
            public Integer processResults(ResultSet set) throws SQLException {
                return set.next() ? set.getInt("count") : 0;
            }
        };
    }

    public static Query<Long> averagePlaytimePerRegularPlayer(final long after, final long before, final UUID serverUUID, final Long threshold) {
        return database -> {
            String selectPlaytimePerPlayer = "SELECT p.uuid,SUM(p.session_end-p.session_start) as playtime FROM plan_sessions p JOIN (" + ActivityIndexQueries.selectActivityIndexSQL() + ") q2 on q2." + "uuid" + "=p." + "uuid" + " WHERE " + "p." + "session_end" + "<=?" + " AND " + "p." + "session_start" + ">=?" + " AND " + "p." + "server_uuid" + "=?" + " AND " + "q2.activity_index>=?" + " AND " + "q2.activity_index<?" + " GROUP BY " + "p." + "uuid";
            String selectAverage = "SELECT AVG(playtime) as average FROM (" + selectPlaytimePerPlayer + ") q1";
            return database.query(new QueryStatement<Long>(selectAverage, 100){

                @Override
                public void prepare(PreparedStatement statement) throws SQLException {
                    ActivityIndexQueries.setSelectActivityIndexSQLParameters(statement, 1, threshold, serverUUID, before);
                    statement.setLong(12, before);
                    statement.setLong(13, after);
                    statement.setString(14, serverUUID.toString());
                    statement.setDouble(15, 2.0);
                    statement.setDouble(16, 5.1);
                }

                @Override
                public Long processResults(ResultSet set) throws SQLException {
                    return set.next() ? (long)set.getDouble("average") : 0L;
                }
            });
        };
    }

    public static Query<Long> averageSessionLengthPerRegularPlayer(final long after, final long before, final UUID serverUUID, final Long threshold) {
        return database -> {
            String selectSessionLengthPerPlayer = "SELECT p.uuid,p.session_end-p.session_start as length FROM plan_sessions p JOIN (" + ActivityIndexQueries.selectActivityIndexSQL() + ") q2 on q2." + "uuid" + "=p." + "uuid" + " WHERE " + "p." + "session_end" + "<=?" + " AND " + "p." + "session_start" + ">=?" + " AND " + "p." + "server_uuid" + "=?" + " AND " + "q2.activity_index>=?" + " AND " + "q2.activity_index<?";
            String selectAverage = "SELECT AVG(length) as average FROM (" + selectSessionLengthPerPlayer + ") q1";
            return database.query(new QueryStatement<Long>(selectAverage, 100){

                @Override
                public void prepare(PreparedStatement statement) throws SQLException {
                    ActivityIndexQueries.setSelectActivityIndexSQLParameters(statement, 1, threshold, serverUUID, before);
                    statement.setLong(12, before);
                    statement.setLong(13, after);
                    statement.setString(14, serverUUID.toString());
                    statement.setDouble(15, 2.0);
                    statement.setDouble(16, 5.1);
                }

                @Override
                public Long processResults(ResultSet set) throws SQLException {
                    return set.next() ? (long)set.getDouble("average") : 0L;
                }
            });
        };
    }

    public static Query<Long> averageAFKPerRegularPlayer(final long after, final long before, final UUID serverUUID, final Long threshold) {
        return database -> {
            String selectPlaytimePerPlayer = "SELECT p.uuid,SUM(p.afk_time) as afk FROM plan_sessions p JOIN (" + ActivityIndexQueries.selectActivityIndexSQL() + ") q2 on q2." + "uuid" + "=p." + "uuid" + " WHERE " + "p." + "session_end" + "<=?" + " AND " + "p." + "session_start" + ">=?" + " AND " + "p." + "server_uuid" + "=?" + " AND " + "q2.activity_index>=?" + " AND " + "q2.activity_index<?" + " GROUP BY " + "p." + "uuid";
            String selectAverage = "SELECT AVG(afk) as average FROM (" + selectPlaytimePerPlayer + ") q1";
            return database.query(new QueryStatement<Long>(selectAverage, 100){

                @Override
                public void prepare(PreparedStatement statement) throws SQLException {
                    ActivityIndexQueries.setSelectActivityIndexSQLParameters(statement, 1, threshold, serverUUID, before);
                    statement.setLong(12, before);
                    statement.setLong(13, after);
                    statement.setString(14, serverUUID.toString());
                    statement.setDouble(15, 2.0);
                    statement.setDouble(16, 5.1);
                }

                @Override
                public Long processResults(ResultSet set) throws SQLException {
                    return set.next() ? (long)set.getDouble("average") : 0L;
                }
            });
        };
    }

    public static Query<Collection<ActivityIndex>> activityIndexForNewPlayers(final long after, final long before, final UUID serverUUID, final Long threshold) {
        String selectNewUUIDs = "SELECT uuid FROM plan_user_info WHERE registered<=? AND registered>=? AND server_uuid=?";
        String sql = "SELECT activity_index FROM (" + selectNewUUIDs + ") n" + " JOIN " + '(' + ActivityIndexQueries.selectActivityIndexSQL() + ") a on n." + "uuid" + "=a." + "uuid";
        return new QueryStatement<Collection<ActivityIndex>>(sql){

            @Override
            public void prepare(PreparedStatement statement) throws SQLException {
                statement.setLong(1, before);
                statement.setLong(2, after);
                statement.setString(3, serverUUID.toString());
                ActivityIndexQueries.setSelectActivityIndexSQLParameters(statement, 4, threshold, serverUUID, before);
            }

            @Override
            public Collection<ActivityIndex> processResults(ResultSet set) throws SQLException {
                ArrayList<ActivityIndex> indexes = new ArrayList<ActivityIndex>();
                while (set.next()) {
                    indexes.add(new ActivityIndex(set.getDouble("activity_index"), before));
                }
                return indexes;
            }
        };
    }

    public static Query<ActivityIndex> averageActivityIndexForRetainedPlayers(final long after, final long before, final UUID serverUUID, final Long threshold) {
        String selectNewUUIDs = "SELECT uuid FROM plan_user_info WHERE registered<=? AND registered>=? AND server_uuid=?";
        String selectUniqueUUIDs = "SELECT DISTINCT uuid FROM plan_sessions WHERE session_start>=? AND session_end<=? AND server_uuid=?";
        String sql = "SELECT AVG(activity_index) as average FROM (" + selectNewUUIDs + ") n" + " JOIN " + '(' + selectUniqueUUIDs + ") u on n." + "uuid" + "=u." + "uuid" + " JOIN " + '(' + ActivityIndexQueries.selectActivityIndexSQL() + ") a on n." + "uuid" + "=a." + "uuid";
        return new QueryStatement<ActivityIndex>(sql){

            @Override
            public void prepare(PreparedStatement statement) throws SQLException {
                statement.setLong(1, before);
                statement.setLong(2, after);
                statement.setString(3, serverUUID.toString());
                long half = before - (before - after) / 2L;
                statement.setLong(4, half);
                statement.setLong(5, before);
                statement.setString(6, serverUUID.toString());
                ActivityIndexQueries.setSelectActivityIndexSQLParameters(statement, 7, threshold, serverUUID, before);
            }

            @Override
            public ActivityIndex processResults(ResultSet set) throws SQLException {
                return set.next() ? new ActivityIndex(set.getDouble("average"), before) : new ActivityIndex(0.0, before);
            }
        };
    }

    public static Query<ActivityIndex> averageActivityIndexForNonRetainedPlayers(final long after, final long before, final UUID serverUUID, final Long threshold) {
        String selectNewUUIDs = "SELECT uuid FROM plan_user_info WHERE registered<=? AND registered>=? AND server_uuid=?";
        String selectUniqueUUIDs = "SELECT DISTINCT uuid FROM plan_sessions WHERE session_start>=? AND session_end<=? AND server_uuid=?";
        String sql = "SELECT AVG(activity_index) as average FROM (" + selectNewUUIDs + ") n" + " LEFT JOIN " + '(' + selectUniqueUUIDs + ") u on n." + "uuid" + "=u." + "uuid" + " JOIN " + '(' + ActivityIndexQueries.selectActivityIndexSQL() + ") a on n." + "uuid" + "=a." + "uuid" + " WHERE " + "n." + "uuid" + " IS NULL";
        return new QueryStatement<ActivityIndex>(sql){

            @Override
            public void prepare(PreparedStatement statement) throws SQLException {
                statement.setLong(1, before);
                statement.setLong(2, after);
                statement.setString(3, serverUUID.toString());
                long half = before - (before - after) / 2L;
                statement.setLong(4, half);
                statement.setLong(5, before);
                statement.setString(6, serverUUID.toString());
                ActivityIndexQueries.setSelectActivityIndexSQLParameters(statement, 7, threshold, serverUUID, before);
            }

            @Override
            public ActivityIndex processResults(ResultSet set) throws SQLException {
                return set.next() ? new ActivityIndex(set.getDouble("average"), before) : new ActivityIndex(0.0, before);
            }
        };
    }
}

