/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plan.storage.database.queries.analysis;

import com.djrapitops.plan.delivery.domain.mutators.ActivityIndex;
import com.djrapitops.plan.storage.database.queries.Query;
import com.djrapitops.plan.storage.database.queries.QueryStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class NetworkActivityIndexQueries {
    private NetworkActivityIndexQueries() {
    }

    public static Query<Integer> fetchRegularPlayerCount(long date, long playtimeThreshold) {
        return NetworkActivityIndexQueries.fetchActivityGroupCount(date, playtimeThreshold, 2.0, 5.1);
    }

    public static String selectActivityIndexSQL() {
        String selectActivePlaytimeSQL = "SELECT ux.uuid,COALESCE(active_playtime,0) AS active_playtime FROM plan_users ux LEFT JOIN (SELECT uuid,SUM(session_end-session_start-afk_time) as active_playtime FROM plan_sessions WHERE session_end>=? AND session_start<=? GROUP BY uuid) sx on sx.uuid=ux.uuid";
        String selectThreeWeeks = selectActivePlaytimeSQL + " UNION ALL " + selectActivePlaytimeSQL + " UNION ALL " + selectActivePlaytimeSQL;
        return "SELECT 5.0 - 5.0 * AVG(1.0 / (?/2.0 * (q1.active_playtime*1.0/?) +1.0)) as activity_index,q1.uuid FROM (" + selectThreeWeeks + ") q1" + " GROUP BY " + "q1." + "uuid";
    }

    public static void setSelectActivityIndexSQLParameters(PreparedStatement statement, int index, long playtimeThreshold, long date) throws SQLException {
        statement.setDouble(index, Math.PI);
        statement.setLong(index + 1, playtimeThreshold);
        statement.setLong(index + 2, date - TimeUnit.DAYS.toMillis(7L));
        statement.setLong(index + 3, date);
        statement.setLong(index + 4, date - TimeUnit.DAYS.toMillis(14L));
        statement.setLong(index + 5, date - TimeUnit.DAYS.toMillis(7L));
        statement.setLong(index + 6, date - TimeUnit.DAYS.toMillis(21L));
        statement.setLong(index + 7, date - TimeUnit.DAYS.toMillis(14L));
    }

    public static Query<Integer> fetchActivityGroupCount(final long date, final long playtimeThreshold, final double above, final double below) {
        String selectActivityIndex = NetworkActivityIndexQueries.selectActivityIndexSQL();
        String selectIndexes = "SELECT COALESCE(activity_index, 0) as activity_index FROM plan_users u LEFT JOIN (" + selectActivityIndex + ") q2 on q2." + "uuid" + "=u." + "uuid" + " WHERE " + "u." + "registered" + "<=?";
        String selectCount = "SELECT COUNT(1) as count FROM (" + selectIndexes + ") i" + " WHERE " + "i.activity_index>=?" + " AND " + "i.activity_index<?";
        return new QueryStatement<Integer>(selectCount){

            @Override
            public void prepare(PreparedStatement statement) throws SQLException {
                NetworkActivityIndexQueries.setSelectActivityIndexSQLParameters(statement, 1, playtimeThreshold, date);
                statement.setLong(9, date);
                statement.setDouble(10, above);
                statement.setDouble(11, below);
            }

            @Override
            public Integer processResults(ResultSet set) throws SQLException {
                return set.next() ? set.getInt("count") : 0;
            }
        };
    }

    public static Query<Map<String, Integer>> fetchActivityIndexGroupingsOn(final long date, final long threshold) {
        String selectActivityIndex = NetworkActivityIndexQueries.selectActivityIndexSQL();
        String selectIndexes = "SELECT activity_index FROM plan_users u LEFT JOIN (" + selectActivityIndex + ") s on s." + "uuid" + "=u." + "uuid" + " WHERE " + "u." + "registered" + "<=?";
        return new QueryStatement<Map<String, Integer>>(selectIndexes){

            @Override
            public void prepare(PreparedStatement statement) throws SQLException {
                NetworkActivityIndexQueries.setSelectActivityIndexSQLParameters(statement, 1, threshold, date);
                statement.setLong(9, date);
            }

            @Override
            public Map<String, Integer> processResults(ResultSet set) throws SQLException {
                HashMap<String, Integer> groups = new HashMap<String, Integer>();
                while (set.next()) {
                    double activityIndex = set.getDouble("activity_index");
                    String group = ActivityIndex.getGroup(activityIndex);
                    groups.put(group, groups.getOrDefault(group, 0) + 1);
                }
                return groups;
            }
        };
    }

    public static Query<Integer> countNewPlayersTurnedRegular(final long after, final long before, final Long threshold) {
        String selectActivityIndex = NetworkActivityIndexQueries.selectActivityIndexSQL();
        String selectActivePlayerCount = "SELECT COUNT(1) as count FROM (" + selectActivityIndex + ") q2" + " JOIN " + "plan_users" + " u on u." + "uuid" + "=q2." + "uuid" + " WHERE " + "u." + "registered" + ">=?" + " AND " + "u." + "registered" + "<=?" + " AND " + "q2.activity_index>=?" + " AND " + "q2.activity_index<?";
        return new QueryStatement<Integer>(selectActivePlayerCount){

            @Override
            public void prepare(PreparedStatement statement) throws SQLException {
                NetworkActivityIndexQueries.setSelectActivityIndexSQLParameters(statement, 1, threshold, before);
                statement.setLong(9, after);
                statement.setLong(10, before);
                statement.setDouble(11, 2.0);
                statement.setDouble(12, 5.1);
            }

            @Override
            public Integer processResults(ResultSet set) throws SQLException {
                return set.next() ? set.getInt("count") : 0;
            }
        };
    }

    public static Query<Integer> countRegularPlayersTurnedInactive(final long start, final long end, final Long threshold) {
        String selectActivityIndex = NetworkActivityIndexQueries.selectActivityIndexSQL();
        String selectActivePlayerCount = "SELECT COUNT(1) as count FROM (" + selectActivityIndex + ") q2" + " JOIN " + '(' + selectActivityIndex.replace("q1", "q3") + ") q4 on q2." + "uuid" + "=q4." + "uuid" + " WHERE " + "q2.activity_index>=?" + " AND " + "q2.activity_index<?" + " AND " + "q4.activity_index>=?" + " AND " + "q4.activity_index<?";
        return new QueryStatement<Integer>(selectActivePlayerCount){

            @Override
            public void prepare(PreparedStatement statement) throws SQLException {
                NetworkActivityIndexQueries.setSelectActivityIndexSQLParameters(statement, 1, threshold, end);
                NetworkActivityIndexQueries.setSelectActivityIndexSQLParameters(statement, 9, threshold, start);
                statement.setDouble(17, 2.0);
                statement.setDouble(18, 5.1);
                statement.setDouble(19, -0.1);
                statement.setDouble(20, 1.0);
            }

            @Override
            public Integer processResults(ResultSet set) throws SQLException {
                return set.next() ? set.getInt("count") : 0;
            }
        };
    }

    public static Query<Long> averagePlaytimePerRegularPlayer(final long after, final long before, final Long threshold) {
        return database -> {
            String selectPlaytimePerPlayer = "SELECT p.uuid,SUM(p.session_end-p.session_start) as playtime FROM plan_sessions p JOIN (" + NetworkActivityIndexQueries.selectActivityIndexSQL() + ") q2 on q2." + "uuid" + "=p." + "uuid" + " WHERE " + "p." + "session_end" + "<=?" + " AND " + "p." + "session_start" + ">=?" + " AND " + "q2.activity_index>=?" + " AND " + "q2.activity_index<?" + " GROUP BY " + "p." + "uuid";
            String selectAverage = "SELECT AVG(playtime) as average FROM (" + selectPlaytimePerPlayer + ") q1";
            return database.query(new QueryStatement<Long>(selectAverage, 100){

                @Override
                public void prepare(PreparedStatement statement) throws SQLException {
                    NetworkActivityIndexQueries.setSelectActivityIndexSQLParameters(statement, 1, threshold, before);
                    statement.setLong(9, before);
                    statement.setLong(10, after);
                    statement.setDouble(11, 2.0);
                    statement.setDouble(12, 5.1);
                }

                @Override
                public Long processResults(ResultSet set) throws SQLException {
                    return set.next() ? (long)set.getDouble("average") : 0L;
                }
            });
        };
    }

    public static Query<Long> averageSessionLengthPerRegularPlayer(final long after, final long before, final Long threshold) {
        return database -> {
            String selectSessionLengthPerPlayer = "SELECT p.uuid,p.session_end-p.session_start as length FROM plan_sessions p JOIN (" + NetworkActivityIndexQueries.selectActivityIndexSQL() + ") q2 on q2." + "uuid" + "=p." + "uuid" + " WHERE " + "p." + "session_end" + "<=?" + " AND " + "p." + "session_start" + ">=?" + " AND " + "q2.activity_index>=?" + " AND " + "q2.activity_index<?";
            String selectAverage = "SELECT AVG(length) as average FROM (" + selectSessionLengthPerPlayer + ") q1";
            return database.query(new QueryStatement<Long>(selectAverage, 100){

                @Override
                public void prepare(PreparedStatement statement) throws SQLException {
                    NetworkActivityIndexQueries.setSelectActivityIndexSQLParameters(statement, 1, threshold, before);
                    statement.setLong(9, before);
                    statement.setLong(10, after);
                    statement.setDouble(11, 2.0);
                    statement.setDouble(12, 5.1);
                }

                @Override
                public Long processResults(ResultSet set) throws SQLException {
                    return set.next() ? (long)set.getDouble("average") : 0L;
                }
            });
        };
    }

    public static Query<Long> averageAFKPerRegularPlayer(final long after, final long before, final Long threshold) {
        return database -> {
            String selectPlaytimePerPlayer = "SELECT p.uuid,SUM(p.afk_time) as afk FROM plan_sessions p JOIN (" + NetworkActivityIndexQueries.selectActivityIndexSQL() + ") q2 on q2." + "uuid" + "=p." + "uuid" + " WHERE " + "p." + "session_end" + "<=?" + " AND " + "p." + "session_start" + ">=?" + " AND " + "q2.activity_index>=?" + " AND " + "q2.activity_index<?" + " GROUP BY " + "p." + "uuid";
            String selectAverage = "SELECT AVG(afk) as average FROM (" + selectPlaytimePerPlayer + ") q1";
            return database.query(new QueryStatement<Long>(selectAverage, 100){

                @Override
                public void prepare(PreparedStatement statement) throws SQLException {
                    NetworkActivityIndexQueries.setSelectActivityIndexSQLParameters(statement, 1, threshold, before);
                    statement.setLong(9, before);
                    statement.setLong(10, after);
                    statement.setDouble(11, 2.0);
                    statement.setDouble(12, 5.1);
                }

                @Override
                public Long processResults(ResultSet set) throws SQLException {
                    return set.next() ? (long)set.getDouble("average") : 0L;
                }
            });
        };
    }

    public static Query<Collection<ActivityIndex>> activityIndexForNewPlayers(final long after, final long before, final Long threshold) {
        String selectNewUUIDs = "SELECT uuid FROM plan_users WHERE registered<=? AND registered>=?";
        String sql = "SELECT activity_index FROM (" + selectNewUUIDs + ") n" + " JOIN " + '(' + NetworkActivityIndexQueries.selectActivityIndexSQL() + ") a on n." + "uuid" + "=a." + "uuid";
        return new QueryStatement<Collection<ActivityIndex>>(sql){

            @Override
            public void prepare(PreparedStatement statement) throws SQLException {
                statement.setLong(1, before);
                statement.setLong(2, after);
                NetworkActivityIndexQueries.setSelectActivityIndexSQLParameters(statement, 3, threshold, before);
            }

            @Override
            public Collection<ActivityIndex> processResults(ResultSet set) throws SQLException {
                ArrayList<ActivityIndex> indexes = new ArrayList<ActivityIndex>();
                while (set.next()) {
                    indexes.add(new ActivityIndex(set.getDouble("activity_index"), before));
                }
                return indexes;
            }
        };
    }

    public static Query<ActivityIndex> averageActivityIndexForRetainedPlayers(final long after, final long before, final Long threshold) {
        String selectNewUUIDs = "SELECT uuid FROM plan_users WHERE registered<=? AND registered>=?";
        String selectUniqueUUIDs = "SELECT DISTINCT uuid FROM plan_sessions WHERE session_start>=? AND session_end<=?";
        String sql = "SELECT AVG(activity_index) as average FROM (" + selectNewUUIDs + ") n" + " JOIN " + '(' + selectUniqueUUIDs + ") u on n." + "uuid" + "=u." + "uuid" + " JOIN " + '(' + NetworkActivityIndexQueries.selectActivityIndexSQL() + ") a on n." + "uuid" + "=a." + "uuid";
        return new QueryStatement<ActivityIndex>(sql){

            @Override
            public void prepare(PreparedStatement statement) throws SQLException {
                statement.setLong(1, before);
                statement.setLong(2, after);
                long half = before - (before - after) / 2L;
                statement.setLong(3, half);
                statement.setLong(4, before);
                NetworkActivityIndexQueries.setSelectActivityIndexSQLParameters(statement, 5, threshold, before);
            }

            @Override
            public ActivityIndex processResults(ResultSet set) throws SQLException {
                return set.next() ? new ActivityIndex(set.getDouble("average"), before) : new ActivityIndex(0.0, before);
            }
        };
    }

    public static Query<ActivityIndex> averageActivityIndexForNonRetainedPlayers(final long after, final long before, final Long threshold) {
        String selectNewUUIDs = "SELECT uuid FROM plan_users WHERE registered<=? AND registered>=?";
        String selectUniqueUUIDs = "SELECT DISTINCT uuid FROM plan_sessions WHERE session_start>=? AND session_end<=?";
        String sql = "SELECT AVG(activity_index) as average FROM (" + selectNewUUIDs + ") n" + " LEFT JOIN " + '(' + selectUniqueUUIDs + ") u on n." + "uuid" + "=u." + "uuid" + " JOIN " + '(' + NetworkActivityIndexQueries.selectActivityIndexSQL() + ") a on n." + "uuid" + "=a." + "uuid" + " WHERE " + "n." + "uuid" + " IS NULL";
        return new QueryStatement<ActivityIndex>(sql){

            @Override
            public void prepare(PreparedStatement statement) throws SQLException {
                statement.setLong(1, before);
                statement.setLong(2, after);
                long half = before - (before - after) / 2L;
                statement.setLong(3, half);
                statement.setLong(4, before);
                NetworkActivityIndexQueries.setSelectActivityIndexSQLParameters(statement, 5, threshold, before);
            }

            @Override
            public ActivityIndex processResults(ResultSet set) throws SQLException {
                return set.next() ? new ActivityIndex(set.getDouble("average"), before) : new ActivityIndex(0.0, before);
            }
        };
    }
}

