/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plan.storage.database.queries.analysis;

import com.djrapitops.plan.storage.database.queries.Query;
import com.djrapitops.plan.storage.database.queries.QueryStatement;
import com.djrapitops.plan.storage.database.sql.building.Sql;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import java.util.UUID;

public class PlayerCountQueries {
    private PlayerCountQueries() {
    }

    private static QueryStatement<Integer> queryPlayerCount(String sql, final long after, final long before, final UUID serverUUID) {
        return new QueryStatement<Integer>(sql){

            @Override
            public void prepare(PreparedStatement statement) throws SQLException {
                statement.setLong(1, before);
                statement.setLong(2, after);
                statement.setString(3, serverUUID.toString());
            }

            @Override
            public Integer processResults(ResultSet set) throws SQLException {
                return set.next() ? set.getInt("player_count") : 0;
            }
        };
    }

    private static QueryStatement<Integer> queryPlayerCount(String sql, final long after, final long before) {
        return new QueryStatement<Integer>(sql){

            @Override
            public void prepare(PreparedStatement statement) throws SQLException {
                statement.setLong(1, before);
                statement.setLong(2, after);
            }

            @Override
            public Integer processResults(ResultSet set) throws SQLException {
                return set.next() ? set.getInt("player_count") : 0;
            }
        };
    }

    public static Query<Integer> uniquePlayerCount(long after, long before, UUID serverUUID) {
        String sql = "SELECT COUNT(DISTINCT uuid) as player_count FROM plan_sessions WHERE session_end<=? AND session_start>=? AND server_uuid=?";
        return PlayerCountQueries.queryPlayerCount(sql, after, before, serverUUID);
    }

    public static Query<Integer> uniquePlayerCount(long after, long before) {
        String sql = "SELECT COUNT(DISTINCT uuid) as player_count FROM plan_sessions WHERE session_end<=? AND session_start>=?";
        return PlayerCountQueries.queryPlayerCount(sql, after, before);
    }

    public static Query<Map<UUID, Integer>> uniquePlayerCounts(final long after, final long before) {
        String sql = "SELECT server_uuid,COUNT(DISTINCT uuid) as player_count FROM plan_sessions WHERE session_end<=? AND session_start>=? GROUP BY server_uuid";
        return new QueryStatement<Map<UUID, Integer>>(sql){

            @Override
            public void prepare(PreparedStatement statement) throws SQLException {
                statement.setLong(1, before);
                statement.setLong(2, after);
            }

            @Override
            public Map<UUID, Integer> processResults(ResultSet set) throws SQLException {
                HashMap<UUID, Integer> byServer = new HashMap<UUID, Integer>();
                while (set.next()) {
                    byServer.put(UUID.fromString(set.getString("server_uuid")), set.getInt("player_count"));
                }
                return byServer;
            }
        };
    }

    public static Query<NavigableMap<Long, Integer>> uniquePlayerCounts(final long after, final long before, final long timeZoneOffset, final UUID serverUUID) {
        return database -> {
            Sql sql = database.getSql();
            String selectUniquePlayersPerDay = "SELECT " + sql.dateToEpochSecond(sql.dateToDayStamp(sql.epochSecondToDate("(session_start+?)/1000"))) + "*1000 as date,COUNT(DISTINCT " + "uuid" + ") as player_count" + " FROM " + "plan_sessions" + " WHERE " + "session_end" + "<=?" + " AND " + "session_start" + ">=?" + " AND " + "server_uuid" + "=?" + " GROUP BY " + "date";
            return database.query(new QueryStatement<NavigableMap<Long, Integer>>(selectUniquePlayersPerDay, 100){

                @Override
                public void prepare(PreparedStatement statement) throws SQLException {
                    statement.setLong(1, timeZoneOffset);
                    statement.setLong(2, before);
                    statement.setLong(3, after);
                    statement.setString(4, serverUUID.toString());
                }

                @Override
                public NavigableMap<Long, Integer> processResults(ResultSet set) throws SQLException {
                    TreeMap<Long, Integer> uniquePerDay = new TreeMap<Long, Integer>();
                    while (set.next()) {
                        uniquePerDay.put(set.getLong("date"), set.getInt("player_count"));
                    }
                    return uniquePerDay;
                }
            });
        };
    }

    public static Query<NavigableMap<Long, Integer>> hourlyUniquePlayerCounts(final long after, final long before, final long timeZoneOffset, final UUID serverUUID) {
        return database -> {
            Sql sql = database.getSql();
            String selectUniquePlayersPerDay = "SELECT " + sql.dateToEpochSecond(sql.dateToHourStamp(sql.epochSecondToDate("(session_start+?)/1000"))) + "*1000 as date,COUNT(DISTINCT " + "uuid" + ") as player_count" + " FROM " + "plan_sessions" + " WHERE " + "session_end" + "<=?" + " AND " + "session_start" + ">=?" + " AND " + "server_uuid" + "=?" + " GROUP BY " + "date";
            return database.query(new QueryStatement<NavigableMap<Long, Integer>>(selectUniquePlayersPerDay, 100){

                @Override
                public void prepare(PreparedStatement statement) throws SQLException {
                    statement.setLong(1, timeZoneOffset);
                    statement.setLong(2, before);
                    statement.setLong(3, after);
                    statement.setString(4, serverUUID.toString());
                }

                @Override
                public NavigableMap<Long, Integer> processResults(ResultSet set) throws SQLException {
                    TreeMap<Long, Integer> uniquePerDay = new TreeMap<Long, Integer>();
                    while (set.next()) {
                        uniquePerDay.put(set.getLong("date"), set.getInt("player_count"));
                    }
                    return uniquePerDay;
                }
            });
        };
    }

    public static Query<NavigableMap<Long, Integer>> uniquePlayerCounts(final long after, final long before, final long timeZoneOffset) {
        return database -> {
            Sql sql = database.getSql();
            String selectUniquePlayersPerDay = "SELECT " + sql.dateToEpochSecond(sql.dateToDayStamp(sql.epochSecondToDate("(session_start+?)/1000"))) + "*1000 as date,COUNT(DISTINCT " + "uuid" + ") as player_count" + " FROM " + "plan_sessions" + " WHERE " + "session_end" + "<=?" + " AND " + "session_start" + ">=?" + " GROUP BY " + "date";
            return database.query(new QueryStatement<NavigableMap<Long, Integer>>(selectUniquePlayersPerDay, 100){

                @Override
                public void prepare(PreparedStatement statement) throws SQLException {
                    statement.setLong(1, timeZoneOffset);
                    statement.setLong(2, before);
                    statement.setLong(3, after);
                }

                @Override
                public NavigableMap<Long, Integer> processResults(ResultSet set) throws SQLException {
                    TreeMap<Long, Integer> uniquePerDay = new TreeMap<Long, Integer>();
                    while (set.next()) {
                        uniquePerDay.put(set.getLong("date"), set.getInt("player_count"));
                    }
                    return uniquePerDay;
                }
            });
        };
    }

    public static Query<NavigableMap<Long, Integer>> hourlyUniquePlayerCounts(final long after, final long before, final long timeZoneOffset) {
        return database -> {
            Sql sql = database.getSql();
            String selectUniquePlayersPerDay = "SELECT " + sql.dateToEpochSecond(sql.dateToHourStamp(sql.epochSecondToDate("(session_start+?)/1000"))) + "*1000 as date,COUNT(DISTINCT " + "uuid" + ") as player_count" + " FROM " + "plan_sessions" + " WHERE " + "session_end" + "<=?" + " AND " + "session_start" + ">=?" + " GROUP BY " + "date";
            return database.query(new QueryStatement<NavigableMap<Long, Integer>>(selectUniquePlayersPerDay, 100){

                @Override
                public void prepare(PreparedStatement statement) throws SQLException {
                    statement.setLong(1, timeZoneOffset);
                    statement.setLong(2, before);
                    statement.setLong(3, after);
                }

                @Override
                public NavigableMap<Long, Integer> processResults(ResultSet set) throws SQLException {
                    TreeMap<Long, Integer> uniquePerDay = new TreeMap<Long, Integer>();
                    while (set.next()) {
                        uniquePerDay.put(set.getLong("date"), set.getInt("player_count"));
                    }
                    return uniquePerDay;
                }
            });
        };
    }

    public static Query<Integer> averageUniquePlayerCount(final long after, final long before, final long timeZoneOffset, final UUID serverUUID) {
        return database -> {
            Sql sql = database.getSql();
            String selectUniquePlayersPerDay = "SELECT " + sql.dateToEpochSecond(sql.dateToDayStamp(sql.epochSecondToDate("(session_start+?)/1000"))) + "*1000 as date,COUNT(DISTINCT " + "uuid" + ") as player_count" + " FROM " + "plan_sessions" + " WHERE " + "session_end" + "<=?" + " AND " + "session_start" + ">=?" + " AND " + "server_uuid" + "=?" + " GROUP BY " + "date";
            String selectAverage = "SELECT AVG(player_count) as average FROM (" + selectUniquePlayersPerDay + ") q1";
            return database.query(new QueryStatement<Integer>(selectAverage, 100){

                @Override
                public void prepare(PreparedStatement statement) throws SQLException {
                    statement.setLong(1, timeZoneOffset);
                    statement.setLong(2, before);
                    statement.setLong(3, after);
                    statement.setString(4, serverUUID.toString());
                }

                @Override
                public Integer processResults(ResultSet set) throws SQLException {
                    return set.next() ? (int)set.getDouble("average") : 0;
                }
            });
        };
    }

    public static Query<Integer> newPlayerCount(long after, long before, UUID serverUUID) {
        String sql = "SELECT COUNT(1) as player_count FROM plan_user_info WHERE registered<=? AND registered>=? AND server_uuid=?";
        return PlayerCountQueries.queryPlayerCount(sql, after, before, serverUUID);
    }

    public static Query<Integer> newPlayerCount(long after, long before) {
        String sql = "SELECT COUNT(1) as player_count FROM plan_users WHERE registered<=? AND registered>=?";
        return PlayerCountQueries.queryPlayerCount(sql, after, before);
    }

    public static Query<Map<UUID, Integer>> newPlayerCounts(final long after, final long before) {
        String sql = "SELECT server_uuid,COUNT(1) as player_count FROM plan_user_info WHERE registered<=? AND registered>=? GROUP BY server_uuid";
        return new QueryStatement<Map<UUID, Integer>>(sql){

            @Override
            public void prepare(PreparedStatement statement) throws SQLException {
                statement.setLong(1, before);
                statement.setLong(2, after);
            }

            @Override
            public Map<UUID, Integer> processResults(ResultSet set) throws SQLException {
                HashMap<UUID, Integer> byServer = new HashMap<UUID, Integer>();
                while (set.next()) {
                    byServer.put(UUID.fromString(set.getString("server_uuid")), set.getInt("player_count"));
                }
                return byServer;
            }
        };
    }

    public static Query<NavigableMap<Long, Integer>> newPlayerCounts(final long after, final long before, final long timeZoneOffset, final UUID serverUUID) {
        return database -> {
            Sql sql = database.getSql();
            String selectNewPlayersQuery = "SELECT " + sql.dateToEpochSecond(sql.dateToDayStamp(sql.epochSecondToDate("(registered+?)/1000"))) + "*1000 as date,COUNT(1) as player_count" + " FROM " + "plan_user_info" + " WHERE " + "registered" + "<=?" + " AND " + "registered" + ">=?" + " AND " + "server_uuid" + "=?" + " GROUP BY " + "date";
            return database.query(new QueryStatement<NavigableMap<Long, Integer>>(selectNewPlayersQuery, 100){

                @Override
                public void prepare(PreparedStatement statement) throws SQLException {
                    statement.setLong(1, timeZoneOffset);
                    statement.setLong(2, before);
                    statement.setLong(3, after);
                    statement.setString(4, serverUUID.toString());
                }

                @Override
                public NavigableMap<Long, Integer> processResults(ResultSet set) throws SQLException {
                    TreeMap<Long, Integer> newPerDay = new TreeMap<Long, Integer>();
                    while (set.next()) {
                        newPerDay.put(set.getLong("date"), set.getInt("player_count"));
                    }
                    return newPerDay;
                }
            });
        };
    }

    public static Query<NavigableMap<Long, Integer>> hourlyNewPlayerCounts(final long after, final long before, final long timeZoneOffset, final UUID serverUUID) {
        return database -> {
            Sql sql = database.getSql();
            String selectNewPlayersQuery = "SELECT " + sql.dateToEpochSecond(sql.dateToHourStamp(sql.epochSecondToDate("(registered+?)/1000"))) + "*1000 as date,COUNT(1) as player_count" + " FROM " + "plan_user_info" + " WHERE " + "registered" + "<=?" + " AND " + "registered" + ">=?" + " AND " + "server_uuid" + "=?" + " GROUP BY " + "date";
            return database.query(new QueryStatement<NavigableMap<Long, Integer>>(selectNewPlayersQuery, 100){

                @Override
                public void prepare(PreparedStatement statement) throws SQLException {
                    statement.setLong(1, timeZoneOffset);
                    statement.setLong(2, before);
                    statement.setLong(3, after);
                    statement.setString(4, serverUUID.toString());
                }

                @Override
                public NavigableMap<Long, Integer> processResults(ResultSet set) throws SQLException {
                    TreeMap<Long, Integer> newPerDay = new TreeMap<Long, Integer>();
                    while (set.next()) {
                        newPerDay.put(set.getLong("date"), set.getInt("player_count"));
                    }
                    return newPerDay;
                }
            });
        };
    }

    public static Query<NavigableMap<Long, Integer>> newPlayerCounts(final long after, final long before, final long timeZoneOffset) {
        return database -> {
            Sql sql = database.getSql();
            String selectNewPlayersQuery = "SELECT " + sql.dateToEpochSecond(sql.dateToDayStamp(sql.epochSecondToDate("(registered+?)/1000"))) + "*1000 as date,COUNT(1) as player_count" + " FROM " + "plan_users" + " WHERE " + "registered" + "<=?" + " AND " + "registered" + ">=?" + " GROUP BY " + "date";
            return database.query(new QueryStatement<NavigableMap<Long, Integer>>(selectNewPlayersQuery, 100){

                @Override
                public void prepare(PreparedStatement statement) throws SQLException {
                    statement.setLong(1, timeZoneOffset);
                    statement.setLong(2, before);
                    statement.setLong(3, after);
                }

                @Override
                public NavigableMap<Long, Integer> processResults(ResultSet set) throws SQLException {
                    TreeMap<Long, Integer> newPerDay = new TreeMap<Long, Integer>();
                    while (set.next()) {
                        newPerDay.put(set.getLong("date"), set.getInt("player_count"));
                    }
                    return newPerDay;
                }
            });
        };
    }

    public static Query<NavigableMap<Long, Integer>> hourlyNewPlayerCounts(final long after, final long before, final long timeZoneOffset) {
        return database -> {
            Sql sql = database.getSql();
            String selectNewPlayersQuery = "SELECT " + sql.dateToEpochSecond(sql.dateToHourStamp(sql.epochSecondToDate("(registered+?)/1000"))) + "*1000 as date,COUNT(1) as player_count" + " FROM " + "plan_users" + " WHERE " + "registered" + "<=?" + " AND " + "registered" + ">=?" + " GROUP BY " + "date";
            return database.query(new QueryStatement<NavigableMap<Long, Integer>>(selectNewPlayersQuery, 100){

                @Override
                public void prepare(PreparedStatement statement) throws SQLException {
                    statement.setLong(1, timeZoneOffset);
                    statement.setLong(2, before);
                    statement.setLong(3, after);
                }

                @Override
                public NavigableMap<Long, Integer> processResults(ResultSet set) throws SQLException {
                    TreeMap<Long, Integer> newPerDay = new TreeMap<Long, Integer>();
                    while (set.next()) {
                        newPerDay.put(set.getLong("date"), set.getInt("player_count"));
                    }
                    return newPerDay;
                }
            });
        };
    }

    public static Query<Integer> averageNewPlayerCount(final long after, final long before, final long timeZoneOffset, final UUID serverUUID) {
        return database -> {
            Sql sql = database.getSql();
            String selectNewPlayersQuery = "SELECT " + sql.dateToEpochSecond(sql.dateToDayStamp(sql.epochSecondToDate("(registered+?)/1000"))) + "*1000 as date,COUNT(1) as player_count" + " FROM " + "plan_user_info" + " WHERE " + "registered" + "<=?" + " AND " + "registered" + ">=?" + " AND " + "server_uuid" + "=?" + " GROUP BY " + "date";
            String selectAverage = "SELECT AVG(player_count) as average FROM (" + selectNewPlayersQuery + ") q1";
            return database.query(new QueryStatement<Integer>(selectAverage, 100){

                @Override
                public void prepare(PreparedStatement statement) throws SQLException {
                    statement.setLong(1, timeZoneOffset);
                    statement.setLong(2, before);
                    statement.setLong(3, after);
                    statement.setString(4, serverUUID.toString());
                }

                @Override
                public Integer processResults(ResultSet set) throws SQLException {
                    return set.next() ? (int)set.getDouble("average") : 0;
                }
            });
        };
    }

    public static Query<Integer> retainedPlayerCount(final long after, final long before, final UUID serverUUID) {
        String selectNewUUIDs = "SELECT uuid FROM plan_user_info WHERE registered>=? AND registered<=? AND server_uuid=?";
        String selectUniqueUUIDs = "SELECT DISTINCT uuid FROM plan_sessions WHERE session_start>=? AND session_end<=? AND server_uuid=?";
        String sql = "SELECT COUNT(1) as player_count FROM (" + selectNewUUIDs + ") q1" + " JOIN " + '(' + selectUniqueUUIDs + ") q2 on q1." + "uuid" + "=q2." + "uuid";
        return new QueryStatement<Integer>(sql){

            @Override
            public void prepare(PreparedStatement statement) throws SQLException {
                statement.setLong(1, after);
                statement.setLong(2, before);
                statement.setString(3, serverUUID.toString());
                long half = before - (before - after) / 2L;
                statement.setLong(4, half);
                statement.setLong(5, before);
                statement.setString(6, serverUUID.toString());
            }

            @Override
            public Integer processResults(ResultSet set) throws SQLException {
                return set.next() ? set.getInt("player_count") : 0;
            }
        };
    }

    public static Query<Integer> operators(final UUID serverUUID) {
        String sql = "SELECT COUNT(1) as player_count FROM plan_user_info WHERE server_uuid=? AND opped=?";
        return new QueryStatement<Integer>(sql){

            @Override
            public void prepare(PreparedStatement statement) throws SQLException {
                statement.setString(1, serverUUID.toString());
                statement.setBoolean(2, true);
            }

            @Override
            public Integer processResults(ResultSet set) throws SQLException {
                return set.next() ? set.getInt("player_count") : 0;
            }
        };
    }
}

