/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plan.storage.database.queries.containers;

import com.djrapitops.plan.delivery.domain.container.DataContainer;
import com.djrapitops.plan.delivery.domain.container.PerServerContainer;
import com.djrapitops.plan.delivery.domain.container.SupplierDataContainer;
import com.djrapitops.plan.delivery.domain.keys.Key;
import com.djrapitops.plan.delivery.domain.keys.PerServerKeys;
import com.djrapitops.plan.gathering.domain.Session;
import com.djrapitops.plan.gathering.domain.UserInfo;
import com.djrapitops.plan.storage.database.SQLDB;
import com.djrapitops.plan.storage.database.queries.PerServerAggregateQueries;
import com.djrapitops.plan.storage.database.queries.Query;
import com.djrapitops.plan.storage.database.queries.objects.SessionQueries;
import com.djrapitops.plan.storage.database.queries.objects.UserInfoQueries;
import com.djrapitops.plan.storage.database.queries.objects.WorldTimesQueries;
import java.util.List;
import java.util.Map;
import java.util.UUID;

public class PerServerContainerQuery
implements Query<PerServerContainer> {
    private final UUID playerUUID;

    public PerServerContainerQuery(UUID playerUUID) {
        this.playerUUID = playerUUID;
    }

    @Override
    public PerServerContainer executeQuery(SQLDB db) {
        PerServerContainer perServerContainer = new PerServerContainer();
        this.userInformation(db, perServerContainer);
        this.lastSeen(db, perServerContainer);
        this.playerKillCount(db, perServerContainer);
        this.mobKillCount(db, perServerContainer);
        this.totalDeathCount(db, perServerContainer);
        this.worldTimes(db, perServerContainer);
        Map<UUID, List<Session>> sessions = db.query(SessionQueries.fetchSessionsOfPlayer(this.playerUUID));
        for (Map.Entry<UUID, List<Session>> entry : sessions.entrySet()) {
            UUID serverUUID = entry.getKey();
            List<Session> serverSessions = entry.getValue();
            DataContainer serverContainer = perServerContainer.getOrDefault(serverUUID, new SupplierDataContainer());
            serverContainer.putRawData(PerServerKeys.SESSIONS, serverSessions);
            perServerContainer.put(serverUUID, serverContainer);
        }
        return perServerContainer;
    }

    private void totalDeathCount(SQLDB db, PerServerContainer container) {
        this.matchingEntrySet(PerServerKeys.DEATH_COUNT, PerServerAggregateQueries.totalDeathCountOnServers(this.playerUUID), db, container);
    }

    private void worldTimes(SQLDB db, PerServerContainer container) {
        this.matchingEntrySet(PerServerKeys.WORLD_TIMES, WorldTimesQueries.fetchPlayerWorldTimesOnServers(this.playerUUID), db, container);
    }

    private void mobKillCount(SQLDB db, PerServerContainer container) {
        this.matchingEntrySet(PerServerKeys.MOB_KILL_COUNT, PerServerAggregateQueries.mobKillCountOnServers(this.playerUUID), db, container);
    }

    private void playerKillCount(SQLDB db, PerServerContainer container) {
        this.matchingEntrySet(PerServerKeys.PLAYER_KILL_COUNT, PerServerAggregateQueries.playerKillCountOnServers(this.playerUUID), db, container);
    }

    private void lastSeen(SQLDB db, PerServerContainer container) {
        this.matchingEntrySet(PerServerKeys.LAST_SEEN, PerServerAggregateQueries.lastSeenOnServers(this.playerUUID), db, container);
    }

    private void userInformation(SQLDB db, PerServerContainer container) {
        List<UserInfo> userInformation = db.query(UserInfoQueries.fetchUserInformationOfUser(this.playerUUID));
        container.putUserInfo(userInformation);
    }

    private <T> void matchingEntrySet(Key<T> key, Query<Map<UUID, T>> map, SQLDB db, PerServerContainer container) {
        for (Map.Entry<UUID, T> entry : db.query(map).entrySet()) {
            container.putToContainerOfServer(entry.getKey(), key, entry.getValue());
        }
    }
}

