/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plan.storage.database.queries.containers;

import com.djrapitops.plan.delivery.domain.container.ServerContainer;
import com.djrapitops.plan.delivery.domain.keys.ServerKeys;
import com.djrapitops.plan.delivery.domain.mutators.PlayersMutator;
import com.djrapitops.plan.delivery.domain.mutators.SessionsMutator;
import com.djrapitops.plan.extension.implementation.storage.queries.ExtensionServerDataQuery;
import com.djrapitops.plan.gathering.cache.SessionCache;
import com.djrapitops.plan.gathering.domain.Session;
import com.djrapitops.plan.identification.Server;
import com.djrapitops.plan.storage.database.SQLDB;
import com.djrapitops.plan.storage.database.queries.Query;
import com.djrapitops.plan.storage.database.queries.containers.ServerPlayerContainersQuery;
import com.djrapitops.plan.storage.database.queries.objects.ServerQueries;
import com.djrapitops.plan.storage.database.queries.objects.TPSQueries;
import com.djrapitops.plan.storage.database.queries.objects.WorldTimesQueries;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.TimeUnit;

public class ServerContainerQuery
implements Query<ServerContainer> {
    private final UUID serverUUID;

    public ServerContainerQuery(UUID serverUUID) {
        this.serverUUID = serverUUID;
    }

    @Override
    public ServerContainer executeQuery(SQLDB db) {
        ServerContainer container = new ServerContainer();
        Optional<Server> serverInfo = db.query(ServerQueries.fetchServerMatchingIdentifier(this.serverUUID));
        if (!serverInfo.isPresent()) {
            return container;
        }
        container.putRawData(ServerKeys.SERVER_UUID, this.serverUUID);
        container.putRawData(ServerKeys.NAME, serverInfo.get().getName());
        container.putCachingSupplier(ServerKeys.PLAYERS, () -> db.query(new ServerPlayerContainersQuery(this.serverUUID)));
        container.putSupplier(ServerKeys.PLAYER_COUNT, () -> container.getValue(ServerKeys.PLAYERS).map(Collection::size).orElse(0));
        container.putCachingSupplier(ServerKeys.TPS, () -> db.query(TPSQueries.fetchTPSDataOfServer(this.serverUUID)));
        container.putCachingSupplier(ServerKeys.PING, () -> PlayersMutator.forContainer(container).pings());
        container.putCachingSupplier(ServerKeys.ALL_TIME_PEAK_PLAYERS, () -> db.query(TPSQueries.fetchAllTimePeakPlayerCount(this.serverUUID)).orElse(null));
        container.putCachingSupplier(ServerKeys.RECENT_PEAK_PLAYERS, () -> {
            long twoDaysAgo = System.currentTimeMillis() - TimeUnit.DAYS.toMillis(2L);
            return db.query(TPSQueries.fetchPeakPlayerCount(this.serverUUID, twoDaysAgo)).orElse(null);
        });
        container.putCachingSupplier(ServerKeys.WORLD_TIMES, () -> db.query(WorldTimesQueries.fetchServerTotalWorldTimes(this.serverUUID)));
        container.putCachingSupplier(ServerKeys.OPERATORS, () -> PlayersMutator.forContainer(container).operators());
        container.putCachingSupplier(ServerKeys.SESSIONS, () -> {
            List<Session> sessions = PlayersMutator.forContainer(container).getSessions();
            if (this.serverUUID.equals(((Server)serverInfo.get()).getUuid())) {
                sessions.addAll(SessionCache.getActiveSessions().values());
            }
            return sessions;
        });
        container.putCachingSupplier(ServerKeys.PLAYER_KILLS, () -> SessionsMutator.forContainer(container).toPlayerKillList());
        container.putCachingSupplier(ServerKeys.PLAYER_KILL_COUNT, () -> container.getUnsafe(ServerKeys.PLAYER_KILLS).size());
        container.putCachingSupplier(ServerKeys.MOB_KILL_COUNT, () -> SessionsMutator.forContainer(container).toMobKillCount());
        container.putCachingSupplier(ServerKeys.DEATH_COUNT, () -> SessionsMutator.forContainer(container).toDeathCount());
        container.putCachingSupplier(ServerKeys.EXTENSION_DATA, () -> db.query(new ExtensionServerDataQuery(this.serverUUID)));
        return container;
    }
}

