/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plan.storage.database.queries.containers;

import com.djrapitops.plan.delivery.domain.Nickname;
import com.djrapitops.plan.delivery.domain.container.PerServerContainer;
import com.djrapitops.plan.delivery.domain.container.PlayerContainer;
import com.djrapitops.plan.delivery.domain.keys.PlayerKeys;
import com.djrapitops.plan.delivery.domain.keys.SessionKeys;
import com.djrapitops.plan.delivery.domain.mutators.PerServerMutator;
import com.djrapitops.plan.delivery.domain.mutators.SessionsMutator;
import com.djrapitops.plan.gathering.domain.BaseUser;
import com.djrapitops.plan.gathering.domain.GeoInfo;
import com.djrapitops.plan.gathering.domain.Ping;
import com.djrapitops.plan.gathering.domain.Session;
import com.djrapitops.plan.gathering.domain.UserInfo;
import com.djrapitops.plan.gathering.domain.WorldTimes;
import com.djrapitops.plan.storage.database.SQLDB;
import com.djrapitops.plan.storage.database.queries.Query;
import com.djrapitops.plan.storage.database.queries.objects.BaseUserQueries;
import com.djrapitops.plan.storage.database.queries.objects.GeoInfoQueries;
import com.djrapitops.plan.storage.database.queries.objects.NicknameQueries;
import com.djrapitops.plan.storage.database.queries.objects.PingQueries;
import com.djrapitops.plan.storage.database.queries.objects.SessionQueries;
import com.djrapitops.plan.storage.database.queries.objects.UserInfoQueries;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;

public class ServerPlayerContainersQuery
implements Query<List<PlayerContainer>> {
    private final UUID serverUUID;

    public ServerPlayerContainersQuery(UUID serverUUID) {
        this.serverUUID = serverUUID;
    }

    @Override
    public List<PlayerContainer> executeQuery(SQLDB db) {
        ArrayList<PlayerContainer> containers = new ArrayList<PlayerContainer>();
        Collection<BaseUser> baseUsers = db.query(BaseUserQueries.fetchServerBaseUsers(this.serverUUID));
        Map<UUID, List<GeoInfo>> geoInformation = db.query(GeoInfoQueries.fetchServerGeoInformation(this.serverUUID));
        Map<UUID, List<Nickname>> nicknames = db.query(NicknameQueries.fetchNicknameDataOfServer(this.serverUUID));
        Map<UUID, List<Ping>> pingData = db.query(PingQueries.fetchPingDataOfServer(this.serverUUID));
        Map<UUID, List<Session>> sessions = db.query(SessionQueries.fetchSessionsOfServer(this.serverUUID));
        Map<UUID, UserInfo> userInformation = db.query(UserInfoQueries.fetchUserInformationOfServer(this.serverUUID));
        Map<UUID, PerServerContainer> perServerInfo = this.getPerServerData(userInformation, sessions, pingData);
        for (BaseUser user : baseUsers) {
            PlayerContainer container = new PlayerContainer();
            UUID uuid = user.getUuid();
            container.putRawData(PlayerKeys.UUID, uuid);
            container.putRawData(PlayerKeys.NAME, user.getName());
            container.putRawData(PlayerKeys.REGISTERED, user.getRegistered());
            container.putRawData(PlayerKeys.KICK_COUNT, user.getTimesKicked());
            container.putRawData(PlayerKeys.GEO_INFO, geoInformation.getOrDefault(uuid, Collections.emptyList()));
            container.putRawData(PlayerKeys.PING, pingData.get(uuid));
            container.putRawData(PlayerKeys.NICKNAMES, nicknames.get(uuid));
            container.putRawData(PlayerKeys.PER_SERVER, perServerInfo.get(uuid));
            container.putCachingSupplier(PlayerKeys.SESSIONS, () -> {
                List playerSessions = sessions.getOrDefault(uuid, new ArrayList());
                container.getValue(PlayerKeys.ACTIVE_SESSION).ifPresent(playerSessions::add);
                return playerSessions;
            });
            container.putCachingSupplier(PlayerKeys.WORLD_TIMES, () -> {
                WorldTimes worldTimes = new PerServerMutator(container.getUnsafe(PlayerKeys.PER_SERVER)).flatMapWorldTimes();
                container.getValue(PlayerKeys.ACTIVE_SESSION).ifPresent(session -> worldTimes.add(session.getValue(SessionKeys.WORLD_TIMES).orElse(new WorldTimes())));
                return worldTimes;
            });
            container.putSupplier(PlayerKeys.BANNED, () -> PerServerMutator.forContainer(container).isBanned());
            container.putSupplier(PlayerKeys.OPERATOR, () -> PerServerMutator.forContainer(container).isOperator());
            container.putSupplier(PlayerKeys.LAST_SEEN, () -> SessionsMutator.forContainer(container).toLastSeen());
            container.putSupplier(PlayerKeys.PLAYER_KILLS, () -> SessionsMutator.forContainer(container).toPlayerKillList());
            container.putSupplier(PlayerKeys.PLAYER_KILL_COUNT, () -> container.getUnsafe(PlayerKeys.PLAYER_KILLS).size());
            container.putSupplier(PlayerKeys.MOB_KILL_COUNT, () -> SessionsMutator.forContainer(container).toMobKillCount());
            container.putSupplier(PlayerKeys.DEATH_COUNT, () -> SessionsMutator.forContainer(container).toDeathCount());
            containers.add(container);
        }
        return containers;
    }

    private Map<UUID, PerServerContainer> getPerServerData(Map<UUID, UserInfo> userInformation, Map<UUID, List<Session>> sessions, Map<UUID, List<Ping>> ping) {
        HashMap<UUID, PerServerContainer> perServerContainers = new HashMap<UUID, PerServerContainer>();
        for (Map.Entry<UUID, UserInfo> entry : userInformation.entrySet()) {
            UUID playerUUID = entry.getKey();
            PerServerContainer perServerContainer = perServerContainers.getOrDefault(playerUUID, new PerServerContainer());
            perServerContainer.putUserInfo(entry.getValue());
            perServerContainer.putSessions((Collection<Session>)sessions.get(playerUUID));
            perServerContainer.putPing(ping.get(playerUUID));
            perServerContainer.putCalculatingSuppliers();
            perServerContainers.put(playerUUID, perServerContainer);
        }
        return perServerContainers;
    }
}

