/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plan.storage.database.queries.objects;

import com.djrapitops.plan.gathering.domain.BaseUser;
import com.djrapitops.plan.storage.database.queries.Query;
import com.djrapitops.plan.storage.database.queries.QueryAllStatement;
import com.djrapitops.plan.storage.database.queries.QueryStatement;
import com.djrapitops.plan.storage.database.sql.building.Select;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Optional;
import java.util.UUID;

public class BaseUserQueries {
    private BaseUserQueries() {
    }

    public static Query<Collection<BaseUser>> fetchAllBaseUsers() {
        String sql = Select.all("plan_users").toString();
        return new QueryAllStatement<Collection<BaseUser>>(sql, 20000){

            @Override
            public Collection<BaseUser> processResults(ResultSet set) throws SQLException {
                return BaseUserQueries.extractBaseUsers(set);
            }
        };
    }

    private static Collection<BaseUser> extractBaseUsers(ResultSet set) throws SQLException {
        HashSet<BaseUser> users = new HashSet<BaseUser>();
        while (set.next()) {
            UUID playerUUID = UUID.fromString(set.getString("uuid"));
            String name = set.getString("name");
            long registered = set.getLong("registered");
            int kicked = set.getInt("times_kicked");
            users.add(new BaseUser(playerUUID, name, registered, kicked));
        }
        return users;
    }

    public static Query<Optional<BaseUser>> fetchBaseUserOfPlayer(final UUID playerUUID) {
        String sql = Select.all("plan_users").where("uuid=?").toString();
        return new QueryStatement<Optional<BaseUser>>(sql, 20000){

            @Override
            public void prepare(PreparedStatement statement) throws SQLException {
                statement.setString(1, playerUUID.toString());
            }

            @Override
            public Optional<BaseUser> processResults(ResultSet set) throws SQLException {
                if (set.next()) {
                    UUID playerUUID2 = UUID.fromString(set.getString("uuid"));
                    String name = set.getString("name");
                    long registered = set.getLong("registered");
                    int kicked = set.getInt("times_kicked");
                    return Optional.of(new BaseUser(playerUUID2, name, registered, kicked));
                }
                return Optional.empty();
            }
        };
    }

    public static Query<Collection<BaseUser>> fetchServerBaseUsers(final UUID serverUUID) {
        String sql = "SELECT plan_users.uuid,name,plan_users.registered,times_kicked FROM plan_users JOIN plan_user_info on plan_users.uuid=plan_user_info.uuid WHERE server_uuid=?";
        return new QueryStatement<Collection<BaseUser>>(sql, 1000){

            @Override
            public void prepare(PreparedStatement statement) throws SQLException {
                statement.setString(1, serverUUID.toString());
            }

            @Override
            public Collection<BaseUser> processResults(ResultSet set) throws SQLException {
                return BaseUserQueries.extractBaseUsers(set);
            }
        };
    }
}

