/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plan.storage.database.queries.objects;

import com.djrapitops.plan.gathering.domain.GeoInfo;
import com.djrapitops.plan.storage.database.queries.Query;
import com.djrapitops.plan.storage.database.queries.QueryAllStatement;
import com.djrapitops.plan.storage.database.queries.QueryStatement;
import com.djrapitops.plan.utilities.java.Lists;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;

public class GeoInfoQueries {
    private GeoInfoQueries() {
    }

    public static Query<Map<UUID, List<GeoInfo>>> fetchAllGeoInformation() {
        String sql = "SELECT geolocation,last_used,uuid FROM plan_geolocations";
        return new QueryAllStatement<Map<UUID, List<GeoInfo>>>(sql, 50000){

            @Override
            public Map<UUID, List<GeoInfo>> processResults(ResultSet set) throws SQLException {
                return GeoInfoQueries.extractGeoInformation(set);
            }
        };
    }

    private static Map<UUID, List<GeoInfo>> extractGeoInformation(ResultSet set) throws SQLException {
        HashMap<UUID, List<GeoInfo>> geoInformation = new HashMap<UUID, List<GeoInfo>>();
        while (set.next()) {
            UUID uuid = UUID.fromString(set.getString("uuid"));
            List userGeoInfo = geoInformation.computeIfAbsent(uuid, Lists::create);
            GeoInfo geoInfo = new GeoInfo(set.getString("geolocation"), set.getLong("last_used"));
            userGeoInfo.add(geoInfo);
        }
        return geoInformation;
    }

    public static Query<List<GeoInfo>> fetchPlayerGeoInformation(final UUID playerUUID) {
        String sql = "SELECT geolocation,MAX(last_used) as last_used FROM plan_geolocations WHERE uuid=? GROUP BY geolocation";
        return new QueryStatement<List<GeoInfo>>(sql, 100){

            @Override
            public void prepare(PreparedStatement statement) throws SQLException {
                statement.setString(1, playerUUID.toString());
            }

            @Override
            public List<GeoInfo> processResults(ResultSet set) throws SQLException {
                ArrayList<GeoInfo> geoInfo = new ArrayList<GeoInfo>();
                while (set.next()) {
                    String geolocation = set.getString("geolocation");
                    long lastUsed = set.getLong("last_used");
                    geoInfo.add(new GeoInfo(geolocation, lastUsed));
                }
                return geoInfo;
            }
        };
    }

    public static Query<Map<UUID, List<GeoInfo>>> fetchServerGeoInformation(final UUID serverUUID) {
        String sql = "SELECT plan_geolocations.uuid,geolocation,last_used FROM plan_geolocations JOIN plan_user_info on plan_geolocations.uuid=plan_user_info.uuid WHERE server_uuid=?";
        return new QueryStatement<Map<UUID, List<GeoInfo>>>(sql, 10000){

            @Override
            public void prepare(PreparedStatement statement) throws SQLException {
                statement.setString(1, serverUUID.toString());
            }

            @Override
            public Map<UUID, List<GeoInfo>> processResults(ResultSet set) throws SQLException {
                return GeoInfoQueries.extractGeoInformation(set);
            }
        };
    }

    public static Query<Map<String, Integer>> networkGeolocationCounts() {
        String subQuery1 = "SELECT uuid, geolocation, last_used FROM plan_geolocations";
        String subQuery2 = "SELECT uuid, MAX(last_used) as m FROM plan_geolocations GROUP BY uuid";
        String sql = "SELECT geolocation, COUNT(1) as c FROM (" + subQuery1 + ") AS q1" + " JOIN " + "(" + subQuery2 + ") AS q2 ON q1.uuid = q2.uuid" + " WHERE " + "last_used" + "=m" + " GROUP BY " + "geolocation";
        return new QueryAllStatement<Map<String, Integer>>(sql){

            @Override
            public Map<String, Integer> processResults(ResultSet set) throws SQLException {
                HashMap<String, Integer> geolocationCounts = new HashMap<String, Integer>();
                while (set.next()) {
                    geolocationCounts.put(set.getString("geolocation"), set.getInt("c"));
                }
                return geolocationCounts;
            }
        };
    }

    public static Query<Map<String, Integer>> serverGeolocationCounts(final UUID serverUUID) {
        String selectGeolocations = "SELECT uuid, geolocation, last_used FROM plan_geolocations";
        String selectLatestGeolocationDate = "SELECT uuid, MAX(last_used) as m FROM plan_geolocations GROUP BY uuid";
        String sql = "SELECT geolocation, COUNT(1) as c FROM (" + selectGeolocations + ") AS q1" + " JOIN " + "(" + selectLatestGeolocationDate + ") AS q2 ON q1.uuid = q2.uuid" + " JOIN " + "plan_user_info" + " u on u." + "uuid" + "=q1.uuid" + " WHERE " + "last_used" + "=m" + " AND " + "u." + "server_uuid" + "=?" + " GROUP BY " + "geolocation";
        return new QueryStatement<Map<String, Integer>>(sql){

            @Override
            public void prepare(PreparedStatement statement) throws SQLException {
                statement.setString(1, serverUUID.toString());
            }

            @Override
            public Map<String, Integer> processResults(ResultSet set) throws SQLException {
                HashMap<String, Integer> geolocationCounts = new HashMap<String, Integer>();
                while (set.next()) {
                    geolocationCounts.put(set.getString("geolocation"), set.getInt("c"));
                }
                return geolocationCounts;
            }
        };
    }
}

