/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plan.storage.database.queries.objects;

import com.djrapitops.plan.gathering.domain.PlayerKill;
import com.djrapitops.plan.storage.database.queries.Query;
import com.djrapitops.plan.storage.database.queries.QueryStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;

public class KillQueries {
    private KillQueries() {
    }

    public static Query<List<PlayerKill>> fetchPlayerKillsOnServer(final UUID serverUUID, final int limit) {
        String sql = "SELECT victim_uuid, v.name as victim_name, k.name as killer_name,date, weapon FROM plan_kills JOIN plan_users v on v.uuid=victim_uuid JOIN plan_users k on k.uuid=killer_uuid WHERE plan_kills.server_uuid=? ORDER BY date DESC LIMIT ?";
        return new QueryStatement<List<PlayerKill>>(sql, limit){

            @Override
            public void prepare(PreparedStatement statement) throws SQLException {
                statement.setString(1, serverUUID.toString());
                statement.setInt(2, limit);
            }

            @Override
            public List<PlayerKill> processResults(ResultSet set) throws SQLException {
                ArrayList<PlayerKill> kills = new ArrayList<PlayerKill>();
                while (set.next()) {
                    KillQueries.extractKillFromResults(set).ifPresent(kills::add);
                }
                return kills;
            }
        };
    }

    public static Query<List<PlayerKill>> fetchPlayerKillsOfPlayer(final UUID playerUUID) {
        String sql = "SELECT victim_uuid, v.name as victim_name, k.name as killer_name,date, weapon FROM plan_kills JOIN plan_users v on v.uuid=victim_uuid JOIN plan_users k on k.uuid=killer_uuid WHERE plan_kills.killer_uuid=? ORDER BY date DESC";
        return new QueryStatement<List<PlayerKill>>(sql, 100){

            @Override
            public void prepare(PreparedStatement statement) throws SQLException {
                statement.setString(1, playerUUID.toString());
            }

            @Override
            public List<PlayerKill> processResults(ResultSet set) throws SQLException {
                ArrayList<PlayerKill> kills = new ArrayList<PlayerKill>();
                while (set.next()) {
                    KillQueries.extractKillFromResults(set).ifPresent(kills::add);
                }
                return kills;
            }
        };
    }

    public static Query<List<PlayerKill>> fetchPlayerDeathsOfPlayer(final UUID playerUUID) {
        String sql = "SELECT victim_uuid, v.name as victim_name, k.name as killer_name,date, weapon FROM plan_kills JOIN plan_users v on v.uuid=victim_uuid JOIN plan_users k on k.uuid=killer_uuid WHERE plan_kills.victim_uuid=? ORDER BY date DESC";
        return new QueryStatement<List<PlayerKill>>(sql, 100){

            @Override
            public void prepare(PreparedStatement statement) throws SQLException {
                statement.setString(1, playerUUID.toString());
            }

            @Override
            public List<PlayerKill> processResults(ResultSet set) throws SQLException {
                ArrayList<PlayerKill> kills = new ArrayList<PlayerKill>();
                while (set.next()) {
                    KillQueries.extractKillFromResults(set).ifPresent(kills::add);
                }
                return kills;
            }
        };
    }

    private static Optional<PlayerKill> extractKillFromResults(ResultSet set) throws SQLException {
        String victimName = set.getString("victim_name");
        String killerName = set.getString("killer_name");
        if (victimName != null && killerName != null) {
            UUID victim = UUID.fromString(set.getString("victim_uuid"));
            long date = set.getLong("date");
            String weapon = set.getString("weapon");
            return Optional.of(new PlayerKill(victim, weapon, date, victimName, killerName));
        }
        return Optional.empty();
    }

    public static Query<Long> playerKillCount(final long after, final long before, final UUID serverUUID) {
        String sql = "SELECT COUNT(1) as count FROM plan_kills WHERE server_uuid=? AND date>=? AND date<=?";
        return new QueryStatement<Long>(sql){

            @Override
            public void prepare(PreparedStatement statement) throws SQLException {
                statement.setString(1, serverUUID.toString());
                statement.setLong(2, after);
                statement.setLong(3, before);
            }

            @Override
            public Long processResults(ResultSet set) throws SQLException {
                return set.next() ? set.getLong("count") : 0L;
            }
        };
    }

    public static Query<Double> averageKDR(final long after, final long before, final UUID serverUUID) {
        String selectKillCounts = "SELECT COUNT(1) as kills,killer_uuid FROM plan_kills WHERE server_uuid=? AND date>=? AND date<=? GROUP BY killer_uuid";
        String selectDeathCounts = "SELECT COUNT(1) as deaths,victim_uuid FROM plan_kills WHERE server_uuid=? AND date>=? AND date<=? GROUP BY victim_uuid";
        String sql = "SELECT u.uuid,kills, deaths FROM plan_user_info u LEFT JOIN (" + selectKillCounts + ") q1 on q1." + "killer_uuid" + "=u." + "uuid" + " LEFT JOIN " + '(' + selectDeathCounts + ") q2 on q2." + "victim_uuid" + "=u." + "uuid" + " WHERE " + "u." + "server_uuid" + "=?";
        return new QueryStatement<Double>(sql){

            @Override
            public void prepare(PreparedStatement statement) throws SQLException {
                statement.setString(1, serverUUID.toString());
                statement.setLong(2, after);
                statement.setLong(3, before);
                statement.setString(4, serverUUID.toString());
                statement.setLong(5, after);
                statement.setLong(6, before);
                statement.setString(7, serverUUID.toString());
            }

            @Override
            public Double processResults(ResultSet set) throws SQLException {
                double totalKDR = 0.0;
                int playerCount = 0;
                while (set.next()) {
                    int kills = set.getInt("kills");
                    int deaths = set.getInt("deaths");
                    totalKDR += (double)kills / (double)(deaths > 0 ? deaths : 1);
                    ++playerCount;
                }
                return totalKDR / (double)(playerCount > 0 ? playerCount : 1);
            }
        };
    }

    public static Query<Long> mobKillCount(final long after, final long before, final UUID serverUUID) {
        String sql = "SELECT SUM(mob_kills) as count FROM plan_sessions WHERE server_uuid=? AND session_end>=? AND session_start<=?";
        return new QueryStatement<Long>(sql){

            @Override
            public void prepare(PreparedStatement statement) throws SQLException {
                statement.setString(1, serverUUID.toString());
                statement.setLong(2, after);
                statement.setLong(3, before);
            }

            @Override
            public Long processResults(ResultSet set) throws SQLException {
                return set.next() ? set.getLong("count") : 0L;
            }
        };
    }

    public static Query<Long> deathCount(final long after, final long before, final UUID serverUUID) {
        String sql = "SELECT SUM(deaths) as count FROM plan_sessions WHERE server_uuid=? AND session_end>=? AND session_start<=?";
        return new QueryStatement<Long>(sql){

            @Override
            public void prepare(PreparedStatement statement) throws SQLException {
                statement.setString(1, serverUUID.toString());
                statement.setLong(2, after);
                statement.setLong(3, before);
            }

            @Override
            public Long processResults(ResultSet set) throws SQLException {
                return set.next() ? set.getLong("count") : 0L;
            }
        };
    }

    public static Query<List<String>> topWeaponsOfServer(final long after, final long before, final UUID serverUUID, final int limit) {
        String innerSQL = "SELECT weapon, COUNT(1) as kills FROM plan_kills WHERE server_uuid=? AND date>=? AND date<=? GROUP BY weapon";
        String sql = "SELECT weapon FROM (" + innerSQL + ") q1" + " ORDER BY " + "kills DESC LIMIT ?";
        return new QueryStatement<List<String>>(sql, limit){

            @Override
            public void prepare(PreparedStatement statement) throws SQLException {
                statement.setString(1, serverUUID.toString());
                statement.setLong(2, after);
                statement.setLong(3, before);
                statement.setInt(4, limit);
            }

            @Override
            public List<String> processResults(ResultSet set) throws SQLException {
                ArrayList<String> weapons = new ArrayList<String>();
                while (set.next()) {
                    weapons.add(set.getString("weapon"));
                }
                return weapons;
            }
        };
    }

    public static Query<List<String>> topWeaponsOfPlayer(final long after, final long before, final UUID playerUUID, final int limit) {
        String innerSQL = "SELECT weapon, COUNT(1) as kills FROM plan_kills WHERE killer_uuid=? AND date>=? AND date<=? GROUP BY weapon";
        String sql = "SELECT weapon FROM (" + innerSQL + ") q1" + " ORDER BY " + "kills DESC LIMIT ?";
        return new QueryStatement<List<String>>(sql, limit){

            @Override
            public void prepare(PreparedStatement statement) throws SQLException {
                statement.setString(1, playerUUID.toString());
                statement.setLong(2, after);
                statement.setLong(3, before);
                statement.setInt(4, limit);
            }

            @Override
            public List<String> processResults(ResultSet set) throws SQLException {
                ArrayList<String> weapons = new ArrayList<String>();
                while (set.next()) {
                    weapons.add(set.getString("weapon"));
                }
                return weapons;
            }
        };
    }
}

