/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plan.storage.database.queries.objects;

import com.djrapitops.plan.delivery.domain.TablePlayer;
import com.djrapitops.plan.delivery.domain.mutators.ActivityIndex;
import com.djrapitops.plan.storage.database.SQLDB;
import com.djrapitops.plan.storage.database.queries.Query;
import com.djrapitops.plan.storage.database.queries.QueryStatement;
import com.djrapitops.plan.storage.database.queries.analysis.NetworkActivityIndexQueries;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;

public class NetworkTablePlayersQuery
implements Query<List<TablePlayer>> {
    private final long date;
    private final long activeMsThreshold;
    private final int xMostRecentPlayers;

    public NetworkTablePlayersQuery(long date, long activeMsThreshold, int xMostRecentPlayers) {
        this.date = date;
        this.activeMsThreshold = activeMsThreshold;
        this.xMostRecentPlayers = xMostRecentPlayers;
    }

    @Override
    public List<TablePlayer> executeQuery(SQLDB db) {
        String selectGeolocations = "SELECT DISTINCT uuid, geolocation, last_used FROM plan_geolocations";
        String selectLatestGeolocationDate = "SELECT uuid, MAX(last_used) as last_used_g FROM plan_geolocations GROUP BY uuid";
        String selectLatestGeolocations = "SELECT g1.geolocation,g1.uuid FROM (" + selectGeolocations + ") AS g1" + " JOIN " + "(" + selectLatestGeolocationDate + ") AS g2 ON g1.uuid = g2.uuid" + " WHERE " + "last_used" + "=last_used_g";
        String selectSessionData = "SELECT s.uuid,MAX(session_end) as last_seen,COUNT(1) as count,SUM(session_end-session_start) as playtime FROM plan_sessions s GROUP BY s.uuid";
        String selectBanned = "SELECT DISTINCT ub.uuid FROM plan_user_info ub WHERE banned=?";
        String selectBaseUsers = "SELECT u.uuid,u.name,u.registered,ban.uuid as banned,geoloc.geolocation,ses.last_seen,ses.count,ses.playtime,act.activity_index FROM plan_users u LEFT JOIN (" + selectBanned + ") ban on ban." + "uuid" + "=u." + "uuid" + " LEFT JOIN " + '(' + selectLatestGeolocations + ") geoloc on geoloc." + "uuid" + "=u." + "uuid" + " LEFT JOIN " + '(' + selectSessionData + ") ses on ses." + "uuid" + "=u." + "uuid" + " LEFT JOIN " + '(' + NetworkActivityIndexQueries.selectActivityIndexSQL() + ") act on u." + "uuid" + "=act." + "uuid" + " ORDER BY " + "ses.last_seen DESC LIMIT ?";
        return db.query(new QueryStatement<List<TablePlayer>>(selectBaseUsers, 1000){

            @Override
            public void prepare(PreparedStatement statement) throws SQLException {
                statement.setBoolean(1, true);
                NetworkActivityIndexQueries.setSelectActivityIndexSQLParameters(statement, 2, NetworkTablePlayersQuery.this.activeMsThreshold, NetworkTablePlayersQuery.this.date);
                statement.setInt(10, NetworkTablePlayersQuery.this.xMostRecentPlayers);
            }

            @Override
            public List<TablePlayer> processResults(ResultSet set) throws SQLException {
                ArrayList<TablePlayer> players = new ArrayList<TablePlayer>();
                while (set.next()) {
                    TablePlayer.Builder player = TablePlayer.builder().uuid(UUID.fromString(set.getString("uuid"))).name(set.getString("name")).geolocation(set.getString("geolocation")).registered(set.getLong("registered")).lastSeen(set.getLong("last_seen")).sessionCount(set.getInt("count")).playtime(set.getLong("playtime")).activityIndex(new ActivityIndex(set.getDouble("activity_index"), NetworkTablePlayersQuery.this.date));
                    if (set.getString("banned") != null) {
                        player.banned();
                    }
                    players.add(player.build());
                }
                return players;
            }
        });
    }
}

