/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plan.storage.database.queries.objects;

import com.djrapitops.plan.settings.config.Config;
import com.djrapitops.plan.settings.config.ConfigReader;
import com.djrapitops.plan.storage.database.queries.QueryStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Optional;
import java.util.Scanner;
import java.util.UUID;

public class NewerConfigQuery
extends QueryStatement<Optional<Config>> {
    private static final String SELECT_STATEMENT = "SELECT content FROM plan_settings WHERE updated>? AND server_uuid=? LIMIT 1";
    private final UUID serverUUID;
    private final long updatedAfter;

    public NewerConfigQuery(UUID serverUUID, long updatedAfter) {
        super(SELECT_STATEMENT);
        this.serverUUID = serverUUID;
        this.updatedAfter = updatedAfter;
    }

    @Override
    public void prepare(PreparedStatement statement) throws SQLException {
        statement.setLong(1, this.updatedAfter);
        statement.setString(2, this.serverUUID.toString());
    }

    @Override
    public Optional<Config> processResults(ResultSet set) throws SQLException {
        if (set.next()) {
            try (ConfigReader reader = new ConfigReader(new Scanner(set.getString("content")));){
                Optional<Config> optional = Optional.of(reader.read());
                return optional;
            }
        }
        return Optional.empty();
    }
}

