/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plan.storage.database.queries.objects;

import com.djrapitops.plan.delivery.domain.Nickname;
import com.djrapitops.plan.storage.database.queries.Query;
import com.djrapitops.plan.storage.database.queries.QueryAllStatement;
import com.djrapitops.plan.storage.database.queries.QueryStatement;
import com.djrapitops.plan.utilities.java.Lists;
import com.djrapitops.plan.utilities.java.Maps;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;

public class NicknameQueries {
    private NicknameQueries() {
    }

    public static Query<Map<UUID, Map<UUID, List<Nickname>>>> fetchAllNicknameData() {
        String sql = "SELECT nickname,last_used,uuid,server_uuid FROM plan_nicknames";
        return new QueryAllStatement<Map<UUID, Map<UUID, List<Nickname>>>>(sql, 5000){

            @Override
            public Map<UUID, Map<UUID, List<Nickname>>> processResults(ResultSet set) throws SQLException {
                HashMap<UUID, Map<UUID, List<Nickname>>> map = new HashMap<UUID, Map<UUID, List<Nickname>>>();
                while (set.next()) {
                    UUID serverUUID = UUID.fromString(set.getString("server_uuid"));
                    UUID uuid = UUID.fromString(set.getString("uuid"));
                    Map serverMap = map.computeIfAbsent(serverUUID, Maps::create);
                    List nicknames = serverMap.computeIfAbsent(uuid, Lists::create);
                    nicknames.add(new Nickname(set.getString("nickname"), set.getLong("last_used"), serverUUID));
                }
                return map;
            }
        };
    }

    public static Query<Optional<Nickname>> fetchLastSeenNicknameOfPlayer(final UUID playerUUID, final UUID serverUUID) {
        String subQuery = "SELECT MAX(last_used) FROM plan_nicknames WHERE uuid=? AND server_uuid=? GROUP BY uuid";
        String sql = "SELECT last_used,nickname FROM plan_nicknames WHERE uuid=? AND server_uuid=? AND last_used=(" + subQuery + ')';
        return new QueryStatement<Optional<Nickname>>(sql){

            @Override
            public void prepare(PreparedStatement statement) throws SQLException {
                statement.setString(1, playerUUID.toString());
                statement.setString(2, serverUUID.toString());
                statement.setString(3, playerUUID.toString());
                statement.setString(4, serverUUID.toString());
            }

            @Override
            public Optional<Nickname> processResults(ResultSet set) throws SQLException {
                if (set.next()) {
                    return Optional.of(new Nickname(set.getString("nickname"), set.getLong("last_used"), serverUUID));
                }
                return Optional.empty();
            }
        };
    }

    public static Query<List<Nickname>> fetchNicknameDataOfPlayer(final UUID playerUUID) {
        String sql = "SELECT nickname,last_used,server_uuid FROM plan_nicknames WHERE uuid=?";
        return new QueryStatement<List<Nickname>>(sql, 5000){

            @Override
            public void prepare(PreparedStatement statement) throws SQLException {
                statement.setString(1, playerUUID.toString());
            }

            @Override
            public List<Nickname> processResults(ResultSet set) throws SQLException {
                ArrayList<Nickname> nicknames = new ArrayList<Nickname>();
                while (set.next()) {
                    UUID serverUUID = UUID.fromString(set.getString("server_uuid"));
                    String nickname = set.getString("nickname");
                    nicknames.add(new Nickname(nickname, set.getLong("last_used"), serverUUID));
                }
                return nicknames;
            }
        };
    }

    public static Query<Map<UUID, List<Nickname>>> fetchNicknameDataOfServer(final UUID serverUUID) {
        String sql = "SELECT nickname,last_used,uuid,server_uuid FROM plan_nicknames WHERE server_uuid=?";
        return new QueryStatement<Map<UUID, List<Nickname>>>(sql, 5000){

            @Override
            public void prepare(PreparedStatement statement) throws SQLException {
                statement.setString(1, serverUUID.toString());
            }

            @Override
            public Map<UUID, List<Nickname>> processResults(ResultSet set) throws SQLException {
                HashMap<UUID, List<Nickname>> serverMap = new HashMap<UUID, List<Nickname>>();
                while (set.next()) {
                    UUID serverUUID2 = UUID.fromString(set.getString("server_uuid"));
                    UUID uuid = UUID.fromString(set.getString("uuid"));
                    List nicknames = serverMap.computeIfAbsent(uuid, Lists::create);
                    nicknames.add(new Nickname(set.getString("nickname"), set.getLong("last_used"), serverUUID2));
                }
                return serverMap;
            }
        };
    }
}

