/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plan.storage.database.queries.objects;

import com.djrapitops.plan.gathering.domain.Ping;
import com.djrapitops.plan.storage.database.queries.Query;
import com.djrapitops.plan.storage.database.queries.QueryAllStatement;
import com.djrapitops.plan.storage.database.queries.QueryStatement;
import com.djrapitops.plan.utilities.java.Lists;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.UUID;

public class PingQueries {
    private PingQueries() {
    }

    public static Query<Map<UUID, List<Ping>>> fetchAllPingData() {
        String sql = "SELECT date,max_ping,min_ping,avg_ping,uuid,server_uuid FROM plan_ping";
        return new QueryAllStatement<Map<UUID, List<Ping>>>(sql, 100000){

            @Override
            public Map<UUID, List<Ping>> processResults(ResultSet set) throws SQLException {
                return PingQueries.extractUserPings(set);
            }
        };
    }

    private static Map<UUID, List<Ping>> extractUserPings(ResultSet set) throws SQLException {
        HashMap<UUID, List<Ping>> userPings = new HashMap<UUID, List<Ping>>();
        while (set.next()) {
            UUID uuid = UUID.fromString(set.getString("uuid"));
            UUID serverUUID = UUID.fromString(set.getString("server_uuid"));
            long date = set.getLong("date");
            double avgPing = set.getDouble("avg_ping");
            int minPing = set.getInt("min_ping");
            int maxPing = set.getInt("max_ping");
            List pings = userPings.computeIfAbsent(uuid, Lists::create);
            pings.add(new Ping(date, serverUUID, minPing, maxPing, avgPing));
        }
        return userPings;
    }

    public static Query<List<Ping>> fetchPingDataOfPlayer(final UUID playerUUID) {
        String sql = "SELECT * FROM plan_ping WHERE uuid=?";
        return new QueryStatement<List<Ping>>(sql, 10000){

            @Override
            public void prepare(PreparedStatement statement) throws SQLException {
                statement.setString(1, playerUUID.toString());
            }

            @Override
            public List<Ping> processResults(ResultSet set) throws SQLException {
                ArrayList<Ping> pings = new ArrayList<Ping>();
                while (set.next()) {
                    pings.add(new Ping(set.getLong("date"), UUID.fromString(set.getString("server_uuid")), set.getInt("min_ping"), set.getInt("max_ping"), set.getDouble("avg_ping")));
                }
                return pings;
            }
        };
    }

    public static Query<Map<UUID, List<Ping>>> fetchPingDataOfServer(final UUID serverUUID) {
        String sql = "SELECT date,max_ping,min_ping,avg_ping,uuid,server_uuid FROM plan_ping WHERE server_uuid=?";
        return new QueryStatement<Map<UUID, List<Ping>>>(sql, 100000){

            @Override
            public void prepare(PreparedStatement statement) throws SQLException {
                statement.setString(1, serverUUID.toString());
            }

            @Override
            public Map<UUID, List<Ping>> processResults(ResultSet set) throws SQLException {
                return PingQueries.extractUserPings(set);
            }
        };
    }

    public static Query<List<Ping>> fetchPingDataOfServer(final long after, final long before, final UUID serverUUID) {
        String sql = "SELECT date, max_ping, min_ping, avg_ping, server_uuid FROM plan_ping WHERE server_uuid=? AND date>=? AND date<=?";
        return new QueryStatement<List<Ping>>(sql, 1000){

            @Override
            public void prepare(PreparedStatement statement) throws SQLException {
                statement.setString(1, serverUUID.toString());
                statement.setLong(2, after);
                statement.setLong(3, before);
            }

            @Override
            public List<Ping> processResults(ResultSet set) throws SQLException {
                ArrayList<Ping> pings = new ArrayList<Ping>();
                while (set.next()) {
                    UUID serverUUID2 = UUID.fromString(set.getString("server_uuid"));
                    long date = set.getLong("date");
                    double avgPing = set.getDouble("avg_ping");
                    int minPing = set.getInt("min_ping");
                    int maxPing = set.getInt("max_ping");
                    pings.add(new Ping(date, serverUUID2, minPing, maxPing, avgPing));
                }
                return pings;
            }
        };
    }

    public static Query<Map<String, Ping>> fetchPingDataOfServerByGeolocation(final UUID serverUUID) {
        String selectPingOfServer = "SELECT max_ping, min_ping, avg_ping, uuid, server_uuid FROM plan_ping";
        String selectGeolocations = "SELECT uuid, geolocation, last_used FROM plan_geolocations";
        String selectLatestGeolocationDate = "SELECT uuid, MAX(last_used) as m FROM plan_geolocations GROUP BY uuid";
        String selectPingByGeolocation = "SELECT geolocation, MIN(min_ping) as minPing, MAX(max_ping) as maxPing, AVG(avg_ping) as avgPing FROM (" + selectGeolocations + ") AS q1" + " JOIN " + "(" + selectLatestGeolocationDate + ") AS q2 ON q1.uuid = q2.uuid" + " JOIN " + '(' + selectPingOfServer + ") sp on sp." + "uuid" + "=q1.uuid" + " WHERE " + "last_used" + "=m" + " AND " + "sp." + "server_uuid" + "=?" + " GROUP BY " + "geolocation";
        return new QueryStatement<Map<String, Ping>>(selectPingByGeolocation){

            @Override
            public void prepare(PreparedStatement statement) throws SQLException {
                statement.setString(1, serverUUID.toString());
            }

            @Override
            public Map<String, Ping> processResults(ResultSet set) throws SQLException {
                TreeMap<String, Ping> pingByGeolocation = new TreeMap<String, Ping>();
                while (set.next()) {
                    Ping ping = new Ping(0L, serverUUID, set.getInt("minPing"), set.getInt("maxPing"), (int)set.getDouble("avgPing"));
                    pingByGeolocation.put(set.getString("geolocation"), ping);
                }
                return pingByGeolocation;
            }
        };
    }

    public static Query<Map<String, Ping>> fetchPingDataOfNetworkByGeolocation() {
        String selectPingOfServer = "SELECT max_ping, min_ping, avg_ping, uuid, server_uuid FROM plan_ping";
        String selectGeolocations = "SELECT uuid, geolocation, last_used FROM plan_geolocations";
        String selectLatestGeolocationDate = "SELECT uuid, MAX(last_used) as m FROM plan_geolocations GROUP BY uuid";
        String selectPingByGeolocation = "SELECT geolocation, MIN(min_ping) as minPing, MAX(max_ping) as maxPing, AVG(avg_ping) as avgPing FROM ((" + selectGeolocations + ") AS q1" + " JOIN " + "(" + selectLatestGeolocationDate + ") AS q2 ON q1.uuid = q2.uuid" + " JOIN " + '(' + selectPingOfServer + ") sp on sp." + "uuid" + "=q1.uuid)" + " WHERE " + "last_used" + "=m" + " GROUP BY " + "geolocation";
        return new QueryAllStatement<Map<String, Ping>>(selectPingByGeolocation){

            @Override
            public Map<String, Ping> processResults(ResultSet set) throws SQLException {
                TreeMap<String, Ping> pingByGeolocation = new TreeMap<String, Ping>();
                while (set.next()) {
                    Ping ping = new Ping(0L, null, set.getInt("minPing"), set.getInt("maxPing"), (int)set.getDouble("avgPing"));
                    pingByGeolocation.put(set.getString("geolocation"), ping);
                }
                return pingByGeolocation;
            }
        };
    }

    public static Query<Double> averagePing(final long after, final long before, final UUID serverUUID) {
        String sql = "SELECT AVG(avg_ping) as average FROM plan_ping WHERE server_uuid=? AND date>=? AND date<=?";
        return new QueryStatement<Double>(sql, 1000){

            @Override
            public void prepare(PreparedStatement statement) throws SQLException {
                statement.setString(1, serverUUID.toString());
                statement.setLong(2, after);
                statement.setLong(3, before);
            }

            @Override
            public Double processResults(ResultSet set) throws SQLException {
                return set.next() ? set.getDouble("average") : -1.0;
            }
        };
    }
}

