/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plan.storage.database.queries.objects;

import com.djrapitops.plan.identification.Server;
import com.djrapitops.plan.storage.database.queries.Query;
import com.djrapitops.plan.storage.database.queries.QueryAllStatement;
import com.djrapitops.plan.storage.database.queries.QueryStatement;
import com.djrapitops.plan.storage.database.sql.building.Select;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import plan.org.apache.commons.lang3.math.NumberUtils;

public class ServerQueries {
    private ServerQueries() {
    }

    public static Query<Map<UUID, Server>> fetchPlanServerInformation() {
        String sql = "SELECT * FROM plan_servers WHERE is_installed=?";
        return new QueryStatement<Map<UUID, Server>>(sql, 100){

            @Override
            public void prepare(PreparedStatement statement) throws SQLException {
                statement.setBoolean(1, true);
            }

            @Override
            public Map<UUID, Server> processResults(ResultSet set) throws SQLException {
                HashMap<UUID, Server> servers = new HashMap<UUID, Server>();
                while (set.next()) {
                    UUID serverUUID = UUID.fromString(set.getString("uuid"));
                    servers.put(serverUUID, new Server(set.getInt("id"), serverUUID, set.getString("name"), set.getString("web_address"), set.getInt("max_players")));
                }
                return servers;
            }
        };
    }

    public static Query<Collection<Server>> fetchPlanServerInformationCollection() {
        return db -> db.query(ServerQueries.fetchPlanServerInformation()).values();
    }

    public static Query<Optional<Server>> fetchServerMatchingIdentifier(UUID serverUUID) {
        return ServerQueries.fetchServerMatchingIdentifier(serverUUID.toString());
    }

    public static Query<Optional<Server>> fetchServerMatchingIdentifier(final String identifier) {
        String sql = "SELECT * FROM plan_servers WHERE (LOWER(uuid) LIKE LOWER(?) OR LOWER(name) LIKE LOWER(?) OR id=? OR id=?) AND is_installed=? LIMIT 1";
        return new QueryStatement<Optional<Server>>(sql){

            @Override
            public void prepare(PreparedStatement statement) throws SQLException {
                statement.setString(1, identifier);
                statement.setString(2, identifier);
                statement.setInt(3, NumberUtils.isParsable(identifier) ? Integer.parseInt(identifier) : -1);
                String id = identifier.startsWith("Server ") ? identifier.substring(7) : identifier;
                statement.setInt(4, NumberUtils.isParsable(id) ? Integer.parseInt(id) : -1);
                statement.setBoolean(5, true);
            }

            @Override
            public Optional<Server> processResults(ResultSet set) throws SQLException {
                if (set.next()) {
                    return Optional.of(new Server(set.getInt("id"), UUID.fromString(set.getString("uuid")), set.getString("name"), set.getString("web_address"), set.getInt("max_players")));
                }
                return Optional.empty();
            }
        };
    }

    public static Query<Optional<Server>> fetchProxyServerInformation() {
        return db -> db.query(ServerQueries.fetchServerMatchingIdentifier("BungeeCord"));
    }

    public static Query<Map<UUID, String>> fetchServerNames() {
        String sql = Select.from("plan_servers", "uuid", "name").toString();
        return new QueryAllStatement<Map<UUID, String>>(sql){

            @Override
            public Map<UUID, String> processResults(ResultSet set) throws SQLException {
                HashMap<UUID, String> names = new HashMap<UUID, String>();
                while (set.next()) {
                    UUID serverUUID = UUID.fromString(set.getString("uuid"));
                    names.put(serverUUID, set.getString("name"));
                }
                return names;
            }
        };
    }
}

