/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plan.storage.database.queries.objects;

import com.djrapitops.plan.delivery.domain.TablePlayer;
import com.djrapitops.plan.delivery.domain.mutators.ActivityIndex;
import com.djrapitops.plan.storage.database.SQLDB;
import com.djrapitops.plan.storage.database.queries.Query;
import com.djrapitops.plan.storage.database.queries.QueryStatement;
import com.djrapitops.plan.storage.database.queries.analysis.ActivityIndexQueries;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;

public class ServerTablePlayersQuery
implements Query<List<TablePlayer>> {
    private final UUID serverUUID;
    private final long date;
    private final long activeMsThreshold;
    private final int xMostRecentPlayers;

    public ServerTablePlayersQuery(UUID serverUUID, long date, long activeMsThreshold, int xMostRecentPlayers) {
        this.serverUUID = serverUUID;
        this.date = date;
        this.activeMsThreshold = activeMsThreshold;
        this.xMostRecentPlayers = xMostRecentPlayers;
    }

    @Override
    public List<TablePlayer> executeQuery(SQLDB db) {
        String selectGeolocations = "SELECT DISTINCT uuid, geolocation, last_used FROM plan_geolocations";
        String selectLatestGeolocationDate = "SELECT uuid, MAX(last_used) as last_used_g FROM plan_geolocations GROUP BY uuid";
        String selectLatestGeolocations = "SELECT g1.geolocation,g1.uuid FROM (" + selectGeolocations + ") AS g1" + " JOIN " + "(" + selectLatestGeolocationDate + ") AS g2 ON g1.uuid = g2.uuid" + " WHERE " + "last_used" + "=last_used_g";
        String selectSessionData = "SELECT s.uuid,MAX(session_end) as last_seen,COUNT(1) as count,SUM(session_end-session_start) as playtime FROM plan_sessions s WHERE s.server_uuid=? GROUP BY s.uuid";
        String selectBaseUsers = "SELECT u.uuid,u.name,u.registered,banned,geoloc.geolocation,ses.last_seen,ses.count,ses.playtime,act.activity_index FROM plan_users u JOIN plan_user_info on u.uuid=plan_user_info.uuid LEFT JOIN (" + selectLatestGeolocations + ") geoloc on geoloc." + "uuid" + "=u." + "uuid" + " LEFT JOIN " + '(' + selectSessionData + ") ses on ses." + "uuid" + "=u." + "uuid" + " LEFT JOIN " + '(' + ActivityIndexQueries.selectActivityIndexSQL() + ") act on u." + "uuid" + "=act." + "uuid" + " WHERE " + "server_uuid" + "=?" + " ORDER BY " + "ses.last_seen DESC LIMIT ?";
        return db.query(new QueryStatement<List<TablePlayer>>(selectBaseUsers, 1000){

            @Override
            public void prepare(PreparedStatement statement) throws SQLException {
                statement.setString(1, ServerTablePlayersQuery.this.serverUUID.toString());
                ActivityIndexQueries.setSelectActivityIndexSQLParameters(statement, 2, ServerTablePlayersQuery.this.activeMsThreshold, ServerTablePlayersQuery.this.serverUUID, ServerTablePlayersQuery.this.date);
                statement.setString(13, ServerTablePlayersQuery.this.serverUUID.toString());
                statement.setInt(14, ServerTablePlayersQuery.this.xMostRecentPlayers);
            }

            @Override
            public List<TablePlayer> processResults(ResultSet set) throws SQLException {
                ArrayList<TablePlayer> players = new ArrayList<TablePlayer>();
                while (set.next()) {
                    TablePlayer.Builder player = TablePlayer.builder().uuid(UUID.fromString(set.getString("uuid"))).name(set.getString("name")).geolocation(set.getString("geolocation")).registered(set.getLong("registered")).lastSeen(set.getLong("last_seen")).sessionCount(set.getInt("count")).playtime(set.getLong("playtime")).activityIndex(new ActivityIndex(set.getDouble("activity_index"), ServerTablePlayersQuery.this.date));
                    if (set.getBoolean("banned")) {
                        player.banned();
                    }
                    players.add(player.build());
                }
                return players;
            }
        });
    }
}

