/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plan.storage.database.queries.objects;

import com.djrapitops.plan.delivery.domain.keys.SessionKeys;
import com.djrapitops.plan.delivery.domain.mutators.SessionsMutator;
import com.djrapitops.plan.gathering.domain.GMTimes;
import com.djrapitops.plan.gathering.domain.PlayerKill;
import com.djrapitops.plan.gathering.domain.Session;
import com.djrapitops.plan.gathering.domain.WorldTimes;
import com.djrapitops.plan.storage.database.queries.Query;
import com.djrapitops.plan.storage.database.queries.QueryAllStatement;
import com.djrapitops.plan.storage.database.queries.QueryStatement;
import com.djrapitops.plan.storage.database.sql.building.Sql;
import com.djrapitops.plan.utilities.comparators.DateHolderRecentComparator;
import com.djrapitops.plan.utilities.java.Maps;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.UUID;
import java.util.stream.Collectors;

public class SessionQueries {
    private static final String SELECT_SESSIONS_STATEMENT = "SELECT s.id,s.uuid,s.server_uuid,u.name as name,u_info.registered as registered,server.name as server_name,session_start,session_end,mob_kills,deaths,afk_time,survival_time,creative_time,adventure_time,spectator_time,world_name,victim_uuid,v.name as victim_name, date,weapon FROM plan_sessions s JOIN plan_users u on u.uuid=s.uuid JOIN plan_servers server on server.uuid=s.server_uuid LEFT JOIN plan_user_info u_info on (u_info.uuid=s.uuid AND u_info.server_uuid=s.server_uuid) LEFT JOIN plan_kills ON s.id=plan_kills.session_id LEFT JOIN plan_users v on v.uuid=victim_uuid JOIN plan_world_times ON s.id=plan_world_times.session_id JOIN plan_worlds ON plan_world_times.world_id=plan_worlds.id";
    private static final String ORDER_BY_SESSION_START_DESC = " ORDER BY session_start DESC";

    private SessionQueries() {
    }

    public static Query<List<Session>> fetchAllSessions() {
        String sql = "SELECT s.id,s.uuid,s.server_uuid,u.name as name,u_info.registered as registered,server.name as server_name,session_start,session_end,mob_kills,deaths,afk_time,survival_time,creative_time,adventure_time,spectator_time,world_name,victim_uuid,v.name as victim_name, date,weapon FROM plan_sessions s JOIN plan_users u on u.uuid=s.uuid JOIN plan_servers server on server.uuid=s.server_uuid LEFT JOIN plan_user_info u_info on (u_info.uuid=s.uuid AND u_info.server_uuid=s.server_uuid) LEFT JOIN plan_kills ON s.id=plan_kills.session_id LEFT JOIN plan_users v on v.uuid=victim_uuid JOIN plan_world_times ON s.id=plan_world_times.session_id JOIN plan_worlds ON plan_world_times.world_id=plan_worlds.id ORDER BY session_start DESC";
        return new QueryAllStatement<List<Session>>(sql, 50000){

            @Override
            public List<Session> processResults(ResultSet set) throws SQLException {
                return SessionQueries.extractDataFromSessionSelectStatement(set);
            }
        };
    }

    public static Query<Map<UUID, List<Session>>> fetchSessionsOfServer(UUID serverUUID) {
        return db -> SessionsMutator.sortByPlayers(db.query(SessionQueries.fetchSessionsOfServerFlat(serverUUID)));
    }

    public static QueryStatement<List<Session>> fetchSessionsOfServerFlat(final UUID serverUUID) {
        String sql = "SELECT s.id,s.uuid,s.server_uuid,u.name as name,u_info.registered as registered,server.name as server_name,session_start,session_end,mob_kills,deaths,afk_time,survival_time,creative_time,adventure_time,spectator_time,world_name,victim_uuid,v.name as victim_name, date,weapon FROM plan_sessions s JOIN plan_users u on u.uuid=s.uuid JOIN plan_servers server on server.uuid=s.server_uuid LEFT JOIN plan_user_info u_info on (u_info.uuid=s.uuid AND u_info.server_uuid=s.server_uuid) LEFT JOIN plan_kills ON s.id=plan_kills.session_id LEFT JOIN plan_users v on v.uuid=victim_uuid JOIN plan_world_times ON s.id=plan_world_times.session_id JOIN plan_worlds ON plan_world_times.world_id=plan_worlds.id WHERE s.server_uuid=? ORDER BY session_start DESC";
        return new QueryStatement<List<Session>>(sql, 50000){

            @Override
            public void prepare(PreparedStatement statement) throws SQLException {
                statement.setString(1, serverUUID.toString());
            }

            @Override
            public List<Session> processResults(ResultSet set) throws SQLException {
                return SessionQueries.extractDataFromSessionSelectStatement(set);
            }
        };
    }

    public static Query<Map<UUID, List<Session>>> fetchSessionsOfPlayer(final UUID playerUUID) {
        String sql = "SELECT s.id,s.uuid,s.server_uuid,u.name as name,u_info.registered as registered,server.name as server_name,session_start,session_end,mob_kills,deaths,afk_time,survival_time,creative_time,adventure_time,spectator_time,world_name,victim_uuid,v.name as victim_name, date,weapon FROM plan_sessions s JOIN plan_users u on u.uuid=s.uuid JOIN plan_servers server on server.uuid=s.server_uuid LEFT JOIN plan_user_info u_info on (u_info.uuid=s.uuid AND u_info.server_uuid=s.server_uuid) LEFT JOIN plan_kills ON s.id=plan_kills.session_id LEFT JOIN plan_users v on v.uuid=victim_uuid JOIN plan_world_times ON s.id=plan_world_times.session_id JOIN plan_worlds ON plan_world_times.world_id=plan_worlds.id WHERE s.uuid=? ORDER BY session_start DESC";
        return new QueryStatement<Map<UUID, List<Session>>>(sql, 50000){

            @Override
            public void prepare(PreparedStatement statement) throws SQLException {
                statement.setString(1, playerUUID.toString());
            }

            @Override
            public Map<UUID, List<Session>> processResults(ResultSet set) throws SQLException {
                List sessions = SessionQueries.extractDataFromSessionSelectStatement(set);
                return SessionsMutator.sortByServers(sessions);
            }
        };
    }

    private static List<Session> extractDataFromSessionSelectStatement(ResultSet set) throws SQLException {
        HashMap<UUID, Map> tempSessionMap = new HashMap<UUID, Map>();
        String[] gms = GMTimes.getGMKeyArray();
        DateHolderRecentComparator mostRecentFirst = new DateHolderRecentComparator();
        Comparator longRecentComparator = (one, two) -> Long.compare(two, one);
        while (set.next()) {
            String victimName;
            String worldName;
            long sessionStart;
            UUID playerUUID;
            UUID serverUUID = UUID.fromString(set.getString("server_uuid"));
            Map serverSessions = tempSessionMap.computeIfAbsent(serverUUID, Maps::create);
            SortedMap playerSessions = serverSessions.computeIfAbsent(playerUUID = UUID.fromString(set.getString("uuid")), key -> new TreeMap(longRecentComparator));
            Session session = playerSessions.getOrDefault(sessionStart = set.getLong("session_start"), new Session(set.getInt("id"), playerUUID, serverUUID, sessionStart, set.getLong("session_end"), set.getInt("mob_kills"), set.getInt("deaths"), set.getLong("afk_time")));
            WorldTimes worldTimes = session.getValue(SessionKeys.WORLD_TIMES).orElse(new WorldTimes());
            if (!worldTimes.contains(worldName = set.getString("world_name"))) {
                HashMap<String, Long> gmMap = new HashMap<String, Long>();
                gmMap.put(gms[0], set.getLong("survival_time"));
                gmMap.put(gms[1], set.getLong("creative_time"));
                gmMap.put(gms[2], set.getLong("adventure_time"));
                gmMap.put(gms[3], set.getLong("spectator_time"));
                GMTimes gmTimes = new GMTimes(gmMap);
                worldTimes.setGMTimesForWorld(worldName, gmTimes);
            }
            if ((victimName = set.getString("victim_name")) != null) {
                PlayerKill newKill;
                UUID victim = UUID.fromString(set.getString("victim_uuid"));
                long date = set.getLong("date");
                String weapon = set.getString("weapon");
                List<PlayerKill> playerKills = session.getPlayerKills();
                if (!playerKills.contains(newKill = new PlayerKill(victim, weapon, date, victimName))) {
                    playerKills.add(newKill);
                }
            }
            session.putRawData(SessionKeys.NAME, set.getString("name"));
            session.putRawData(SessionKeys.SERVER_NAME, set.getString("server_name"));
            session.setAsFirstSessionIfMatches(set.getLong("registered"));
            playerSessions.put(sessionStart, session);
        }
        return tempSessionMap.values().stream().map(Map::values).flatMap(Collection::stream).map(SortedMap::values).flatMap(Collection::stream).sorted(mostRecentFirst).collect(Collectors.toList());
    }

    public static Query<List<Session>> fetchServerSessionsWithoutKillOrWorldData(final long after, final long before, final UUID serverUUID) {
        String sql = "SELECT id,uuid,session_start,session_end,deaths,mob_kills,afk_time FROM plan_sessions WHERE server_uuid=? AND session_start>=? AND session_start<=?";
        return new QueryStatement<List<Session>>(sql, 1000){

            @Override
            public void prepare(PreparedStatement statement) throws SQLException {
                statement.setString(1, serverUUID.toString());
                statement.setLong(2, after);
                statement.setLong(3, before);
            }

            @Override
            public List<Session> processResults(ResultSet set) throws SQLException {
                ArrayList<Session> sessions = new ArrayList<Session>();
                while (set.next()) {
                    UUID uuid = UUID.fromString(set.getString("uuid"));
                    long start = set.getLong("session_start");
                    long end = set.getLong("session_end");
                    int deaths = set.getInt("deaths");
                    int mobKills = set.getInt("mob_kills");
                    int id = set.getInt("id");
                    long timeAFK = set.getLong("afk_time");
                    sessions.add(new Session(id, uuid, serverUUID, start, end, mobKills, deaths, timeAFK));
                }
                return sessions;
            }
        };
    }

    private static Query<Long> fetchLatestSessionStartLimitForServer(final UUID serverUUID, final int limit) {
        String sql = "SELECT session_start FROM plan_sessions WHERE server_uuid=? ORDER BY session_start DESC LIMIT ?";
        return new QueryStatement<Long>(sql, limit){

            @Override
            public void prepare(PreparedStatement statement) throws SQLException {
                statement.setString(1, serverUUID.toString());
                statement.setInt(2, limit);
            }

            @Override
            public Long processResults(ResultSet set) throws SQLException {
                Long last = null;
                while (set.next()) {
                    last = set.getLong("session_start");
                }
                return last;
            }
        };
    }

    private static Query<Long> fetchLatestSessionStartLimit(final int limit) {
        String sql = "SELECT session_start FROM plan_sessions ORDER BY session_start DESC LIMIT ?";
        return new QueryStatement<Long>(sql, limit){

            @Override
            public void prepare(PreparedStatement statement) throws SQLException {
                statement.setInt(1, limit);
            }

            @Override
            public Long processResults(ResultSet set) throws SQLException {
                Long last = null;
                while (set.next()) {
                    last = set.getLong("session_start");
                }
                return last;
            }
        };
    }

    public static Query<List<Session>> fetchLatestSessionsOfServer(final UUID serverUUID, int limit) {
        String sql = "SELECT s.id,s.uuid,s.server_uuid,u.name as name,u_info.registered as registered,server.name as server_name,session_start,session_end,mob_kills,deaths,afk_time,survival_time,creative_time,adventure_time,spectator_time,world_name,victim_uuid,v.name as victim_name, date,weapon FROM plan_sessions s JOIN plan_users u on u.uuid=s.uuid JOIN plan_servers server on server.uuid=s.server_uuid LEFT JOIN plan_user_info u_info on (u_info.uuid=s.uuid AND u_info.server_uuid=s.server_uuid) LEFT JOIN plan_kills ON s.id=plan_kills.session_id LEFT JOIN plan_users v on v.uuid=victim_uuid JOIN plan_world_times ON s.id=plan_world_times.session_id JOIN plan_worlds ON plan_world_times.world_id=plan_worlds.id WHERE s.server_uuid=? AND s.session_start>=? ORDER BY session_start DESC";
        return db -> {
            final Long start = db.query(SessionQueries.fetchLatestSessionStartLimitForServer(serverUUID, limit));
            return db.query(new QueryStatement<List<Session>>(sql){

                @Override
                public void prepare(PreparedStatement statement) throws SQLException {
                    statement.setString(1, serverUUID.toString());
                    statement.setLong(2, start != null ? start : 0L);
                }

                @Override
                public List<Session> processResults(ResultSet set) throws SQLException {
                    return SessionQueries.extractDataFromSessionSelectStatement(set);
                }
            });
        };
    }

    public static Query<List<Session>> fetchLatestSessions(int limit) {
        String sql = SELECT_SESSIONS_STATEMENT.replace(" LEFT JOIN plan_user_info u_info on (u_info.uuid=s.uuid AND u_info.server_uuid=s.server_uuid)", "").replace("u_info", "u") + " WHERE " + "s." + "session_start" + ">=?" + ORDER_BY_SESSION_START_DESC;
        return db -> {
            final Long start = db.query(SessionQueries.fetchLatestSessionStartLimit(limit));
            return db.query(new QueryStatement<List<Session>>(sql){

                @Override
                public void prepare(PreparedStatement statement) throws SQLException {
                    statement.setLong(1, start != null ? start : 0L);
                }

                @Override
                public List<Session> processResults(ResultSet set) throws SQLException {
                    return SessionQueries.extractDataFromSessionSelectStatement(set);
                }
            });
        };
    }

    public static Query<Long> sessionCount(final long after, final long before, final UUID serverUUID) {
        String sql = "SELECT COUNT(1) as count FROM plan_sessions WHERE server_uuid=? AND session_end>=? AND session_start<=?";
        return new QueryStatement<Long>(sql){

            @Override
            public void prepare(PreparedStatement statement) throws SQLException {
                statement.setString(1, serverUUID.toString());
                statement.setLong(2, after);
                statement.setLong(3, before);
            }

            @Override
            public Long processResults(ResultSet set) throws SQLException {
                return set.next() ? set.getLong("count") : 0L;
            }
        };
    }

    public static Query<Long> sessionCount(final long after, final long before) {
        String sql = "SELECT COUNT(1) as count FROM plan_sessions WHERE session_end>=? AND session_start<=?";
        return new QueryStatement<Long>(sql){

            @Override
            public void prepare(PreparedStatement statement) throws SQLException {
                statement.setLong(1, after);
                statement.setLong(2, before);
            }

            @Override
            public Long processResults(ResultSet set) throws SQLException {
                return set.next() ? set.getLong("count") : 0L;
            }
        };
    }

    public static Query<NavigableMap<Long, Integer>> sessionCountPerDay(final long after, final long before, final long timeZoneOffset, final UUID serverUUID) {
        return database -> {
            Sql sql = database.getSql();
            String selectSessionsPerDay = "SELECT " + sql.dateToEpochSecond(sql.dateToDayStamp(sql.epochSecondToDate("(session_start+?)/1000"))) + "*1000 as date,COUNT(1) as session_count" + " FROM " + "plan_sessions" + " WHERE " + "session_end" + "<=?" + " AND " + "session_start" + ">=?" + " AND " + "server_uuid" + "=?" + " GROUP BY " + "date";
            return database.query(new QueryStatement<NavigableMap<Long, Integer>>(selectSessionsPerDay, 100){

                @Override
                public void prepare(PreparedStatement statement) throws SQLException {
                    statement.setLong(1, timeZoneOffset);
                    statement.setLong(2, before);
                    statement.setLong(3, after);
                    statement.setString(4, serverUUID.toString());
                }

                @Override
                public NavigableMap<Long, Integer> processResults(ResultSet set) throws SQLException {
                    TreeMap<Long, Integer> uniquePerDay = new TreeMap<Long, Integer>();
                    while (set.next()) {
                        uniquePerDay.put(set.getLong("date"), set.getInt("session_count"));
                    }
                    return uniquePerDay;
                }
            });
        };
    }

    public static Query<Long> playtime(final long after, final long before, final UUID serverUUID) {
        String sql = "SELECT SUM(session_end-session_start) as playtime FROM plan_sessions WHERE server_uuid=? AND session_end>=? AND session_start<=?";
        return new QueryStatement<Long>(sql){

            @Override
            public void prepare(PreparedStatement statement) throws SQLException {
                statement.setString(1, serverUUID.toString());
                statement.setLong(2, after);
                statement.setLong(3, before);
            }

            @Override
            public Long processResults(ResultSet set) throws SQLException {
                return set.next() ? set.getLong("playtime") : 0L;
            }
        };
    }

    public static Query<Map<UUID, Long>> playtimeOfPlayer(final long after, final long before, final UUID playerUUID) {
        String sql = "SELECT server_uuid,SUM(session_end-session_start) as playtime FROM plan_sessions WHERE uuid=? AND session_end>=? AND session_start<=? GROUP BY server_uuid";
        return new QueryStatement<Map<UUID, Long>>(sql){

            @Override
            public void prepare(PreparedStatement statement) throws SQLException {
                statement.setString(1, playerUUID.toString());
                statement.setLong(2, after);
                statement.setLong(3, before);
            }

            @Override
            public Map<UUID, Long> processResults(ResultSet set) throws SQLException {
                HashMap<UUID, Long> playtimeOfPlayer = new HashMap<UUID, Long>();
                while (set.next()) {
                    playtimeOfPlayer.put(UUID.fromString(set.getString("server_uuid")), set.getLong("playtime"));
                }
                return playtimeOfPlayer;
            }
        };
    }

    public static Query<Long> playtime(final long after, final long before) {
        String sql = "SELECT SUM(session_end-session_start) as playtime FROM plan_sessions WHERE session_end>=? AND session_start<=?";
        return new QueryStatement<Long>(sql){

            @Override
            public void prepare(PreparedStatement statement) throws SQLException {
                statement.setLong(1, after);
                statement.setLong(2, before);
            }

            @Override
            public Long processResults(ResultSet set) throws SQLException {
                return set.next() ? set.getLong("playtime") : 0L;
            }
        };
    }

    public static Query<NavigableMap<Long, Long>> playtimePerDay(final long after, final long before, final long timeZoneOffset, final UUID serverUUID) {
        return database -> {
            Sql sql = database.getSql();
            String selectPlaytimePerDay = "SELECT " + sql.dateToEpochSecond(sql.dateToDayStamp(sql.epochSecondToDate("(session_start+?)/1000"))) + "*1000 as date,SUM(" + "session_end" + '-' + "session_start" + ") as playtime" + " FROM " + "plan_sessions" + " WHERE " + "session_end" + "<=?" + " AND " + "session_start" + ">=?" + " AND " + "server_uuid" + "=?" + " GROUP BY " + "date";
            return database.query(new QueryStatement<NavigableMap<Long, Long>>(selectPlaytimePerDay, 100){

                @Override
                public void prepare(PreparedStatement statement) throws SQLException {
                    statement.setLong(1, timeZoneOffset);
                    statement.setLong(2, before);
                    statement.setLong(3, after);
                    statement.setString(4, serverUUID.toString());
                }

                @Override
                public NavigableMap<Long, Long> processResults(ResultSet set) throws SQLException {
                    TreeMap<Long, Long> uniquePerDay = new TreeMap<Long, Long>();
                    while (set.next()) {
                        uniquePerDay.put(set.getLong("date"), set.getLong("playtime"));
                    }
                    return uniquePerDay;
                }
            });
        };
    }

    public static Query<Long> averagePlaytimePerDay(final long after, final long before, final long timeZoneOffset, final UUID serverUUID) {
        return database -> {
            Sql sql = database.getSql();
            String selectPlaytimePerDay = "SELECT " + sql.dateToEpochSecond(sql.dateToDayStamp(sql.epochSecondToDate("(session_start+?)/1000"))) + "*1000 as date,SUM(" + "session_end" + '-' + "session_start" + ") as playtime" + " FROM " + "plan_sessions" + " WHERE " + "session_end" + "<=?" + " AND " + "session_start" + ">=?" + " AND " + "server_uuid" + "=?" + " GROUP BY " + "date";
            String selectAverage = "SELECT AVG(playtime) as average FROM (" + selectPlaytimePerDay + ") q1";
            return database.query(new QueryStatement<Long>(selectAverage, 100){

                @Override
                public void prepare(PreparedStatement statement) throws SQLException {
                    statement.setLong(1, timeZoneOffset);
                    statement.setLong(2, before);
                    statement.setLong(3, after);
                    statement.setString(4, serverUUID.toString());
                }

                @Override
                public Long processResults(ResultSet set) throws SQLException {
                    return set.next() ? (long)set.getDouble("average") : 0L;
                }
            });
        };
    }

    public static Query<Long> averagePlaytimePerPlayer(final long after, final long before, final UUID serverUUID) {
        return database -> {
            String selectPlaytimePerPlayer = "SELECT uuid,SUM(session_end-session_start) as playtime FROM plan_sessions WHERE session_end<=? AND session_start>=? AND server_uuid=? GROUP BY uuid";
            String selectAverage = "SELECT AVG(playtime) as average FROM (" + selectPlaytimePerPlayer + ") q1";
            return database.query(new QueryStatement<Long>(selectAverage, 100){

                @Override
                public void prepare(PreparedStatement statement) throws SQLException {
                    statement.setLong(1, before);
                    statement.setLong(2, after);
                    statement.setString(3, serverUUID.toString());
                }

                @Override
                public Long processResults(ResultSet set) throws SQLException {
                    return set.next() ? (long)set.getDouble("average") : 0L;
                }
            });
        };
    }

    public static Query<Long> averagePlaytimePerPlayer(final long after, final long before) {
        return database -> {
            String selectPlaytimePerPlayer = "SELECT uuid,SUM(session_end-session_start) as playtime FROM plan_sessions WHERE session_end<=? AND session_start>=? GROUP BY uuid";
            String selectAverage = "SELECT AVG(playtime) as average FROM (" + selectPlaytimePerPlayer + ") q1";
            return database.query(new QueryStatement<Long>(selectAverage, 100){

                @Override
                public void prepare(PreparedStatement statement) throws SQLException {
                    statement.setLong(1, before);
                    statement.setLong(2, after);
                }

                @Override
                public Long processResults(ResultSet set) throws SQLException {
                    return set.next() ? (long)set.getDouble("average") : 0L;
                }
            });
        };
    }

    public static Query<Long> averageAfkPerPlayer(final long after, final long before, final UUID serverUUID) {
        return database -> {
            String selectAfkPerPlayer = "SELECT uuid,SUM(afk_time) as afk FROM plan_sessions WHERE session_end<=? AND session_start>=? AND server_uuid=? GROUP BY uuid";
            String selectAverage = "SELECT AVG(afk) as average FROM (" + selectAfkPerPlayer + ") q1";
            return database.query(new QueryStatement<Long>(selectAverage, 100){

                @Override
                public void prepare(PreparedStatement statement) throws SQLException {
                    statement.setLong(1, before);
                    statement.setLong(2, after);
                    statement.setString(3, serverUUID.toString());
                }

                @Override
                public Long processResults(ResultSet set) throws SQLException {
                    return set.next() ? (long)set.getDouble("average") : 0L;
                }
            });
        };
    }

    public static Query<Long> averageAfkPerPlayer(final long after, final long before) {
        return database -> {
            String selectAfkPerPlayer = "SELECT uuid,SUM(afk_time) as afk FROM plan_sessions WHERE session_end<=? AND session_start>=? GROUP BY uuid";
            String selectAverage = "SELECT AVG(afk) as average FROM (" + selectAfkPerPlayer + ") q1";
            return database.query(new QueryStatement<Long>(selectAverage, 100){

                @Override
                public void prepare(PreparedStatement statement) throws SQLException {
                    statement.setLong(1, before);
                    statement.setLong(2, after);
                }

                @Override
                public Long processResults(ResultSet set) throws SQLException {
                    return set.next() ? (long)set.getDouble("average") : 0L;
                }
            });
        };
    }

    public static Query<Long> afkTime(final long after, final long before, final UUID serverUUID) {
        String sql = "SELECT SUM(afk_time) as afk_time FROM plan_sessions WHERE server_uuid=? AND session_end>=? AND session_start<=?";
        return new QueryStatement<Long>(sql){

            @Override
            public void prepare(PreparedStatement statement) throws SQLException {
                statement.setString(1, serverUUID.toString());
                statement.setLong(2, after);
                statement.setLong(3, before);
            }

            @Override
            public Long processResults(ResultSet set) throws SQLException {
                return set.next() ? set.getLong("afk_time") : 0L;
            }
        };
    }

    public static Query<Long> afkTime(final long after, final long before) {
        String sql = "SELECT SUM(afk_time) as afk_time FROM plan_sessions WHERE session_end>=? AND session_start<=?";
        return new QueryStatement<Long>(sql){

            @Override
            public void prepare(PreparedStatement statement) throws SQLException {
                statement.setLong(1, after);
                statement.setLong(2, before);
            }

            @Override
            public Long processResults(ResultSet set) throws SQLException {
                return set.next() ? set.getLong("afk_time") : 0L;
            }
        };
    }

    public static Query<Map<String, Long>> playtimePerServer(final long after, final long before) {
        String sql = "SELECT SUM(session_end-session_start) as playtime,name FROM plan_sessions JOIN plan_servers s on s.uuid=plan_sessions.server_uuid WHERE session_end>=? AND session_start<=? GROUP BY name";
        return new QueryStatement<Map<String, Long>>(sql, 100){

            @Override
            public void prepare(PreparedStatement statement) throws SQLException {
                statement.setLong(1, after);
                statement.setLong(2, before);
            }

            @Override
            public Map<String, Long> processResults(ResultSet set) throws SQLException {
                HashMap<String, Long> playtimePerServer = new HashMap<String, Long>();
                while (set.next()) {
                    playtimePerServer.put(set.getString("name"), set.getLong("playtime"));
                }
                return playtimePerServer;
            }
        };
    }

    public static Query<Long> lastSeen(final UUID playerUUID, final UUID serverUUID) {
        String sql = "SELECT MAX(session_end) as last_seen FROM plan_sessions WHERE uuid=? AND server_uuid=?";
        return new QueryStatement<Long>(sql){

            @Override
            public void prepare(PreparedStatement statement) throws SQLException {
                statement.setString(1, playerUUID.toString());
                statement.setString(2, serverUUID.toString());
            }

            @Override
            public Long processResults(ResultSet set) throws SQLException {
                return set.next() ? set.getLong("last_seen") : 0L;
            }
        };
    }

    public static Query<Long> activePlaytime(final long after, final long before, final UUID serverUUID) {
        String sql = "SELECT SUM(session_end-session_start-afk_time) as playtime FROM plan_sessions WHERE server_uuid=? AND session_end>=? AND session_start<=?";
        return new QueryStatement<Long>(sql){

            @Override
            public void prepare(PreparedStatement statement) throws SQLException {
                statement.setString(1, serverUUID.toString());
                statement.setLong(2, after);
                statement.setLong(3, before);
            }

            @Override
            public Long processResults(ResultSet set) throws SQLException {
                return set.next() ? set.getLong("playtime") : 0L;
            }
        };
    }
}

