/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plan.storage.database.queries.objects;

import com.djrapitops.plan.delivery.domain.DateObj;
import com.djrapitops.plan.gathering.domain.TPS;
import com.djrapitops.plan.gathering.domain.builders.TPSBuilder;
import com.djrapitops.plan.storage.database.queries.Query;
import com.djrapitops.plan.storage.database.queries.QueryStatement;
import com.djrapitops.plan.storage.database.sql.building.Select;
import com.djrapitops.plan.utilities.java.Lists;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;

public class TPSQueries {
    private TPSQueries() {
    }

    public static Query<List<TPS>> fetchTPSDataOfServer(final UUID serverUUID) {
        String sql = Select.all("plan_tps").where("server_id=(SELECT plan_servers.id FROM plan_servers WHERE plan_servers.uuid=? LIMIT 1)").toString();
        return new QueryStatement<List<TPS>>(sql, 50000){

            @Override
            public void prepare(PreparedStatement statement) throws SQLException {
                statement.setString(1, serverUUID.toString());
            }

            @Override
            public List<TPS> processResults(ResultSet set) throws SQLException {
                ArrayList<TPS> data = new ArrayList<TPS>();
                while (set.next()) {
                    TPS tps = TPSQueries.extractTPS(set);
                    data.add(tps);
                }
                return data;
            }
        };
    }

    public static TPS extractTPS(ResultSet set) throws SQLException {
        return TPSBuilder.get().date(set.getLong("date")).tps(set.getDouble("tps")).playersOnline(set.getInt("players_online")).usedCPU(set.getDouble("cpu_usage")).usedMemory(set.getLong("ram_usage")).entities(set.getInt("entities")).chunksLoaded(set.getInt("chunks_loaded")).freeDiskSpace(set.getLong("free_disk_space")).toTPS();
    }

    public static Query<List<TPS>> fetchTPSDataOfServer(final long after, final long before, final UUID serverUUID) {
        String sql = Select.all("plan_tps").where("server_id=(SELECT plan_servers.id FROM plan_servers WHERE plan_servers.uuid=? LIMIT 1)").and("date>=?").and("date<=?").toString();
        return new QueryStatement<List<TPS>>(sql, 50000){

            @Override
            public void prepare(PreparedStatement statement) throws SQLException {
                statement.setString(1, serverUUID.toString());
                statement.setLong(2, after);
                statement.setLong(3, before);
            }

            @Override
            public List<TPS> processResults(ResultSet set) throws SQLException {
                ArrayList<TPS> data = new ArrayList<TPS>();
                while (set.next()) {
                    TPS tps = TPSQueries.extractTPS(set);
                    data.add(tps);
                }
                return data;
            }
        };
    }

    public static Query<List<DateObj<Integer>>> fetchPlayersOnlineOfServer(final long after, final long before, final UUID serverUUID) {
        String sql = "SELECT uuid,date,players_online FROM plan_tps JOIN plan_servers on plan_servers.id=server_id WHERE uuid=? AND date<? AND date>?";
        return new QueryStatement<List<DateObj<Integer>>>(sql, 1000){

            @Override
            public void prepare(PreparedStatement statement) throws SQLException {
                statement.setString(1, serverUUID.toString());
                statement.setLong(2, before);
                statement.setLong(3, after);
            }

            @Override
            public List<DateObj<Integer>> processResults(ResultSet set) throws SQLException {
                ArrayList<DateObj<Integer>> ofServer = new ArrayList<DateObj<Integer>>();
                while (set.next()) {
                    ofServer.add(new DateObj<Integer>(set.getLong("date"), set.getInt("players_online")));
                }
                return ofServer;
            }
        };
    }

    public static Query<Map<UUID, List<TPS>>> fetchTPSDataOfAllServersBut(final long after, final long before, final UUID leaveOut) {
        String sql = "SELECT * FROM plan_tps JOIN plan_servers on plan_servers.id=server_id WHERE uuid!=? AND is_installed=? AND date<? AND date>?";
        return new QueryStatement<Map<UUID, List<TPS>>>(sql, 1000){

            @Override
            public void prepare(PreparedStatement statement) throws SQLException {
                statement.setString(1, leaveOut.toString());
                statement.setBoolean(2, true);
                statement.setLong(3, before);
                statement.setLong(4, after);
            }

            @Override
            public Map<UUID, List<TPS>> processResults(ResultSet set) throws SQLException {
                HashMap<UUID, List<TPS>> byServer = new HashMap<UUID, List<TPS>>();
                while (set.next()) {
                    UUID serverUUID = UUID.fromString(set.getString("uuid"));
                    List ofServer = byServer.computeIfAbsent(serverUUID, Lists::create);
                    ofServer.add(TPSQueries.extractTPS(set));
                }
                return byServer;
            }
        };
    }

    public static Query<Optional<DateObj<Integer>>> fetchPeakPlayerCount(final UUID serverUUID, final long afterDate) {
        String subQuery = "(SELECT MAX(players_online) FROM plan_tps WHERE server_id=(SELECT plan_servers.id FROM plan_servers WHERE plan_servers.uuid=? LIMIT 1) AND date>= ?)";
        String sql = "SELECT date,players_online FROM plan_tps WHERE server_id=(SELECT plan_servers.id FROM plan_servers WHERE plan_servers.uuid=? LIMIT 1) AND date>= ? AND players_online=" + subQuery + " ORDER BY " + "date" + " DESC LIMIT 1";
        return new QueryStatement<Optional<DateObj<Integer>>>(sql){

            @Override
            public void prepare(PreparedStatement statement) throws SQLException {
                statement.setString(1, serverUUID.toString());
                statement.setLong(2, afterDate);
                statement.setString(3, serverUUID.toString());
                statement.setLong(4, afterDate);
            }

            @Override
            public Optional<DateObj<Integer>> processResults(ResultSet set) throws SQLException {
                if (set.next()) {
                    return Optional.of(new DateObj<Integer>(set.getLong("date"), set.getInt("players_online")));
                }
                return Optional.empty();
            }
        };
    }

    public static Query<Optional<DateObj<Integer>>> fetchAllTimePeakPlayerCount(UUID serverUUID) {
        return TPSQueries.fetchPeakPlayerCount(serverUUID, 0L);
    }

    public static Query<Optional<TPS>> fetchLatestTPSEntryForServer(final UUID serverUUID) {
        String sql = "SELECT * FROM plan_tps WHERE server_id=(SELECT plan_servers.id FROM plan_servers WHERE plan_servers.uuid=? LIMIT 1) ORDER BY date DESC LIMIT 1";
        return new QueryStatement<Optional<TPS>>(sql){

            @Override
            public void prepare(PreparedStatement statement) throws SQLException {
                statement.setString(1, serverUUID.toString());
            }

            @Override
            public Optional<TPS> processResults(ResultSet set) throws SQLException {
                if (set.next()) {
                    return Optional.of(TPSBuilder.get().date(set.getLong("date")).tps(set.getDouble("tps")).playersOnline(set.getInt("players_online")).usedCPU(set.getDouble("cpu_usage")).usedMemory(set.getLong("ram_usage")).entities(set.getInt("entities")).chunksLoaded(set.getInt("chunks_loaded")).freeDiskSpace(set.getLong("free_disk_space")).toTPS());
                }
                return Optional.empty();
            }
        };
    }

    public static Query<Double> averageTPS(final long after, final long before, final UUID serverUUID) {
        String sql = "SELECT AVG(tps) as average FROM plan_tps WHERE server_id=(SELECT plan_servers.id FROM plan_servers WHERE plan_servers.uuid=? LIMIT 1) AND tps>=0 AND date<? AND date>?";
        return new QueryStatement<Double>(sql){

            @Override
            public void prepare(PreparedStatement statement) throws SQLException {
                statement.setString(1, serverUUID.toString());
                statement.setLong(2, before);
                statement.setLong(3, after);
            }

            @Override
            public Double processResults(ResultSet set) throws SQLException {
                return set.next() ? set.getDouble("average") : -1.0;
            }
        };
    }

    public static Query<Double> averageCPU(final long after, final long before, final UUID serverUUID) {
        String sql = "SELECT AVG(cpu_usage) as average FROM plan_tps WHERE server_id=(SELECT plan_servers.id FROM plan_servers WHERE plan_servers.uuid=? LIMIT 1) AND cpu_usage>=0 AND date<? AND date>?";
        return new QueryStatement<Double>(sql){

            @Override
            public void prepare(PreparedStatement statement) throws SQLException {
                statement.setString(1, serverUUID.toString());
                statement.setLong(2, before);
                statement.setLong(3, after);
            }

            @Override
            public Double processResults(ResultSet set) throws SQLException {
                return set.next() ? set.getDouble("average") : -1.0;
            }
        };
    }

    public static Query<Long> averageRAM(final long after, final long before, final UUID serverUUID) {
        String sql = "SELECT AVG(ram_usage) as average FROM plan_tps WHERE server_id=(SELECT plan_servers.id FROM plan_servers WHERE plan_servers.uuid=? LIMIT 1) AND ram_usage>=0 AND date<? AND date>?";
        return new QueryStatement<Long>(sql){

            @Override
            public void prepare(PreparedStatement statement) throws SQLException {
                statement.setString(1, serverUUID.toString());
                statement.setLong(2, before);
                statement.setLong(3, after);
            }

            @Override
            public Long processResults(ResultSet set) throws SQLException {
                return set.next() ? (long)set.getDouble("average") : -1L;
            }
        };
    }

    public static Query<Long> averageChunks(final long after, final long before, final UUID serverUUID) {
        String sql = "SELECT AVG(chunks_loaded) as average FROM plan_tps WHERE server_id=(SELECT plan_servers.id FROM plan_servers WHERE plan_servers.uuid=? LIMIT 1) AND chunks_loaded>=0 AND date<? AND date>?";
        return new QueryStatement<Long>(sql){

            @Override
            public void prepare(PreparedStatement statement) throws SQLException {
                statement.setString(1, serverUUID.toString());
                statement.setLong(2, before);
                statement.setLong(3, after);
            }

            @Override
            public Long processResults(ResultSet set) throws SQLException {
                return set.next() ? (long)set.getDouble("average") : -1L;
            }
        };
    }

    public static Query<Long> averageEntities(final long after, final long before, final UUID serverUUID) {
        String sql = "SELECT AVG(entities) as average FROM plan_tps WHERE server_id=(SELECT plan_servers.id FROM plan_servers WHERE plan_servers.uuid=? LIMIT 1) AND entities>=0 AND date<? AND date>?";
        return new QueryStatement<Long>(sql){

            @Override
            public void prepare(PreparedStatement statement) throws SQLException {
                statement.setString(1, serverUUID.toString());
                statement.setLong(2, before);
                statement.setLong(3, after);
            }

            @Override
            public Long processResults(ResultSet set) throws SQLException {
                return set.next() ? (long)set.getDouble("average") : -1L;
            }
        };
    }

    public static Query<Long> maxFreeDisk(final long after, final long before, final UUID serverUUID) {
        String sql = "SELECT MAX(free_disk_space) as free FROM plan_tps WHERE server_id=(SELECT plan_servers.id FROM plan_servers WHERE plan_servers.uuid=? LIMIT 1) AND free_disk_space>=0 AND date<? AND date>?";
        return new QueryStatement<Long>(sql){

            @Override
            public void prepare(PreparedStatement statement) throws SQLException {
                statement.setString(1, serverUUID.toString());
                statement.setLong(2, before);
                statement.setLong(3, after);
            }

            @Override
            public Long processResults(ResultSet set) throws SQLException {
                return set.next() ? set.getLong("free") : -1L;
            }
        };
    }

    public static Query<Long> minFreeDisk(final long after, final long before, final UUID serverUUID) {
        String sql = "SELECT MIN(free_disk_space) as free FROM plan_tps WHERE server_id=(SELECT plan_servers.id FROM plan_servers WHERE plan_servers.uuid=? LIMIT 1) AND free_disk_space>=0 AND date<? AND date>?";
        return new QueryStatement<Long>(sql){

            @Override
            public void prepare(PreparedStatement statement) throws SQLException {
                statement.setString(1, serverUUID.toString());
                statement.setLong(2, before);
                statement.setLong(3, after);
            }

            @Override
            public Long processResults(ResultSet set) throws SQLException {
                return set.next() ? set.getLong("free") : -1L;
            }
        };
    }

    public static Query<Long> averageFreeDisk(final long after, final long before, final UUID serverUUID) {
        String sql = "SELECT AVG(free_disk_space) as average FROM plan_tps WHERE server_id=(SELECT plan_servers.id FROM plan_servers WHERE plan_servers.uuid=? LIMIT 1) AND free_disk_space>=0 AND date<? AND date>?";
        return new QueryStatement<Long>(sql){

            @Override
            public void prepare(PreparedStatement statement) throws SQLException {
                statement.setString(1, serverUUID.toString());
                statement.setLong(2, before);
                statement.setLong(3, after);
            }

            @Override
            public Long processResults(ResultSet set) throws SQLException {
                return set.next() ? (long)set.getDouble("average") : -1L;
            }
        };
    }
}

