/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plan.storage.database.queries.objects;

import com.djrapitops.plan.storage.database.queries.Query;
import com.djrapitops.plan.storage.database.queries.QueryAllStatement;
import com.djrapitops.plan.storage.database.queries.QueryStatement;
import com.djrapitops.plan.storage.database.sql.building.Select;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;

public class UserIdentifierQueries {
    private UserIdentifierQueries() {
    }

    public static Query<Set<UUID>> fetchAllPlayerUUIDs() {
        String sql = Select.from("plan_users", "uuid").toString();
        return new QueryAllStatement<Set<UUID>>(sql, 20000){

            @Override
            public Set<UUID> processResults(ResultSet set) throws SQLException {
                HashSet<UUID> playerUUIDs = new HashSet<UUID>();
                while (set.next()) {
                    UUID playerUUID = UUID.fromString(set.getString("uuid"));
                    playerUUIDs.add(playerUUID);
                }
                return playerUUIDs;
            }
        };
    }

    public static Query<Set<UUID>> fetchPlayerUUIDsOfServer(final UUID serverUUID) {
        String sql = "SELECT plan_users.uuid, FROM plan_users JOIN plan_user_info on plan_users.uuid=plan_user_info.uuid WHERE server_uuid=?";
        return new QueryStatement<Set<UUID>>(sql, 1000){

            @Override
            public void prepare(PreparedStatement statement) throws SQLException {
                statement.setString(1, serverUUID.toString());
            }

            @Override
            public Set<UUID> processResults(ResultSet set) throws SQLException {
                HashSet<UUID> playerUUIDs = new HashSet<UUID>();
                while (set.next()) {
                    UUID playerUUID = UUID.fromString(set.getString("uuid"));
                    playerUUIDs.add(playerUUID);
                }
                return playerUUIDs;
            }
        };
    }

    public static Query<Map<UUID, String>> fetchAllPlayerNames() {
        String sql = Select.from("plan_users", "uuid", "name").toString();
        return new QueryAllStatement<Map<UUID, String>>(sql, 20000){

            @Override
            public Map<UUID, String> processResults(ResultSet set) throws SQLException {
                HashMap<UUID, String> names = new HashMap<UUID, String>();
                while (set.next()) {
                    UUID uuid = UUID.fromString(set.getString("uuid"));
                    String name = set.getString("name");
                    names.put(uuid, name);
                }
                return names;
            }
        };
    }

    public static Query<Optional<UUID>> fetchPlayerUUIDOf(final String playerName) {
        String sql = Select.from("plan_users", "uuid").where("UPPER(name)=UPPER(?)").toString();
        return new QueryStatement<Optional<UUID>>(sql){

            @Override
            public void prepare(PreparedStatement statement) throws SQLException {
                statement.setString(1, playerName);
            }

            @Override
            public Optional<UUID> processResults(ResultSet set) throws SQLException {
                if (set.next()) {
                    String uuidS = set.getString("uuid");
                    return Optional.of(UUID.fromString(uuidS));
                }
                return Optional.empty();
            }
        };
    }

    public static Query<Optional<String>> fetchPlayerNameOf(final UUID playerUUID) {
        String sql = Select.from("plan_users", "name").where("uuid=?").toString();
        return new QueryStatement<Optional<String>>(sql){

            @Override
            public void prepare(PreparedStatement statement) throws SQLException {
                statement.setString(1, playerUUID.toString());
            }

            @Override
            public Optional<String> processResults(ResultSet set) throws SQLException {
                if (set.next()) {
                    return Optional.of(set.getString("name"));
                }
                return Optional.empty();
            }
        };
    }

    public static Query<List<String>> fetchMatchingPlayerNames(final String searchFor) {
        String sql = "SELECT DISTINCT name FROM plan_users WHERE LOWER(name) LIKE LOWER(?) UNION SELECT DISTINCT name FROM plan_users JOIN plan_nicknames on plan_users.uuid=plan_nicknames.uuid WHERE LOWER(nickname) LIKE LOWER(?)";
        return new QueryStatement<List<String>>(sql, 5000){

            @Override
            public void prepare(PreparedStatement statement) throws SQLException {
                statement.setString(1, '%' + searchFor + '%');
                statement.setString(2, '%' + searchFor + '%');
            }

            @Override
            public List<String> processResults(ResultSet set) throws SQLException {
                ArrayList<String> matchingNames = new ArrayList<String>();
                while (set.next()) {
                    String match = set.getString("name");
                    if (matchingNames.contains(match)) continue;
                    matchingNames.add(match);
                }
                return matchingNames;
            }
        };
    }
}

