/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plan.storage.database.queries.objects;

import com.djrapitops.plan.gathering.domain.UserInfo;
import com.djrapitops.plan.storage.database.queries.Query;
import com.djrapitops.plan.storage.database.queries.QueryAllStatement;
import com.djrapitops.plan.storage.database.queries.QueryStatement;
import com.djrapitops.plan.utilities.java.Lists;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;

public class UserInfoQueries {
    private UserInfoQueries() {
    }

    public static Query<Map<UUID, List<UserInfo>>> fetchAllUserInformation() {
        String sql = "SELECT registered,banned,opped,uuid,server_uuid FROM plan_user_info";
        return new QueryAllStatement<Map<UUID, List<UserInfo>>>(sql, 50000){

            @Override
            public Map<UUID, List<UserInfo>> processResults(ResultSet set) throws SQLException {
                HashMap<UUID, List<UserInfo>> serverMap = new HashMap<UUID, List<UserInfo>>();
                while (set.next()) {
                    UUID serverUUID = UUID.fromString(set.getString("server_uuid"));
                    UUID uuid = UUID.fromString(set.getString("uuid"));
                    List userInfos = serverMap.computeIfAbsent(serverUUID, Lists::create);
                    long registered = set.getLong("registered");
                    boolean banned = set.getBoolean("banned");
                    boolean op = set.getBoolean("opped");
                    userInfos.add(new UserInfo(uuid, serverUUID, registered, op, banned));
                }
                return serverMap;
            }
        };
    }

    public static Query<List<UserInfo>> fetchUserInformationOfUser(final UUID playerUUID) {
        String sql = "SELECT plan_user_info.registered,banned,opped,server_uuid FROM plan_user_info WHERE plan_user_info.uuid=?";
        return new QueryStatement<List<UserInfo>>(sql){

            @Override
            public void prepare(PreparedStatement statement) throws SQLException {
                statement.setString(1, playerUUID.toString());
            }

            @Override
            public List<UserInfo> processResults(ResultSet set) throws SQLException {
                ArrayList<UserInfo> userInformation = new ArrayList<UserInfo>();
                while (set.next()) {
                    long registered = set.getLong("registered");
                    boolean op = set.getBoolean("opped");
                    boolean banned = set.getBoolean("banned");
                    UUID serverUUID = UUID.fromString(set.getString("server_uuid"));
                    userInformation.add(new UserInfo(playerUUID, serverUUID, registered, op, banned));
                }
                return userInformation;
            }
        };
    }

    public static Query<Map<UUID, UserInfo>> fetchUserInformationOfServer(final UUID serverUUID) {
        String sql = "SELECT registered,banned,opped,uuid,server_uuid FROM plan_user_info WHERE server_uuid=?";
        return new QueryStatement<Map<UUID, UserInfo>>(sql, 1000){

            @Override
            public void prepare(PreparedStatement statement) throws SQLException {
                statement.setString(1, serverUUID.toString());
            }

            @Override
            public Map<UUID, UserInfo> processResults(ResultSet set) throws SQLException {
                HashMap<UUID, UserInfo> userInformation = new HashMap<UUID, UserInfo>();
                while (set.next()) {
                    UUID serverUUID2 = UUID.fromString(set.getString("server_uuid"));
                    UUID uuid = UUID.fromString(set.getString("uuid"));
                    long registered = set.getLong("registered");
                    boolean banned = set.getBoolean("banned");
                    boolean op = set.getBoolean("opped");
                    userInformation.put(uuid, new UserInfo(uuid, serverUUID2, registered, op, banned));
                }
                return userInformation;
            }
        };
    }

    public static Query<Map<UUID, Long>> fetchRegisterDates(final long after, final long before, final UUID serverUUID) {
        String sql = "SELECT uuid,registered FROM plan_user_info WHERE server_uuid=? AND registered>=? AND registered<=?";
        return new QueryStatement<Map<UUID, Long>>(sql, 1000){

            @Override
            public void prepare(PreparedStatement statement) throws SQLException {
                statement.setString(1, serverUUID.toString());
                statement.setLong(2, after);
                statement.setLong(3, before);
            }

            @Override
            public Map<UUID, Long> processResults(ResultSet set) throws SQLException {
                HashMap<UUID, Long> registerDates = new HashMap<UUID, Long>();
                while (set.next()) {
                    registerDates.put(UUID.fromString(set.getString("uuid")), set.getLong("registered"));
                }
                return registerDates;
            }
        };
    }
}

