/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plan.storage.database.queries.objects;

import com.djrapitops.plan.delivery.domain.WebUser;
import com.djrapitops.plan.delivery.domain.auth.User;
import com.djrapitops.plan.storage.database.queries.Query;
import com.djrapitops.plan.storage.database.queries.QueryAllStatement;
import com.djrapitops.plan.storage.database.queries.QueryStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;

public class WebUserQueries {
    private WebUserQueries() {
    }

    public static Query<Optional<User>> fetchUser(final String username) {
        String sql = "SELECT * FROM plan_security LEFT JOIN plan_users on linked_to_uuid=uuid WHERE username=? LIMIT 1";
        return new QueryStatement<Optional<User>>(sql){

            @Override
            public void prepare(PreparedStatement statement) throws SQLException {
                statement.setString(1, username);
            }

            @Override
            public Optional<User> processResults(ResultSet set) throws SQLException {
                if (set.next()) {
                    String linkedTo = set.getString("name");
                    UUID linkedToUUID = linkedTo != null ? UUID.fromString(set.getString("linked_to_uuid")) : null;
                    String passwordHash = set.getString("salted_pass_hash");
                    int permissionLevel = set.getInt("permission_level");
                    List<String> permissions = WebUser.getPermissionsForLevel(permissionLevel);
                    return Optional.of(new User(username, linkedTo != null ? linkedTo : "console", linkedToUUID, passwordHash, permissionLevel, permissions));
                }
                return Optional.empty();
            }
        };
    }

    public static Query<Optional<User>> fetchUserLinkedTo(final String playerName) {
        String sql = "SELECT * FROM plan_security LEFT JOIN plan_users on linked_to_uuid=uuid WHERE name=? LIMIT 1";
        return new QueryStatement<Optional<User>>(sql){

            @Override
            public void prepare(PreparedStatement statement) throws SQLException {
                statement.setString(1, playerName);
            }

            @Override
            public Optional<User> processResults(ResultSet set) throws SQLException {
                if (set.next()) {
                    String linkedTo = set.getString("name");
                    UUID linkedToUUID = linkedTo != null ? UUID.fromString(set.getString("linked_to_uuid")) : null;
                    String passwordHash = set.getString("salted_pass_hash");
                    int permissionLevel = set.getInt("permission_level");
                    List<String> permissions = WebUser.getPermissionsForLevel(permissionLevel);
                    return Optional.of(new User(playerName, linkedTo != null ? linkedTo : "console", linkedToUUID, passwordHash, permissionLevel, permissions));
                }
                return Optional.empty();
            }
        };
    }

    public static Query<Optional<User>> fetchUser(final UUID linkedToUUID) {
        String sql = "SELECT * FROM plan_security LEFT JOIN plan_users on linked_to_uuid=uuid WHERE linked_to_uuid=? LIMIT 1";
        return new QueryStatement<Optional<User>>(sql){

            @Override
            public void prepare(PreparedStatement statement) throws SQLException {
                if (linkedToUUID == null) {
                    statement.setNull(1, 12);
                } else {
                    statement.setString(1, linkedToUUID.toString());
                }
            }

            @Override
            public Optional<User> processResults(ResultSet set) throws SQLException {
                if (set.next()) {
                    String username = set.getString("username");
                    String linkedTo = set.getString("name");
                    String passwordHash = set.getString("salted_pass_hash");
                    int permissionLevel = set.getInt("permission_level");
                    List<String> permissions = WebUser.getPermissionsForLevel(permissionLevel);
                    return Optional.of(new User(username, linkedTo != null ? linkedTo : "console", linkedToUUID, passwordHash, permissionLevel, permissions));
                }
                return Optional.empty();
            }
        };
    }

    public static Query<List<User>> fetchAllUsers() {
        String sql = "SELECT * FROM plan_security LEFT JOIN plan_users on linked_to_uuid=uuid";
        return new QueryAllStatement<List<User>>(sql){

            @Override
            public List<User> processResults(ResultSet set) throws SQLException {
                ArrayList<User> users = new ArrayList<User>();
                while (set.next()) {
                    String username = set.getString("username");
                    String linkedTo = set.getString("name");
                    UUID linkedToUUID = linkedTo != null ? UUID.fromString(set.getString("linked_to_uuid")) : null;
                    String passwordHash = set.getString("salted_pass_hash");
                    int permissionLevel = set.getInt("permission_level");
                    List<String> permissions = WebUser.getPermissionsForLevel(permissionLevel);
                    users.add(new User(username, linkedTo != null ? linkedTo : "console", linkedToUUID, passwordHash, permissionLevel, permissions));
                }
                return users;
            }
        };
    }
}

