/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plan.storage.database.queries.objects;

import com.djrapitops.plan.gathering.domain.GMTimes;
import com.djrapitops.plan.gathering.domain.WorldTimes;
import com.djrapitops.plan.storage.database.queries.Query;
import com.djrapitops.plan.storage.database.queries.QueryStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;

public class WorldTimesQueries {
    private static final String WORLD_COLUMN = "world";
    private static final String SELECT_WORLD_TIMES_JOIN_WORLD_NAME = "plan_worlds.world_name as world FROM plan_world_times JOIN plan_worlds on plan_worlds.id=world_id";
    private static final String SELECT_WORLD_TIMES_STATEMENT_START = "SELECT SUM(survival_time) as survival, SUM(creative_time) as creative, SUM(adventure_time) as adventure, SUM(spectator_time) as spectator, ";

    private WorldTimesQueries() {
    }

    public static Query<WorldTimes> fetchServerTotalWorldTimes(final UUID serverUUID) {
        String sql = "SELECT SUM(survival_time) as survival, SUM(creative_time) as creative, SUM(adventure_time) as adventure, SUM(spectator_time) as spectator, plan_worlds.world_name as world FROM plan_world_times JOIN plan_worlds on plan_worlds.id=world_id WHERE plan_world_times.server_uuid=? GROUP BY world";
        return new QueryStatement<WorldTimes>(sql, 1000){

            @Override
            public void prepare(PreparedStatement statement) throws SQLException {
                statement.setString(1, serverUUID.toString());
            }

            @Override
            public WorldTimes processResults(ResultSet set) throws SQLException {
                String[] gms = GMTimes.getGMKeyArray();
                WorldTimes worldTimes = new WorldTimes();
                while (set.next()) {
                    String worldName = set.getString(WorldTimesQueries.WORLD_COLUMN);
                    GMTimes gmTimes = WorldTimesQueries.extractGMTimes(set, gms);
                    worldTimes.setGMTimesForWorld(worldName, gmTimes);
                }
                return worldTimes;
            }
        };
    }

    public static Query<WorldTimes> fetchPlayerTotalWorldTimes(final UUID playerUUID) {
        String sql = "SELECT SUM(survival_time) as survival, SUM(creative_time) as creative, SUM(adventure_time) as adventure, SUM(spectator_time) as spectator, plan_worlds.world_name as world FROM plan_world_times JOIN plan_worlds on plan_worlds.id=world_id WHERE uuid=? GROUP BY world";
        return new QueryStatement<WorldTimes>(sql){

            @Override
            public void prepare(PreparedStatement statement) throws SQLException {
                statement.setString(1, playerUUID.toString());
            }

            @Override
            public WorldTimes processResults(ResultSet set) throws SQLException {
                String[] gms = GMTimes.getGMKeyArray();
                WorldTimes worldTimes = new WorldTimes();
                while (set.next()) {
                    String worldName = set.getString(WorldTimesQueries.WORLD_COLUMN);
                    GMTimes gmTimes = WorldTimesQueries.extractGMTimes(set, gms);
                    worldTimes.setGMTimesForWorld(worldName, gmTimes);
                }
                return worldTimes;
            }
        };
    }

    public static Query<Map<UUID, WorldTimes>> fetchPlayerWorldTimesOnServers(final UUID playerUUID) {
        String sql = "SELECT SUM(survival_time) as survival, SUM(creative_time) as creative, SUM(adventure_time) as adventure, SUM(spectator_time) as spectator, plan_world_times.server_uuid,plan_worlds.world_name as world FROM plan_world_times JOIN plan_worlds on plan_worlds.id=world_id WHERE plan_world_times.uuid=? GROUP BY world,plan_world_times.server_uuid";
        return new QueryStatement<Map<UUID, WorldTimes>>(sql, 1000){

            @Override
            public void prepare(PreparedStatement statement) throws SQLException {
                statement.setString(1, playerUUID.toString());
            }

            @Override
            public Map<UUID, WorldTimes> processResults(ResultSet set) throws SQLException {
                String[] gms = GMTimes.getGMKeyArray();
                HashMap<UUID, WorldTimes> worldTimesMap = new HashMap<UUID, WorldTimes>();
                while (set.next()) {
                    UUID serverUUID = UUID.fromString(set.getString("server_uuid"));
                    WorldTimes worldTimes = worldTimesMap.getOrDefault(serverUUID, new WorldTimes());
                    String worldName = set.getString(WorldTimesQueries.WORLD_COLUMN);
                    GMTimes gmTimes = WorldTimesQueries.extractGMTimes(set, gms);
                    worldTimes.setGMTimesForWorld(worldName, gmTimes);
                    worldTimesMap.put(serverUUID, worldTimes);
                }
                return worldTimesMap;
            }
        };
    }

    private static GMTimes extractGMTimes(ResultSet set, String[] gms) throws SQLException {
        HashMap<String, Long> gmMap = new HashMap<String, Long>();
        for (String gameMode : gms) {
            gmMap.put(gameMode, set.getLong(gameMode));
        }
        return new GMTimes(gmMap);
    }

    public static Query<GMTimes> fetchGMTimes(final long after, final long before, final UUID serverUUID) {
        String sql = "SELECT SUM(survival_time) as SURVIVAL,SUM(creative_time) as CREATIVE,SUM(adventure_time) as ADVENTURE,SUM(spectator_time) as SPECTATOR FROM plan_world_times w1 JOIN plan_sessions s1 on s1.id=session_id WHERE w1.server_uuid=? AND session_start>=? AND session_end<=?";
        return new QueryStatement<GMTimes>(sql){

            @Override
            public void prepare(PreparedStatement statement) throws SQLException {
                statement.setString(1, serverUUID.toString());
                statement.setLong(2, after);
                statement.setLong(3, before);
            }

            @Override
            public GMTimes processResults(ResultSet set) throws SQLException {
                return set.next() ? WorldTimesQueries.extractGMTimes(set, GMTimes.getGMKeyArray()) : new GMTimes();
            }
        };
    }
}

