/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plan.storage.database.queries.schema;

import com.djrapitops.plan.storage.database.queries.HasMoreThanZeroQueryStatement;
import com.djrapitops.plan.storage.database.queries.Query;
import com.djrapitops.plan.storage.database.queries.QueryStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public class MySQLSchemaQueries {
    private MySQLSchemaQueries() {
    }

    public static Query<Boolean> doesTableExist(final String tableName) {
        String sql = "SELECT COUNT(1) as c FROM information_schema.TABLES WHERE table_name=? AND TABLE_SCHEMA=DATABASE()";
        return new HasMoreThanZeroQueryStatement(sql){

            @Override
            public void prepare(PreparedStatement statement) throws SQLException {
                statement.setString(1, tableName);
            }
        };
    }

    public static Query<List<ForeignKeyConstraint>> foreignKeyConstraintsOf(final String referencedTable) {
        String keySQL = "SELECT TABLE_NAME,COLUMN_NAME,CONSTRAINT_NAME,REFERENCED_TABLE_NAME,REFERENCED_COLUMN_NAME FROM INFORMATION_SCHEMA.KEY_COLUMN_USAGE WHERE REFERENCED_TABLE_SCHEMA = DATABASE() AND REFERENCED_TABLE_NAME = ?";
        return new QueryStatement<List<ForeignKeyConstraint>>(keySQL){

            @Override
            public void prepare(PreparedStatement statement) throws SQLException {
                statement.setString(1, referencedTable);
            }

            @Override
            public List<ForeignKeyConstraint> processResults(ResultSet set) throws SQLException {
                ArrayList<ForeignKeyConstraint> constraints = new ArrayList<ForeignKeyConstraint>();
                while (set.next()) {
                    String table = set.getString("TABLE_NAME");
                    String referencedTable2 = set.getString("REFERENCED_TABLE_NAME");
                    String column = set.getString("COLUMN_NAME");
                    String referencedColumn = set.getString("REFERENCED_COLUMN_NAME");
                    String constraintName = set.getString("CONSTRAINT_NAME");
                    constraints.add(new ForeignKeyConstraint(table, referencedTable2, column, referencedColumn, constraintName));
                }
                return constraints;
            }
        };
    }

    public static Query<Boolean> doesIndexExist(final String indexName, final String tableName) {
        String sql = "SELECT COUNT(1) as c FROM INFORMATION_SCHEMA.STATISTICS WHERE table_schema=DATABASE() AND table_name=? AND index_name=?";
        return new HasMoreThanZeroQueryStatement(sql){

            @Override
            public void prepare(PreparedStatement statement) throws SQLException {
                statement.setString(1, tableName);
                statement.setString(2, indexName);
            }
        };
    }

    public static Query<Boolean> doesColumnExist(final String tableName, final String columnName) {
        String sql = "SELECT COUNT(1) as c FROM information_schema.COLUMNS WHERE TABLE_NAME=? AND COLUMN_NAME=? AND TABLE_SCHEMA=DATABASE()";
        return new HasMoreThanZeroQueryStatement(sql){

            @Override
            public void prepare(PreparedStatement statement) throws SQLException {
                statement.setString(1, tableName);
                statement.setString(2, columnName);
            }
        };
    }

    public static Query<Integer> columnVarcharLength(final String table, final String column) {
        String sql = "SELECT CHARACTER_MAXIMUM_LENGTH FROM information_schema.COLUMNS WHERE TABLE_NAME=? AND COLUMN_NAME=? AND TABLE_SCHEMA=DATABASE()";
        return new QueryStatement<Integer>(sql){

            @Override
            public void prepare(PreparedStatement statement) throws SQLException {
                statement.setString(1, table);
                statement.setString(2, column);
            }

            @Override
            public Integer processResults(ResultSet set) throws SQLException {
                return set.next() ? set.getInt("CHARACTER_MAXIMUM_LENGTH") : Integer.MAX_VALUE;
            }
        };
    }

    public static class ForeignKeyConstraint {
        private final String table;
        private final String referencedTable;
        private final String column;
        private final String referencedColumn;
        private final String constraintName;

        public ForeignKeyConstraint(String table, String referencedTable, String column, String referencedColumn, String constraintName) {
            this.table = table;
            this.referencedTable = referencedTable;
            this.column = column;
            this.referencedColumn = referencedColumn;
            this.constraintName = constraintName;
        }

        public String getTable() {
            return this.table;
        }

        public String getReferencedTable() {
            return this.referencedTable;
        }

        public String getColumn() {
            return this.column;
        }

        public String getReferencedColumn() {
            return this.referencedColumn;
        }

        public String getConstraintName() {
            return this.constraintName;
        }

        public String toString() {
            return "FK '" + this.constraintName + "' " + this.table + '.' + this.column + " references " + this.referencedTable + '.' + this.referencedColumn;
        }
    }
}

