/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plan.storage.database.queries.schema;

import com.djrapitops.plan.storage.database.queries.HasMoreThanZeroQueryStatement;
import com.djrapitops.plan.storage.database.queries.Query;
import com.djrapitops.plan.storage.database.queries.QueryAllStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

public class SQLiteSchemaQueries {
    private SQLiteSchemaQueries() {
    }

    public static Query<Boolean> doesTableExist(final String tableName) {
        String sql = "SELECT COUNT(1) as c FROM sqlite_master WHERE tbl_name=?";
        return new HasMoreThanZeroQueryStatement(sql){

            @Override
            public void prepare(PreparedStatement statement) throws SQLException {
                statement.setString(1, tableName);
            }
        };
    }

    public static Query<Boolean> doesColumnExist(String tableName, final String columnName) {
        return new QueryAllStatement<Boolean>("PRAGMA table_info(" + tableName + ')'){

            @Override
            public Boolean processResults(ResultSet set) throws SQLException {
                while (set.next()) {
                    if (!columnName.equals(set.getString("name"))) continue;
                    return true;
                }
                return false;
            }
        };
    }
}

