/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plan.storage.database.sql.building;

import com.djrapitops.plan.storage.database.DBType;
import com.djrapitops.plugin.utilities.Verify;

public class CreateTableBuilder {
    private final DBType dbType;
    private final StringBuilder columns;
    private final StringBuilder keyConstraints;
    private StringBuilder columnBuilder;
    private int columnCount = 0;
    private int constraintCount = 0;

    private CreateTableBuilder(DBType dbType, String tableName) {
        this.dbType = dbType;
        this.columns = new StringBuilder("CREATE TABLE IF NOT EXISTS " + tableName + " (");
        this.keyConstraints = new StringBuilder();
    }

    public static CreateTableBuilder create(String tableName, DBType type) {
        return new CreateTableBuilder(type, tableName);
    }

    private void finalizeColumn() {
        if (this.columnBuilder != null) {
            if (this.columnCount > 0) {
                this.columns.append(',');
            }
            this.columns.append(this.columnBuilder.toString());
            ++this.columnCount;
            this.columnBuilder = null;
        }
    }

    public CreateTableBuilder column(String column, String type) {
        this.finalizeColumn();
        this.columnBuilder = new StringBuilder();
        this.columnBuilder.append(column).append(" ").append(type);
        return this;
    }

    public CreateTableBuilder primaryKey() {
        String currentColumn = this.columnBuilder.substring(0, this.columnBuilder.indexOf(" "));
        if (this.dbType.supportsMySQLQueries()) {
            this.notNull();
            this.columnBuilder.append(" AUTO_INCREMENT");
            this.primaryKey(currentColumn);
        } else {
            this.columnBuilder.append(" PRIMARY KEY");
        }
        return this;
    }

    public CreateTableBuilder notNull() {
        this.columnBuilder.append(" NOT NULL");
        return this;
    }

    public CreateTableBuilder unique() {
        this.columnBuilder.append(" UNIQUE");
        return this;
    }

    public CreateTableBuilder defaultValue(boolean value) {
        return this.defaultValue(value ? "1" : "0");
    }

    public CreateTableBuilder defaultValue(String value) {
        this.columnBuilder.append(" DEFAULT ").append(value);
        return this;
    }

    public CreateTableBuilder foreignKey(String column, String referencedTable, String referencedColumn) {
        this.finalizeColumn();
        if (this.constraintCount > 0) {
            this.keyConstraints.append(',');
        }
        this.keyConstraints.append("FOREIGN KEY(").append(column).append(") REFERENCES ").append(referencedTable).append('(').append(referencedColumn).append(')');
        ++this.constraintCount;
        return this;
    }

    private void primaryKey(String column) {
        this.finalizeColumn();
        if (this.constraintCount > 0) {
            this.keyConstraints.append(',');
        }
        this.keyConstraints.append("PRIMARY KEY (").append(column).append(')');
        ++this.constraintCount;
    }

    public String build() {
        return this.toString();
    }

    public String toString() {
        this.finalizeColumn();
        Verify.isTrue(this.columnCount > 0, () -> new IllegalStateException("No columns specified for statement '" + this.columns.toString() + "..'"));
        if (this.constraintCount > 0) {
            return this.columns.toString() + ',' + this.keyConstraints.toString() + ')';
        }
        return this.columns.toString() + ')';
    }
}

