/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plan.storage.database.sql.building;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.concurrent.TimeUnit;

public abstract class Sql {
    public static final String ID = "id";
    public static final String P_UUID = "uuid";
    public static final String INT = "integer";
    public static final String DOUBLE = "double";
    public static final String LONG = "bigint";
    public static final String BOOL = "boolean";
    public static final String SELECT = "SELECT ";
    public static final String DISTINCT = "DISTINCT ";
    public static final String FROM = " FROM ";
    public static final String DELETE_FROM = "DELETE FROM ";
    public static final String WHERE = " WHERE ";
    public static final String GROUP_BY = " GROUP BY ";
    public static final String ORDER_BY = " ORDER BY ";
    public static final String INNER_JOIN = " JOIN ";
    public static final String LEFT_JOIN = " LEFT JOIN ";
    public static final String UNION = " UNION ";
    public static final String UNION_ALL = " UNION ALL ";
    public static final String AND = " AND ";
    public static final String OR = " OR ";
    public static final String IS_NULL = " IS NULL";
    public static final String IS_NOT_NULL = " IS NOT NULL";

    public static String varchar(int length) {
        return "varchar(" + length + ')';
    }

    public static long getDayEpochMs(int day) {
        return TimeUnit.DAYS.toMillis((long)day + 2L);
    }

    public static void setStringOrNull(PreparedStatement statement, int index, String value) throws SQLException {
        if (value != null) {
            statement.setString(index, value);
        } else {
            statement.setNull(index, 12);
        }
    }

    public abstract String epochSecondToDate(String var1);

    public abstract String dateToEpochSecond(String var1);

    public abstract String dateToDayStamp(String var1);

    public abstract String dateToHourStamp(String var1);

    public abstract String dateToDayOfWeek(String var1);

    public abstract String dateToHour(String var1);

    public static class SQLite
    extends Sql {
        @Override
        public String epochSecondToDate(String sql) {
            return "datetime(" + sql + ", 'unixepoch')";
        }

        @Override
        public String dateToEpochSecond(String sql) {
            return "strftime('%s'," + sql + ")";
        }

        @Override
        public String dateToDayStamp(String sql) {
            return "strftime('%Y-%m-%d'," + sql + ')';
        }

        @Override
        public String dateToHourStamp(String sql) {
            return "strftime('%Y-%m-%d %H:00:00'," + sql + ')';
        }

        @Override
        public String dateToDayOfWeek(String sql) {
            return "strftime('%w'," + sql + ")+1";
        }

        @Override
        public String dateToHour(String sql) {
            return "strftime('%H'," + sql + ')';
        }
    }

    public static class H2
    extends MySQL {
        @Override
        public String epochSecondToDate(String sql) {
            return "DATEADD('SECOND', " + sql + ", DATE '1970-01-01')";
        }

        @Override
        public String dateToEpochSecond(String sql) {
            return "DATEDIFF('SECOND', DATE '1970-01-01', " + sql + ')';
        }

        @Override
        public String dateToDayOfWeek(String sql) {
            return "DAY_OF_WEEK(" + sql + ')';
        }

        @Override
        public String dateToHourStamp(String sql) {
            return "DATE_FORMAT(" + sql + ",'yyyy-MM-dd HH:00:00')";
        }

        @Override
        public String dateToHour(String sql) {
            return "HOUR(" + sql + ')';
        }
    }

    public static class MySQL
    extends Sql {
        @Override
        public String epochSecondToDate(String sql) {
            return "FROM_UNIXTIME(" + sql + ')';
        }

        @Override
        public String dateToEpochSecond(String sql) {
            return "UNIX_TIMESTAMP(" + sql + ')';
        }

        @Override
        public String dateToDayStamp(String sql) {
            return "DATE(" + sql + ')';
        }

        @Override
        public String dateToHourStamp(String sql) {
            return "DATE_FORMAT(" + sql + ",'%Y-%m-%d %H:00:00')";
        }

        @Override
        public String dateToDayOfWeek(String sql) {
            return "DAYOFWEEK(" + sql + ')';
        }

        @Override
        public String dateToHour(String sql) {
            return "HOUR(" + sql + ") % 24";
        }
    }
}

