/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plan.storage.database.sql.tables;

import com.djrapitops.plan.extension.icon.Color;
import com.djrapitops.plan.extension.icon.Family;
import com.djrapitops.plan.extension.icon.Icon;
import com.djrapitops.plan.storage.database.DBType;
import com.djrapitops.plan.storage.database.sql.building.CreateTableBuilder;
import com.djrapitops.plan.storage.database.sql.building.Sql;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import plan.org.apache.commons.lang3.StringUtils;

public class ExtensionIconTable {
    public static final String TABLE_NAME = "plan_extension_icons";
    public static final String ID = "id";
    public static final String ICON_NAME = "name";
    public static final String FAMILY = "family";
    public static final String COLOR = "color";
    public static final String STATEMENT_SELECT_ICON_ID = "(SELECT id FROM plan_extension_icons WHERE name=? AND family=? AND color=? LIMIT 1)";

    public static void set3IconValuesToStatement(PreparedStatement statement, Icon icon) throws SQLException {
        ExtensionIconTable.set3IconValuesToStatement(statement, 1, icon);
    }

    public static void set3IconValuesToStatement(PreparedStatement statement, int parameterIndex, Icon icon) throws SQLException {
        if (icon != null) {
            statement.setString(parameterIndex, StringUtils.truncate(icon.getName(), 50));
            statement.setString(parameterIndex + 1, icon.getFamily().name());
            statement.setString(parameterIndex + 2, icon.getColor().name());
        } else {
            statement.setNull(parameterIndex, 12);
            statement.setNull(parameterIndex + 1, 12);
            statement.setNull(parameterIndex + 2, 12);
        }
    }

    private ExtensionIconTable() {
    }

    public static String createTableSQL(DBType dbType) {
        return CreateTableBuilder.create(TABLE_NAME, dbType).column(ID, "integer").primaryKey().column(ICON_NAME, Sql.varchar(50)).notNull().defaultValue("'question'").column(FAMILY, Sql.varchar(15)).notNull().defaultValue("'" + Family.SOLID.name() + "'").column(COLOR, Sql.varchar(25)).notNull().defaultValue("'" + Color.NONE.name() + "'").build();
    }
}

