/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plan.storage.database.sql.tables;

import com.djrapitops.plan.storage.database.DBType;
import com.djrapitops.plan.storage.database.sql.building.CreateTableBuilder;
import com.djrapitops.plan.storage.database.sql.building.Sql;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.UUID;

public class ExtensionPluginTable {
    public static final String TABLE_NAME = "plan_extension_plugins";
    public static final String ID = "id";
    public static final String PLUGIN_NAME = "name";
    public static final String LAST_UPDATED = "last_updated";
    public static final String SERVER_UUID = "server_uuid";
    public static final String ICON_ID = "icon_id";
    public static final String STATEMENT_SELECT_PLUGIN_ID = "(SELECT id FROM plan_extension_plugins WHERE name=? AND server_uuid=? LIMIT 1)";

    public static void set2PluginValuesToStatement(PreparedStatement statement, int parameterIndex, String pluginName, UUID serverUUID) throws SQLException {
        statement.setString(parameterIndex, pluginName);
        statement.setString(parameterIndex + 1, serverUUID.toString());
    }

    private ExtensionPluginTable() {
    }

    public static String createTableSQL(DBType dbType) {
        return CreateTableBuilder.create(TABLE_NAME, dbType).column(ID, "integer").primaryKey().column(PLUGIN_NAME, Sql.varchar(50)).notNull().column(LAST_UPDATED, "bigint").notNull().column(SERVER_UUID, Sql.varchar(36)).notNull().column(ICON_ID, "integer").notNull().foreignKey(ICON_ID, "plan_extension_icons", ID).build();
    }
}

