/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plan.storage.database.sql.tables;

import com.djrapitops.plan.storage.database.DBType;
import com.djrapitops.plan.storage.database.sql.building.CreateTableBuilder;
import com.djrapitops.plan.storage.database.sql.building.Sql;
import com.djrapitops.plan.storage.database.sql.tables.ExtensionPluginTable;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.UUID;

public class ExtensionProviderTable {
    public static final String TABLE_NAME = "plan_extension_providers";
    public static final String ID = "id";
    public static final String PROVIDER_NAME = "name";
    public static final String TEXT = "text";
    public static final String DESCRIPTION = "description";
    public static final String PRIORITY = "priority";
    public static final String GROUPABLE = "groupable";
    public static final String CONDITION = "condition_name";
    public static final String PLUGIN_ID = "plugin_id";
    public static final String ICON_ID = "icon_id";
    public static final String TAB_ID = "tab_id";
    public static final String SHOW_IN_PLAYERS_TABLE = "show_in_players_table";
    public static final String HIDDEN = "hidden";
    public static final String PROVIDED_CONDITION = "provided_condition";
    public static final String FORMAT_TYPE = "format_type";
    public static final String IS_PLAYER_NAME = "player_name";
    public static final String STATEMENT_SELECT_PROVIDER_ID = "(SELECT id FROM plan_extension_providers WHERE name=? AND plugin_id=(SELECT id FROM plan_extension_plugins WHERE name=? AND server_uuid=? LIMIT 1) LIMIT 1)";

    public static void set3PluginValuesToStatement(PreparedStatement statement, int parameterIndex, String providerName, String pluginName, UUID serverUUID) throws SQLException {
        statement.setString(parameterIndex, providerName);
        ExtensionPluginTable.set2PluginValuesToStatement(statement, parameterIndex + 1, pluginName, serverUUID);
    }

    private ExtensionProviderTable() {
    }

    public static String createTableSQL(DBType dbType) {
        return CreateTableBuilder.create(TABLE_NAME, dbType).column(ID, "integer").primaryKey().column(PROVIDER_NAME, Sql.varchar(50)).notNull().column(TEXT, Sql.varchar(50)).notNull().column(DESCRIPTION, Sql.varchar(150)).column(PRIORITY, "integer").notNull().defaultValue("0").column(SHOW_IN_PLAYERS_TABLE, "boolean").notNull().defaultValue(false).column(GROUPABLE, "boolean").notNull().defaultValue(false).column(CONDITION, Sql.varchar(54)).column(PROVIDED_CONDITION, Sql.varchar(50)).column(FORMAT_TYPE, Sql.varchar(25)).column(HIDDEN, "boolean").notNull().defaultValue(false).column(IS_PLAYER_NAME, "boolean").notNull().defaultValue(false).column(PLUGIN_ID, "integer").notNull().column(ICON_ID, "integer").notNull().column(TAB_ID, "integer").foreignKey(PLUGIN_ID, "plan_extension_plugins", ID).foreignKey(ICON_ID, "plan_extension_icons", ID).foreignKey(TAB_ID, "plan_extension_tabs", ID).build();
    }
}

