/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plan.storage.database.sql.tables;

import com.djrapitops.plan.extension.ElementOrder;
import com.djrapitops.plan.storage.database.DBType;
import com.djrapitops.plan.storage.database.sql.building.CreateTableBuilder;
import com.djrapitops.plan.storage.database.sql.building.Sql;
import com.djrapitops.plan.storage.database.sql.tables.ExtensionPluginTable;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.UUID;

public class ExtensionTabTable {
    public static final String TABLE_NAME = "plan_extension_tabs";
    public static final String ID = "id";
    public static final String TAB_NAME = "name";
    public static final String ELEMENT_ORDER = "element_order";
    public static final String TAB_PRIORITY = "tab_priority";
    public static final String PLUGIN_ID = "plugin_id";
    public static final String ICON_ID = "icon_id";
    public static final String STATEMENT_SELECT_TAB_ID = "(SELECT id FROM plan_extension_tabs WHERE name=? AND plugin_id=(SELECT id FROM plan_extension_plugins WHERE name=? AND server_uuid=? LIMIT 1) LIMIT 1)";

    public static void set3TabValuesToStatement(PreparedStatement statement, int parameterIndex, String tabName, String pluginName, UUID serverUUID) throws SQLException {
        Sql.setStringOrNull(statement, parameterIndex, tabName);
        ExtensionPluginTable.set2PluginValuesToStatement(statement, parameterIndex + 1, pluginName, serverUUID);
    }

    private ExtensionTabTable() {
    }

    public static String createTableSQL(DBType dbType) {
        return CreateTableBuilder.create(TABLE_NAME, dbType).column(ID, "integer").primaryKey().column(TAB_NAME, Sql.varchar(50)).notNull().column(ELEMENT_ORDER, Sql.varchar(100)).notNull().defaultValue("'" + ElementOrder.serialize(ElementOrder.values()) + "'").column(TAB_PRIORITY, "integer").notNull().column(PLUGIN_ID, "integer").notNull().column(ICON_ID, "integer").notNull().foreignKey(PLUGIN_ID, "plan_extension_plugins", ID).foreignKey(ICON_ID, "plan_extension_icons", ID).build();
    }
}

