/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plan.storage.database.sql.tables;

import com.djrapitops.plan.extension.icon.Color;
import com.djrapitops.plan.storage.database.DBType;
import com.djrapitops.plan.storage.database.sql.building.CreateTableBuilder;
import com.djrapitops.plan.storage.database.sql.building.Sql;
import com.djrapitops.plan.storage.database.sql.tables.ExtensionPluginTable;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.UUID;

public class ExtensionTableProviderTable {
    public static final String TABLE_NAME = "plan_extension_tables";
    public static final String ID = "id";
    public static final String PROVIDER_NAME = "name";
    public static final String COLOR = "color";
    public static final String CONDITION = "condition_name";
    public static final String PLUGIN_ID = "plugin_id";
    public static final String TAB_ID = "tab_id";
    public static final String COL_1 = "col_1_name";
    public static final String COL_2 = "col_2_name";
    public static final String COL_3 = "col_3_name";
    public static final String COL_4 = "col_4_name";
    public static final String COL_5 = "col_5_name";
    public static final String ICON_1_ID = "icon_1_id";
    public static final String ICON_2_ID = "icon_2_id";
    public static final String ICON_3_ID = "icon_3_id";
    public static final String ICON_4_ID = "icon_4_id";
    public static final String ICON_5_ID = "icon_5_id";
    public static final String STATEMENT_SELECT_TABLE_ID = "(SELECT id FROM plan_extension_tables WHERE name=? AND plugin_id=(SELECT id FROM plan_extension_plugins WHERE name=? AND server_uuid=? LIMIT 1) LIMIT 1)";

    private ExtensionTableProviderTable() {
    }

    public static void set3PluginValuesToStatement(PreparedStatement statement, int parameterIndex, String providerName, String pluginName, UUID serverUUID) throws SQLException {
        statement.setString(parameterIndex, providerName);
        ExtensionPluginTable.set2PluginValuesToStatement(statement, parameterIndex + 1, pluginName, serverUUID);
    }

    public static String createTableSQL(DBType dbType) {
        return CreateTableBuilder.create(TABLE_NAME, dbType).column(ID, "integer").primaryKey().column(PROVIDER_NAME, Sql.varchar(50)).notNull().column(COLOR, Sql.varchar(25)).notNull().defaultValue("'" + Color.NONE.name() + "'").column(CONDITION, Sql.varchar(54)).column(COL_1, Sql.varchar(50)).column(COL_2, Sql.varchar(50)).column(COL_3, Sql.varchar(50)).column(COL_4, Sql.varchar(50)).column(COL_5, Sql.varchar(50)).column(PLUGIN_ID, "integer").notNull().column(ICON_1_ID, "integer").column(ICON_2_ID, "integer").column(ICON_3_ID, "integer").column(ICON_4_ID, "integer").column(ICON_5_ID, "integer").column(TAB_ID, "integer").foreignKey(PLUGIN_ID, "plan_extension_plugins", ID).foreignKey(ICON_1_ID, "plan_extension_icons", ID).foreignKey(ICON_2_ID, "plan_extension_icons", ID).foreignKey(ICON_3_ID, "plan_extension_icons", ID).foreignKey(ICON_4_ID, "plan_extension_icons", ID).foreignKey(ICON_5_ID, "plan_extension_icons", ID).foreignKey(TAB_ID, "plan_extension_tabs", ID).build();
    }
}

