/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plan.storage.database.sql.tables;

import com.djrapitops.plan.delivery.domain.keys.SessionKeys;
import com.djrapitops.plan.gathering.domain.PlayerKill;
import com.djrapitops.plan.gathering.domain.Session;
import com.djrapitops.plan.storage.database.DBType;
import com.djrapitops.plan.storage.database.sql.building.CreateTableBuilder;
import com.djrapitops.plan.storage.database.sql.building.Sql;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.UUID;
import plan.org.apache.commons.lang3.StringUtils;

public class KillsTable {
    public static final String TABLE_NAME = "plan_kills";
    public static final String ID = "id";
    public static final String KILLER_UUID = "killer_uuid";
    public static final String VICTIM_UUID = "victim_uuid";
    public static final String SERVER_UUID = "server_uuid";
    public static final String SESSION_ID = "session_id";
    public static final String WEAPON = "weapon";
    public static final String DATE = "date";
    public static final int WEAPON_COLUMN_LENGTH = 30;
    public static final String INSERT_STATEMENT = "INSERT INTO plan_kills (session_id,killer_uuid,victim_uuid,server_uuid,date,weapon) VALUES ((SELECT plan_sessions.id FROM plan_sessions WHERE plan_sessions.uuid=? AND plan_sessions.server_uuid=? AND session_start=? AND session_end=? LIMIT 1), ?, ?, ?, ?, ?)";

    private KillsTable() {
    }

    public static String createTableSQL(DBType dbType) {
        return CreateTableBuilder.create(TABLE_NAME, dbType).column(ID, "integer").primaryKey().column(KILLER_UUID, Sql.varchar(36)).notNull().column(VICTIM_UUID, Sql.varchar(36)).notNull().column(SERVER_UUID, Sql.varchar(36)).notNull().column(WEAPON, Sql.varchar(30)).notNull().column(DATE, "bigint").notNull().column(SESSION_ID, "integer").notNull().foreignKey(SESSION_ID, "plan_sessions", ID).toString();
    }

    public static void addSessionKillsToBatch(PreparedStatement statement, Session session) throws SQLException {
        UUID uuid = session.getUnsafe(SessionKeys.UUID);
        UUID serverUUID = session.getUnsafe(SessionKeys.SERVER_UUID);
        for (PlayerKill kill : session.getPlayerKills()) {
            statement.setString(1, uuid.toString());
            statement.setString(2, serverUUID.toString());
            statement.setLong(3, session.getUnsafe(SessionKeys.START));
            statement.setLong(4, session.getUnsafe(SessionKeys.END));
            statement.setString(5, uuid.toString());
            statement.setString(6, kill.getVictim().toString());
            statement.setString(7, serverUUID.toString());
            statement.setLong(8, kill.getDate());
            statement.setString(9, StringUtils.truncate(kill.getWeapon(), 30));
            statement.addBatch();
        }
    }
}

