/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plan.storage.database.sql.tables;

import com.djrapitops.plan.delivery.domain.keys.SessionKeys;
import com.djrapitops.plan.gathering.domain.GMTimes;
import com.djrapitops.plan.gathering.domain.Session;
import com.djrapitops.plan.storage.database.DBType;
import com.djrapitops.plan.storage.database.sql.building.CreateTableBuilder;
import com.djrapitops.plan.storage.database.sql.building.Sql;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Map;
import java.util.UUID;

public class WorldTimesTable {
    public static final String TABLE_NAME = "plan_world_times";
    public static final String ID = "id";
    public static final String USER_UUID = "uuid";
    public static final String SERVER_UUID = "server_uuid";
    public static final String SESSION_ID = "session_id";
    public static final String WORLD_ID = "world_id";
    public static final String SURVIVAL = "survival_time";
    public static final String CREATIVE = "creative_time";
    public static final String ADVENTURE = "adventure_time";
    public static final String SPECTATOR = "spectator_time";
    public static final String INSERT_STATEMENT = "INSERT INTO plan_world_times (session_id,world_id,uuid,server_uuid,survival_time,creative_time,adventure_time,spectator_time) VALUES ( (SELECT plan_sessions.id FROM plan_sessions WHERE plan_sessions.uuid=? AND plan_sessions.server_uuid=? AND session_start=? AND session_end=? LIMIT 1),(SELECT plan_worlds.id FROM plan_worlds WHERE (world_name=?) AND (plan_worlds.server_uuid=?) LIMIT 1),?, ?, ?, ?, ?, ?)";

    private WorldTimesTable() {
    }

    public static String createTableSQL(DBType dbType) {
        return CreateTableBuilder.create(TABLE_NAME, dbType).column(ID, "integer").primaryKey().column(USER_UUID, Sql.varchar(36)).notNull().column(WORLD_ID, "integer").notNull().column(SERVER_UUID, Sql.varchar(36)).notNull().column(SESSION_ID, "integer").notNull().column(SURVIVAL, "bigint").notNull().defaultValue("0").column(CREATIVE, "bigint").notNull().defaultValue("0").column(ADVENTURE, "bigint").notNull().defaultValue("0").column(SPECTATOR, "bigint").notNull().defaultValue("0").foreignKey(WORLD_ID, "plan_worlds", ID).foreignKey(SESSION_ID, "plan_sessions", ID).toString();
    }

    public static void addSessionWorldTimesToBatch(PreparedStatement statement, Session session, String[] gms) throws SQLException {
        UUID uuid = session.getUnsafe(SessionKeys.UUID);
        UUID serverUUID = session.getUnsafe(SessionKeys.SERVER_UUID);
        Map<String, GMTimes> worldTimes = session.getUnsafe(SessionKeys.WORLD_TIMES).getWorldTimes();
        for (Map.Entry<String, GMTimes> worldTimesEntry : worldTimes.entrySet()) {
            String worldName = worldTimesEntry.getKey();
            GMTimes gmTimes = worldTimesEntry.getValue();
            statement.setString(1, uuid.toString());
            statement.setString(2, serverUUID.toString());
            statement.setLong(3, session.getUnsafe(SessionKeys.START));
            statement.setLong(4, session.getUnsafe(SessionKeys.END));
            statement.setString(5, worldName);
            statement.setString(6, serverUUID.toString());
            statement.setString(7, uuid.toString());
            statement.setString(8, serverUUID.toString());
            statement.setLong(9, gmTimes.getTime(gms[0]));
            statement.setLong(10, gmTimes.getTime(gms[1]));
            statement.setLong(11, gmTimes.getTime(gms[2]));
            statement.setLong(12, gmTimes.getTime(gms[3]));
            statement.addBatch();
        }
    }
}

