/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plan.storage.database.transactions;

import com.djrapitops.plan.storage.database.Database;
import com.djrapitops.plan.storage.database.queries.LargeFetchQueries;
import com.djrapitops.plan.storage.database.queries.LargeStoreQueries;
import com.djrapitops.plan.storage.database.queries.Query;
import com.djrapitops.plan.storage.database.queries.objects.BaseUserQueries;
import com.djrapitops.plan.storage.database.queries.objects.GeoInfoQueries;
import com.djrapitops.plan.storage.database.queries.objects.NicknameQueries;
import com.djrapitops.plan.storage.database.queries.objects.PingQueries;
import com.djrapitops.plan.storage.database.queries.objects.ServerQueries;
import com.djrapitops.plan.storage.database.queries.objects.SessionQueries;
import com.djrapitops.plan.storage.database.queries.objects.UserInfoQueries;
import com.djrapitops.plan.storage.database.queries.objects.WebUserQueries;
import com.djrapitops.plan.storage.database.transactions.Executable;
import com.djrapitops.plan.storage.database.transactions.commands.RemoveEverythingTransaction;
import java.util.function.Function;

public class BackupCopyTransaction
extends RemoveEverythingTransaction {
    private final Database sourceDB;
    private final Database destinationDB;

    public BackupCopyTransaction(Database sourceDB, Database destinationDB) {
        this.sourceDB = sourceDB;
        this.destinationDB = destinationDB;
    }

    @Override
    protected boolean shouldBeExecuted() {
        return super.shouldBeExecuted() && !this.sourceDB.equals(this.destinationDB) && this.sourceDB.getState() != Database.State.CLOSED;
    }

    @Override
    protected void performOperations() {
        super.performOperations();
        this.copyPlanServerInformation();
        this.copyCommonUserInformation();
        this.copyWorldNames();
        this.copyTPSData();
        this.copyPlanWebUsers();
        this.copyGeoInformation();
        this.copyNicknameData();
        this.copySessionsWithKillAndWorldData();
        this.copyPerServerUserInformation();
        this.copyPingData();
    }

    private <T> void copy(Function<T, Executable> executableCreator, Query<T> dataQuery) {
        this.execute(executableCreator.apply(this.sourceDB.query(dataQuery)));
    }

    private void copyPingData() {
        this.copy(LargeStoreQueries::storeAllPingData, PingQueries.fetchAllPingData());
    }

    private void copyGeoInformation() {
        this.copy(LargeStoreQueries::storeAllGeoInformation, GeoInfoQueries.fetchAllGeoInformation());
    }

    private void copyNicknameData() {
        this.copy(LargeStoreQueries::storeAllNicknameData, NicknameQueries.fetchAllNicknameData());
    }

    private void copyPlanWebUsers() {
        this.copy(LargeStoreQueries::storeAllPlanWebUsers, WebUserQueries.fetchAllUsers());
    }

    private void copyPlanServerInformation() {
        this.copy(LargeStoreQueries::storeAllPlanServerInformation, ServerQueries.fetchPlanServerInformationCollection());
    }

    private void copyTPSData() {
        this.copy(LargeStoreQueries::storeAllTPSData, LargeFetchQueries.fetchAllTPSData());
    }

    private void copyPerServerUserInformation() {
        this.copy(LargeStoreQueries::storePerServerUserInformation, UserInfoQueries.fetchAllUserInformation());
    }

    private void copyWorldNames() {
        this.copy(LargeStoreQueries::storeAllWorldNames, LargeFetchQueries.fetchAllWorldNames());
    }

    private void copyCommonUserInformation() {
        this.copy(LargeStoreQueries::storeAllCommonUserInformation, BaseUserQueries.fetchAllBaseUsers());
    }

    private void copySessionsWithKillAndWorldData() {
        this.copy(LargeStoreQueries::storeAllSessionsWithKillAndWorldData, SessionQueries.fetchAllSessions());
    }
}

