/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plan.storage.database.transactions;

import com.djrapitops.plan.exceptions.database.DBOpException;
import com.djrapitops.plan.storage.database.transactions.Executable;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;

public abstract class ExecStatement
implements Executable {
    private final String sql;

    public ExecStatement(String sql) {
        this.sql = sql;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean execute(Connection connection) {
        try (PreparedStatement preparedStatement = connection.prepareStatement(this.sql);){
            boolean bl = this.execute(preparedStatement);
            return bl;
        }
        catch (SQLException e) {
            throw DBOpException.forCause(this.sql, e);
        }
    }

    public boolean execute(PreparedStatement statement) throws SQLException {
        try {
            this.prepare(statement);
            boolean bl = this.callExecute(statement);
            return bl;
        }
        finally {
            statement.close();
        }
    }

    protected boolean callExecute(PreparedStatement statement) throws SQLException {
        if (this.sql.startsWith("UPDATE") || this.sql.startsWith("INSERT") || this.sql.startsWith("DELETE") || this.sql.startsWith("REPLACE")) {
            return statement.executeUpdate() > 0;
        }
        statement.execute();
        return false;
    }

    public abstract void prepare(PreparedStatement var1) throws SQLException;

    public String getSql() {
        return this.sql;
    }
}

