/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plan.storage.database.transactions;

import com.djrapitops.plan.settings.config.Config;
import com.djrapitops.plan.settings.config.ConfigWriter;
import com.djrapitops.plan.storage.database.queries.HasMoreThanZeroQueryStatement;
import com.djrapitops.plan.storage.database.queries.Query;
import com.djrapitops.plan.storage.database.transactions.ExecStatement;
import com.djrapitops.plan.storage.database.transactions.Executable;
import com.djrapitops.plan.storage.database.transactions.Transaction;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.List;
import java.util.UUID;
import plan.org.apache.commons.text.TextStringBuilder;

public class StoreConfigTransaction
extends Transaction {
    private final UUID serverUUID;
    private final long lastModified;
    private final String configSettings;

    public StoreConfigTransaction(UUID serverUUID, Config config, long lastModified) {
        this.serverUUID = serverUUID;
        this.configSettings = this.extractConfigSettingLines(config);
        this.lastModified = lastModified;
    }

    private String extractConfigSettingLines(Config config) {
        TextStringBuilder configTextBuilder = new TextStringBuilder();
        List<String> lines = new ConfigWriter().createLines(config);
        configTextBuilder.appendWithSeparators(lines, "\n");
        return configTextBuilder.toString();
    }

    @Override
    protected void performOperations() {
        if (this.query(this.isConfigStored()).booleanValue()) {
            this.execute(this.updateConfig());
        } else {
            this.execute(this.insertConfig());
        }
    }

    private Query<Boolean> isConfigStored() {
        String sql = "SELECT COUNT(1) as c FROM plan_settings WHERE server_uuid=? LIMIT 1";
        return new HasMoreThanZeroQueryStatement(sql){

            @Override
            public void prepare(PreparedStatement statement) throws SQLException {
                statement.setString(1, StoreConfigTransaction.this.serverUUID.toString());
            }
        };
    }

    private Executable updateConfig() {
        return new ExecStatement("UPDATE plan_settings SET content=?,updated=? WHERE server_uuid=? AND content!=?"){

            @Override
            public void prepare(PreparedStatement statement) throws SQLException {
                statement.setString(1, StoreConfigTransaction.this.configSettings);
                statement.setLong(2, StoreConfigTransaction.this.lastModified);
                statement.setString(3, StoreConfigTransaction.this.serverUUID.toString());
                statement.setString(4, StoreConfigTransaction.this.configSettings);
            }
        };
    }

    private Executable insertConfig() {
        return new ExecStatement("INSERT INTO plan_settings (server_uuid,updated,content) VALUES (?,?,?)"){

            @Override
            public void prepare(PreparedStatement statement) throws SQLException {
                statement.setString(1, StoreConfigTransaction.this.serverUUID.toString());
                statement.setLong(2, StoreConfigTransaction.this.lastModified);
                statement.setString(3, StoreConfigTransaction.this.configSettings);
            }
        };
    }
}

