/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plan.storage.database.transactions;

import com.djrapitops.plan.identification.Server;
import com.djrapitops.plan.storage.database.sql.tables.ServerTable;
import com.djrapitops.plan.storage.database.transactions.ExecStatement;
import com.djrapitops.plan.storage.database.transactions.Executable;
import com.djrapitops.plan.storage.database.transactions.Transaction;
import java.sql.PreparedStatement;
import java.sql.SQLException;

public class StoreServerInformationTransaction
extends Transaction {
    private final Server server;

    public StoreServerInformationTransaction(Server server) {
        this.server = server;
    }

    @Override
    protected void performOperations() {
        if (!this.execute(this.updateServerInformation())) {
            this.execute(this.insertServerInformation());
        }
    }

    private Executable updateServerInformation() {
        return new ExecStatement(ServerTable.UPDATE_STATEMENT){

            @Override
            public void prepare(PreparedStatement statement) throws SQLException {
                String serverUUIDString = StoreServerInformationTransaction.this.server.getUuid().toString();
                statement.setString(1, serverUUIDString);
                statement.setString(2, StoreServerInformationTransaction.this.server.getName());
                statement.setString(3, StoreServerInformationTransaction.this.server.getWebAddress());
                statement.setBoolean(4, true);
                statement.setInt(5, StoreServerInformationTransaction.this.server.getMaxPlayers());
                statement.setString(6, serverUUIDString);
            }
        };
    }

    private Executable insertServerInformation() {
        return new ExecStatement(ServerTable.INSERT_STATEMENT){

            @Override
            public void prepare(PreparedStatement statement) throws SQLException {
                statement.setString(1, StoreServerInformationTransaction.this.server.getUuid().toString());
                statement.setString(2, StoreServerInformationTransaction.this.server.getName());
                statement.setString(3, StoreServerInformationTransaction.this.server.getWebAddress());
                statement.setBoolean(4, true);
                statement.setInt(5, StoreServerInformationTransaction.this.server.getMaxPlayers());
            }
        };
    }
}

