/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plan.storage.database.transactions;

import com.djrapitops.plan.exceptions.database.DBOpException;
import com.djrapitops.plan.storage.database.DBType;
import com.djrapitops.plan.storage.database.Database;
import com.djrapitops.plan.storage.database.SQLDB;
import com.djrapitops.plan.storage.database.queries.Query;
import com.djrapitops.plan.storage.database.transactions.ExecStatement;
import com.djrapitops.plan.storage.database.transactions.Executable;
import com.djrapitops.plugin.utilities.Verify;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLTransactionRollbackException;
import java.sql.Savepoint;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;

public abstract class Transaction {
    private static final AtomicBoolean SUPPORTS_SAVE_POINTS = new AtomicBoolean(true);
    private static final int ATTEMPT_LIMIT = 3;
    private SQLDB db;
    protected DBType dbType;
    private Connection connection;
    private Savepoint savepoint;
    protected boolean success = false;
    protected int attempts = 0;

    protected Transaction() {
    }

    public void executeTransaction(SQLDB db) {
        Verify.nullCheck(db, () -> new IllegalArgumentException("Given database was null"));
        Verify.isFalse(this.success, () -> new IllegalStateException("Transaction has already been executed"));
        this.db = db;
        this.dbType = db.getType();
        if (!this.shouldBeExecuted()) {
            this.success = true;
            return;
        }
        ++this.attempts;
        try {
            this.initializeTransaction(db);
            this.performOperations();
            if (this.connection != null) {
                this.connection.commit();
            }
            this.success = true;
        }
        catch (SQLException statementFail) {
            this.manageFailure(statementFail);
        }
        finally {
            db.returnToPool(this.connection);
        }
    }

    private void manageFailure(SQLException statementFail) {
        boolean deadlocked;
        String failMsg = this.getClass().getSimpleName() + " failed: " + statementFail.getMessage();
        String rollbackStatusMsg = this.rollbackTransaction();
        int errorCode = statementFail.getErrorCode();
        boolean mySQLDeadlock = this.dbType == DBType.MYSQL && errorCode == 1213;
        boolean h2Deadlock = this.dbType == DBType.H2 && errorCode == 40001;
        boolean bl = deadlocked = mySQLDeadlock || h2Deadlock || statementFail instanceof SQLTransactionRollbackException;
        if (deadlocked && this.attempts < 3) {
            this.executeTransaction(this.db);
            return;
        }
        if (this.attempts >= 3) {
            failMsg = failMsg + " (Attempted " + this.attempts + " times)";
        }
        throw new DBOpException(failMsg + rollbackStatusMsg, statementFail);
    }

    private String rollbackTransaction() {
        boolean hasNoSavepoints;
        String rollbackStatusMsg = ", Transaction was rolled back.";
        boolean bl = hasNoSavepoints = !SUPPORTS_SAVE_POINTS.get();
        if (hasNoSavepoints) {
            rollbackStatusMsg = ", additionally rollbacks are not supported on this server version.";
        } else {
            try {
                if (Verify.notNull(this.connection, this.savepoint)) {
                    this.connection.rollback(this.savepoint);
                }
            }
            catch (SQLException rollbackFail) {
                rollbackStatusMsg = ", additionally Transaction rollback failed: " + rollbackFail.getMessage();
            }
        }
        return rollbackStatusMsg;
    }

    protected boolean shouldBeExecuted() {
        return true;
    }

    protected abstract void performOperations();

    private void initializeTransaction(SQLDB db) {
        try {
            this.connection = db.getConnection();
            this.createSavePoint();
        }
        catch (SQLException e) {
            throw new DBOpException(this.getClass().getSimpleName() + " initialization failed: " + e.getMessage(), e);
        }
    }

    private void createSavePoint() throws SQLException {
        try {
            this.savepoint = this.connection.setSavepoint();
        }
        catch (SQLFeatureNotSupportedException noSavePoints) {
            SUPPORTS_SAVE_POINTS.set(false);
        }
        catch (SQLException sqlException) {
            this.handleUnsupportedSQLiteSavePoints(sqlException);
        }
    }

    private void handleUnsupportedSQLiteSavePoints(SQLException sqlException) throws SQLException {
        String errorMsg = sqlException.getMessage();
        if (!errorMsg.contains("unsupported") || !errorMsg.contains("savepoints")) {
            throw sqlException;
        }
        SUPPORTS_SAVE_POINTS.set(false);
    }

    protected <T> T query(Query<T> query) {
        return query.executeQuery(this.db);
    }

    protected boolean execute(Executable executable) {
        return executable.execute(this.connection);
    }

    protected boolean execute(String sql) {
        return this.execute(new ExecStatement(sql){

            @Override
            public void prepare(PreparedStatement statement) {
            }
        });
    }

    protected void executeSwallowingExceptions(String ... statements) {
        Verify.nullCheck(statements);
        for (String statement : statements) {
            try {
                this.execute(statement);
            }
            catch (DBOpException dBOpException) {
                // empty catch block
            }
        }
    }

    protected void executeOther(Transaction transaction) {
        transaction.db = this.db;
        transaction.dbType = this.dbType;
        transaction.connection = this.connection;
        transaction.performOperations();
        transaction.connection = null;
        transaction.dbType = null;
        transaction.db = null;
    }

    protected Database.State getDBState() {
        return this.db.getState();
    }

    protected UUID getServerUUID() {
        return this.db.getServerUUIDSupplier().get();
    }

    public String toString() {
        return this.getClass().getSimpleName() + (this.success ? " (finished)" : "");
    }

    public boolean wasSuccessful() {
        return this.success;
    }
}

