/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plan.storage.database.transactions.commands;

import com.djrapitops.plan.storage.database.queries.PlayerFetchQueries;
import com.djrapitops.plan.storage.database.transactions.ExecStatement;
import com.djrapitops.plan.storage.database.transactions.ThrowawayTransaction;
import com.djrapitops.plan.storage.database.transactions.commands.RemoveWebUserTransaction;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.UUID;

public class RemovePlayerTransaction
extends ThrowawayTransaction {
    private final UUID playerUUID;

    public RemovePlayerTransaction(UUID playerUUID) {
        this.playerUUID = playerUUID;
    }

    @Override
    protected boolean shouldBeExecuted() {
        return this.playerUUID != null;
    }

    @Override
    protected void performOperations() {
        this.query(PlayerFetchQueries.playerUserName(this.playerUUID)).ifPresent(this::deleteWebUser);
        this.deleteFromTable("plan_geolocations");
        this.deleteFromTable("plan_nicknames");
        this.deleteFromKillsTable();
        this.deleteFromTable("plan_world_times");
        this.deleteFromTable("plan_sessions");
        this.deleteFromTable("plan_ping");
        this.deleteFromTable("plan_user_info");
        this.deleteFromTable("plan_users");
        this.deleteFromTable("plan_extension_user_table_values");
        this.deleteFromTable("plan_extension_user_values");
        this.deleteFromTable("plan_extension_groups");
    }

    private void deleteWebUser(String username) {
        this.executeOther(new RemoveWebUserTransaction(username));
    }

    private void deleteFromTable(String tableName) {
        this.execute(new ExecStatement("DELETE FROM " + tableName + " WHERE " + "uuid=?"){

            @Override
            public void prepare(PreparedStatement statement) throws SQLException {
                statement.setString(1, RemovePlayerTransaction.this.playerUUID.toString());
            }
        });
    }

    private void deleteFromKillsTable() {
        String sql = "DELETE FROM plan_kills WHERE killer_uuid=? OR victim_uuid=?";
        this.execute(new ExecStatement(sql){

            @Override
            public void prepare(PreparedStatement statement) throws SQLException {
                statement.setString(1, RemovePlayerTransaction.this.playerUUID.toString());
                statement.setString(2, RemovePlayerTransaction.this.playerUUID.toString());
            }
        });
    }
}

